/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.UIResourceGroup;
import com.ericsson.cms.sites.ui.client.entities.UITemplateInfo;
import com.ericsson.cms.sites.ui.client.entities.UITemplateVariable;
import com.ericsson.cms.sites.ui.client.entities.UITemplateVariableDataType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DistConfPanel
extends Composite {
    private VerticalContainer mainPanel;
    private HorizontalContainer listBoxContainer;
    private ListBoxWidget<UITemplateInfo> confListBox;
    private FormContainer form;
    private Map<String, TextBoxWidget> paramWidgets = new HashMap<String, TextBoxWidget>();
    private ListBoxWidget<Long> resourcesListBox;
    private ListBoxWidget<Long> groupsListBox;
    private ImageWidget isNotLoadedImage;
    Collection<UIResourceGroup> groupsResult;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages messages = (SitesMessages)GWT.create(SitesMessages.class);
    private ISiteClientBundle clientBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);
    private boolean isAssociatedResourceRequiredField = false;
    private static final String PARAM_VALUE_DATE_FORMAT = "yyyy-MM-dd";
    private static final String NOT_LOAD_STYLE = "not_loaded_image";

    public DistConfPanel() {
        this.initWidgets();
        this.initWidget((Widget)this.mainPanel);
    }

    private void initWidgets() {
        this.mainPanel = new VerticalContainer();
        this.listBoxContainer = new HorizontalContainer();
        this.listBoxContainer.setSpacing(1);
        this.isNotLoadedImage = new ImageWidget();
        this.isNotLoadedImage.setResource(this.clientBundle.sitePluginConfigurationError());
        this.isNotLoadedImage.addStyleName(NOT_LOAD_STYLE);
        this.isNotLoadedImage.setTitle(this.constants.invalidTemplate());
        this.isNotLoadedImage.setVisible(false);
        this.listBoxContainer.add((Widget)this.isNotLoadedImage);
        this.confListBox = new ListBoxWidget();
        this.confListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DistConfPanel.this.updateForm((UITemplateInfo)DistConfPanel.this.confListBox.getSelectedItem(), null, null);
            }
        });
        this.listBoxContainer.add(this.confListBox);
        this.mainPanel.add((Widget)this.listBoxContainer);
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.resourcesListBox = new ListBoxWidget();
        this.mainPanel.add((Widget)this.form);
    }

    private void updateForm(final UITemplateInfo ti, Map<String, String> paramValues, final Long resourceId) {
        this.busyIndicator.center();
        if (ti == null) {
            this.isNotLoadedImage.setVisible(false);
            this.setSelectedTemplateInfo(null);
            this.setParams(null);
            this.setParamValues(null);
            this.resourcesListBox = new ListBoxWidget();
            this.groupsListBox = new ListBoxWidget();
            this.busyIndicator.hide();
        } else {
            this.isNotLoadedImage.setVisible(!ti.isLoaded());
            this.setSelectedTemplateInfo(ti);
            this.setParams(ti.getRequiredVariables());
            this.setParamValues(paramValues);
            this.resourcesListBox = new ListBoxWidget();
            this.groupsListBox = new ListBoxWidget();
            final String rgName = ti.getAssociatedResourceGroupName();
            this.isAssociatedResourceRequiredField = false;
            this.form.addRow("Associated Group", this.groupsListBox, false);
            this.service.getAllGroupsByTemplateId(ti.getTemplateId(), (AsyncCallback<Collection<UIResourceGroup>>)new NeptuneAsyncCallback<Collection<UIResourceGroup>>(){

                public void onNeptuneFailure(Throwable caught) {
                    DistConfPanel.this.busyIndicator.hide();
                }

                public void onNeptuneSuccess(Collection<UIResourceGroup> result) {
                    if (result != null) {
                        DistConfPanel.this.groupsResult = result;
                        DistConfPanel.this.groupsListBox.addItem("", null);
                        for (UIResourceGroup group : result) {
                            DistConfPanel.this.groupsListBox.addItem(group.getGroupName(), (Object)group.getGroupId());
                        }
                        DistConfPanel.this.groupsListBox.setSelectedItem((Object)DistConfPanel.this.getGroupId(rgName, result));
                        if (rgName != null) {
                            DistConfPanel.this.showResources(rgName, resourceId);
                        } else {
                            DistConfPanel.this.busyIndicator.hide();
                        }
                    }
                }
            });
            this.groupsListBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    DistConfPanel.this.updateFormWithResources(DistConfPanel.this.getGroupName((Long)DistConfPanel.this.groupsListBox.getSelectedItem(), DistConfPanel.this.groupsResult), ti, resourceId);
                }
            });
        }
    }

    private void showResources(String groupName, final Long resourceId) {
        int x = this.form.getFieldRowIndex(this.resourcesListBox);
        if (x < 0) {
            this.form.addRow("Associated Resource", this.resourcesListBox, false);
        }
        this.resourcesListBox.clear();
        this.service.getResourcesInGroup(groupName, (AsyncCallback<Map<Long, String>>)new NeptuneAsyncCallback<Map<Long, String>>(){

            public void onNeptuneFailure(Throwable caught) {
                DistConfPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(Map<Long, String> resources) {
                DistConfPanel.this.resourcesListBox.addItem("", null);
                for (Map.Entry<Long, String> resource : resources.entrySet()) {
                    DistConfPanel.this.resourcesListBox.addItem(resource.getValue(), (Object)resource.getKey());
                }
                if (resourceId != null) {
                    DistConfPanel.this.resourcesListBox.setSelectedItem((Object)resourceId);
                }
                DistConfPanel.this.busyIndicator.hide();
            }
        });
    }

    private void updateFormWithResources(String groupName, UITemplateInfo ti, Long resourceId) {
        if (groupName == null) {
            this.isAssociatedResourceRequiredField = false;
            int x = this.form.getFieldRowIndex(this.resourcesListBox);
            if (x >= 0) {
                this.resourcesListBox.setSelectedItem(null);
                this.form.removeRow(x);
            }
            this.busyIndicator.hide();
        } else {
            if (groupName.trim().length() > 0) {
                this.isAssociatedResourceRequiredField = true;
                ti.setAssociatedResourceGroupName(groupName);
            }
            this.showResources(groupName, resourceId);
        }
    }

    private String getGroupName(Long id, Collection<UIResourceGroup> groups) {
        if (groups != null) {
            for (UIResourceGroup group : groups) {
                if (group.getGroupId() == null || id == null || group.getGroupId().longValue() != id.longValue()) continue;
                return group.getGroupName();
            }
        }
        return null;
    }

    private Long getGroupId(String associatedResourceGroupName, Collection<UIResourceGroup> result) {
        for (UIResourceGroup group : result) {
            if (!group.getGroupName().equalsIgnoreCase(associatedResourceGroupName)) continue;
            return group.getGroupId();
        }
        return null;
    }

    public void setData(Collection<UITemplateInfo> allTemplatesInfo, String selectedTemplateName, String groupName, Map<String, String> paramValues, Long associatedResource) {
        UITemplateInfo selectedTemplateInfo = null;
        if (allTemplatesInfo != null) {
            for (UITemplateInfo ti : allTemplatesInfo) {
                if (!ti.getTemplateName().equals(selectedTemplateName)) continue;
                selectedTemplateInfo = ti;
                break;
            }
        }
        if (selectedTemplateName != null && !selectedTemplateName.isEmpty() && selectedTemplateInfo == null) {
            selectedTemplateInfo = new UITemplateInfo();
            selectedTemplateInfo.setTemplateName(selectedTemplateName);
            selectedTemplateInfo.setAssociatedResourceGroupName("");
            selectedTemplateInfo.setRequiredVariables(new HashMap<String, UITemplateVariable>());
            selectedTemplateInfo.setLoaded(false);
            allTemplatesInfo.add(selectedTemplateInfo);
        }
        this.setAllTemplatesInfo(allTemplatesInfo);
        if (groupName != null) {
            selectedTemplateInfo.setAssociatedResourceGroupName(groupName);
        }
        this.updateForm(selectedTemplateInfo, paramValues, associatedResource);
    }

    private void setAllTemplatesInfo(Collection<UITemplateInfo> templatesInfo) {
        this.confListBox.clear();
        if (templatesInfo != null) {
            for (UITemplateInfo ti : templatesInfo) {
                this.confListBox.addItem(ti.getTemplateName(), (Object)ti);
            }
        }
    }

    private void setSelectedTemplateInfo(UITemplateInfo ti) {
        if (ti == null) {
            ti = new UITemplateInfo();
            this.confListBox.insertItem("", (Object)ti, 0);
        }
        this.confListBox.setSelectedItem((Object)ti);
    }

    private UITemplateInfo getSelectedTemplateInfo() {
        return (UITemplateInfo)this.confListBox.getSelectedItem();
    }

    private void setParams(Map<String, UITemplateVariable> params) {
        this.mainPanel.remove((Widget)this.form);
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.mainPanel.add((Widget)this.form);
        this.paramWidgets.clear();
        if (params != null) {
            for (Map.Entry<String, UITemplateVariable> param : params.entrySet()) {
                TextBoxWidget textBox = new TextBoxWidget();
                this.form.addRow(new LabelWidget(param.getValue().getMappedName()), (Widget)textBox, true);
                this.paramWidgets.put(param.getKey(), textBox);
            }
        }
    }

    private void setParamValues(Map<String, String> paramValues) {
        if (paramValues != null) {
            for (Map.Entry<String, String> paramValue : paramValues.entrySet()) {
                TextBoxWidget textBox = this.paramWidgets.get(paramValue.getKey());
                if (textBox == null) continue;
                textBox.setValue((Object)paramValue.getValue());
            }
        }
    }

    public String getSelectedTemplateName() {
        UITemplateInfo selectedTemplateInfo = (UITemplateInfo)this.confListBox.getSelectedItem();
        return selectedTemplateInfo != null ? selectedTemplateInfo.getTemplateName() : null;
    }

    public Map<String, String> getParamValues() {
        HashMap<String, String> paramValues = new HashMap<String, String>();
        for (Map.Entry<String, TextBoxWidget> paramWidget : this.paramWidgets.entrySet()) {
            paramValues.put(paramWidget.getKey(), paramWidget.getValue().getValue());
        }
        return paramValues;
    }

    public Long getAssociatedResource() {
        return (Long)this.resourcesListBox.getSelectedItem();
    }

    public String getAssociatedGroupName() {
        return this.getGroupName((Long)this.groupsListBox.getSelectedItem(), this.groupsResult);
    }

    public List<String> validate() {
        Long associatedResource;
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isAssociatedResourceRequiredField) {
            associatedResource = this.getAssociatedResource();
            if (associatedResource == null) {
                validationErrors.add(this.constants.associatedResourceIsRequired());
            }
        } else {
            associatedResource = this.getAssociatedResource();
            String groupName = this.getAssociatedGroupName();
            if (associatedResource == null && groupName != null) {
                validationErrors.add(this.constants.associatedResourceIsRequired());
            }
        }
        UITemplateInfo uiTemplateInfo = this.getSelectedTemplateInfo();
        Map<String, String> paramKeyValuesMap = this.getParamValues();
        String paramKey = null;
        String paramValue = null;
        for (Map.Entry<String, String> paramKeyValueEntry : paramKeyValuesMap.entrySet()) {
            paramKey = paramKeyValueEntry.getKey();
            paramValue = paramKeyValueEntry.getValue();
            if (paramValue == null || paramValue.trim().length() < 1) {
                validationErrors.add(this.messages.paramValueIsRequired(paramKey));
                continue;
            }
            UITemplateVariable uiTemplateVariable = uiTemplateInfo.getRequiredVariables().get(paramKey);
            UITemplateVariableDataType uiTemplateVariableDataType = uiTemplateVariable.getDataType();
            if (UITemplateVariableDataType.BOOLEAN.equals((Object)uiTemplateVariableDataType)) {
                Boolean booleanValue = Boolean.valueOf(paramValue);
                if (Boolean.TRUE.equals(booleanValue) || Boolean.FALSE.equals(booleanValue)) continue;
                validationErrors.add(this.messages.paramValueRequiredBoolean(paramKey));
                continue;
            }
            if (UITemplateVariableDataType.INTEGER.equals((Object)uiTemplateVariableDataType)) {
                try {
                    int intValue = Integer.valueOf(paramValue);
                    if (intValue >= Integer.MIN_VALUE && intValue <= Integer.MAX_VALUE) continue;
                    validationErrors.add(this.messages.paramValueRequiredInteger(paramKey));
                }
                catch (Exception exception) {
                    validationErrors.add(this.messages.paramValueRequiredInteger(paramKey));
                }
                continue;
            }
            if (!UITemplateVariableDataType.DATE.equals((Object)uiTemplateVariableDataType)) continue;
            try {
                DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((String)PARAM_VALUE_DATE_FORMAT);
                dateTimeFormat.parse(paramValue);
            }
            catch (Exception exception) {
                validationErrors.add(this.messages.paramValueRequiredDate(paramKey));
            }
        }
        return validationErrors;
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }
}

