/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.entities.UIExportPluginInfo;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportConfPanel
extends Composite {
    private VerticalContainer mainPanel;
    private HorizontalContainer listBoxContainer;
    private ImageWidget isNotLoadedImage;
    private ListBoxWidget<String> listBox;
    private FormContainer form;
    private Map<String, TextBoxWidget> paramWidgets = new HashMap<String, TextBoxWidget>();
    private ISiteClientBundle clientBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);
    private Map<String, List<String>> exporterParamNamesMap = new HashMap<String, List<String>>();
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private static final String NOT_LOAD_STYLE = "not_loaded_image";

    public ExportConfPanel() {
        this.mainPanel = new VerticalContainer();
        this.listBoxContainer = new HorizontalContainer();
        this.listBoxContainer.setSpacing(1);
        this.mainPanel.add((Widget)this.listBoxContainer);
        this.isNotLoadedImage = new ImageWidget();
        this.isNotLoadedImage.setResource(this.clientBundle.sitePluginConfigurationError());
        this.isNotLoadedImage.addStyleName(NOT_LOAD_STYLE);
        this.isNotLoadedImage.setTitle(this.constants.invalidExport());
        this.isNotLoadedImage.setVisible(false);
        this.listBoxContainer.add((Widget)this.isNotLoadedImage);
        this.listBox = new ListBoxWidget();
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (ExportConfPanel.this.isNotLoadedImage.isVisible()) {
                    ExportConfPanel.this.isNotLoadedImage.setVisible(false);
                    int i = 0;
                    while (i < ExportConfPanel.this.listBox.getItemCount()) {
                        String item = (String)ExportConfPanel.this.listBox.getItem(i);
                        if (item != null && !ExportConfPanel.this.exporterParamNamesMap.containsKey(item)) {
                            ExportConfPanel.this.listBox.removeItem((Object)item);
                            break;
                        }
                        ++i;
                    }
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                List paramNames = (List)ExportConfPanel.this.exporterParamNamesMap.get(ExportConfPanel.this.listBox.getSelectedItem());
                if (paramNames != null) {
                    for (String paramName : paramNames) {
                        params.put(paramName, null);
                    }
                }
                ExportConfPanel.this.drawParamFields(params);
            }
        });
        this.listBoxContainer.add(this.listBox);
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.mainPanel.add((Widget)this.form);
        this.initWidget((Widget)this.mainPanel);
    }

    private void clear() {
        this.listBox.clear();
        this.exporterParamNamesMap.clear();
        this.drawParamFields(null);
    }

    public void setData(List<UIExportPluginInfo> allPluginsInfo, String selectedPluginName, Map<String, String> params) {
        this.clear();
        this.listBox.addItem("", null);
        for (UIExportPluginInfo pi : allPluginsInfo) {
            this.listBox.addItem(pi.getName(), (Object)pi.getName());
            this.exporterParamNamesMap.put(pi.getName(), pi.getParams());
        }
        if (this.listBox.getIndex((Object)selectedPluginName) == -1) {
            this.isNotLoadedImage.setVisible(true);
            this.listBox.addItem(selectedPluginName, (Object)selectedPluginName);
            this.listBox.setSelectedItem((Object)selectedPluginName);
            this.drawParamFields(params);
        } else {
            this.isNotLoadedImage.setVisible(false);
            this.listBox.setSelectedItem((Object)selectedPluginName);
            HashMap<String, String> paramsToSetInUI = new HashMap<String, String>();
            List<String> associatedParams = this.exporterParamNamesMap.get(selectedPluginName);
            if (associatedParams != null) {
                for (String associatedParam : associatedParams) {
                    String paramValue = params != null ? params.get(associatedParam) : null;
                    paramsToSetInUI.put(associatedParam, paramValue);
                }
            }
            this.drawParamFields(paramsToSetInUI);
        }
    }

    public String getSelectedPluginName() {
        return (String)this.listBox.getSelectedItem();
    }

    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, TextBoxWidget> paramWidget : this.paramWidgets.entrySet()) {
            params.put(paramWidget.getKey(), paramWidget.getValue().getValue());
        }
        return params;
    }

    private void drawParamFields(Map<String, String> params) {
        this.mainPanel.remove((Widget)this.form);
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.mainPanel.add((Widget)this.form);
        this.paramWidgets.clear();
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                TextBoxWidget textBox = new TextBoxWidget();
                textBox.setValue((Object)param.getValue());
                this.form.addRow(new LabelWidget(param.getKey()), (Widget)textBox);
                this.paramWidgets.put(param.getKey(), textBox);
            }
        }
    }
}

