/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class ExportStatusSelectionDialog
extends DialogBox {
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private CheckBoxWidget targetedStatusCB;
    private CheckBoxWidget readyForDistStatusCB;
    private CheckBoxWidget inProgressStatusCB;
    private CheckBoxWidget distributedStatusCB;
    private CheckBoxWidget failedStatusCB;
    private CheckBoxWidget waitingForDependencyStatusCB;
    private IExportActionHandler exportActionHandler;

    public ExportStatusSelectionDialog(IExportActionHandler exportActionHandler) {
        super(false, true);
        this.exportActionHandler = exportActionHandler;
        this.setText(this.constants.exportSelectStatusText());
        VerticalContainer mainPanel = new VerticalContainer();
        mainPanel.add((Widget)this.getCheckBoxPanel());
        mainPanel.add((Widget)this.getButtonPanel());
        this.setWidget((Widget)mainPanel);
    }

    private VerticalContainer getCheckBoxPanel() {
        VerticalContainer panel = new VerticalContainer();
        panel.add((Widget)this.getAllNonePanel());
        this.targetedStatusCB = new CheckBoxWidget(this.constants.targeted());
        panel.add((Widget)this.targetedStatusCB);
        this.readyForDistStatusCB = new CheckBoxWidget(this.constants.ready_for_distribution());
        panel.add((Widget)this.readyForDistStatusCB);
        this.inProgressStatusCB = new CheckBoxWidget(this.constants.in_progress());
        panel.add((Widget)this.inProgressStatusCB);
        this.distributedStatusCB = new CheckBoxWidget(this.constants.distributed());
        panel.add((Widget)this.distributedStatusCB);
        this.failedStatusCB = new CheckBoxWidget(this.constants.failed());
        panel.add((Widget)this.failedStatusCB);
        this.waitingForDependencyStatusCB = new CheckBoxWidget(this.constants.waiting_for_dependency());
        panel.add((Widget)this.waitingForDependencyStatusCB);
        return panel;
    }

    private HorizontalContainer getAllNonePanel() {
        HorizontalContainer allNonePanel = new HorizontalContainer();
        allNonePanel.setSpacing(5);
        LabelWidget allLabel = new LabelWidget(this.constants.all());
        allLabel.addStyleName("sites-link");
        allLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExportStatusSelectionDialog.this.setValueForAllCheckBoxes(true);
            }
        });
        allNonePanel.add((Widget)allLabel);
        LabelWidget noneLabel = new LabelWidget(this.constants.none());
        noneLabel.addStyleName("sites-link");
        noneLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExportStatusSelectionDialog.this.setValueForAllCheckBoxes(false);
            }
        });
        allNonePanel.add((Widget)noneLabel);
        return allNonePanel;
    }

    private void setValueForAllCheckBoxes(boolean value) {
        this.targetedStatusCB.setValue(Boolean.valueOf(value));
        this.readyForDistStatusCB.setValue(Boolean.valueOf(value));
        this.inProgressStatusCB.setValue(Boolean.valueOf(value));
        this.distributedStatusCB.setValue(Boolean.valueOf(value));
        this.failedStatusCB.setValue(Boolean.valueOf(value));
        this.waitingForDependencyStatusCB.setValue(Boolean.valueOf(value));
    }

    private HorizontalContainer getButtonPanel() {
        HorizontalContainer panel = new HorizontalContainer();
        panel.addStyleName("cms_button_container");
        ButtonWidget exportButton = new ButtonWidget(this.constants.buttonLabelExport(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExportStatusSelectionDialog.this.hide();
                ExportStatusSelectionDialog.this.exportActionHandler.export(ExportStatusSelectionDialog.this.getSelectedStatuses());
            }
        });
        exportButton.removeStyleName("gwt-Button");
        exportButton.addStyleName("ebBtn");
        exportButton.addStyleName("export_button_icon");
        panel.add((Widget)exportButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.buttonLabelCancel(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExportStatusSelectionDialog.this.hide();
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        panel.add((Widget)cancelButton);
        return panel;
    }

    private List<UIDistributionStatus> getSelectedStatuses() {
        ArrayList<UIDistributionStatus> statuses = new ArrayList<UIDistributionStatus>();
        if (this.targetedStatusCB.getValue().booleanValue()) {
            statuses.add(UIDistributionStatus.TARGETED);
        }
        if (this.readyForDistStatusCB.getValue().booleanValue()) {
            statuses.add(UIDistributionStatus.READY_FOR_DISTRIBUTION);
        }
        if (this.inProgressStatusCB.getValue().booleanValue()) {
            statuses.add(UIDistributionStatus.IN_PROGRESS);
        }
        if (this.distributedStatusCB.getValue().booleanValue()) {
            statuses.add(UIDistributionStatus.DISTRIBUTED);
        }
        if (this.failedStatusCB.getValue().booleanValue()) {
            statuses.add(UIDistributionStatus.FAILED);
        }
        if (this.waitingForDependencyStatusCB.getValue().booleanValue()) {
            statuses.add(UIDistributionStatus.WAITING_FOR_DEPENDENCY);
        }
        return statuses;
    }

    public static interface IExportActionHandler {
        public void export(List<UIDistributionStatus> var1);
    }
}

