/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.scheduling.ui.client.FilteredSchedules;
import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Map;

public class JobsTab
extends Composite
implements ISiteTab {
    public static final String NAME = "Jobs";
    private static final String ENTITY_TYPE_SITES = "Sites";
    private static final int MAIN_PANEL_OFFSET_WIDTH = 380;
    private static final int MAIN_PANEL_OFFSET_HEIGHT = 280;
    private VerticalContainer mainPanel;
    private UISite site;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private FilteredSchedules filteredSchedules;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private HandlerRegistration windowRegistration = null;

    public JobsTab() {
        this.mainPanel = new VerticalContainer();
        this.filteredSchedules = new FilteredSchedules();
        this.mainPanel.add((Widget)this.filteredSchedules);
        this.initWidget((Widget)this.mainPanel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                JobsTab.this.updateMainPanelSize();
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return this.constants.jobsTabName();
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        this.site = site;
        return site != null && (site.getType() == UISiteType.DISTRIBUTION || site.getType() == UISiteType.MEDIAPATH_DISTRIBUTION);
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && this.site != null) {
            History.newItem((String)Anchors.getAnchor(this.site.getId(), this.site.getParentId(), this.getName()), (boolean)false);
            this.filteredSchedules.clearMessages();
            this.filteredSchedules.setEntity(ENTITY_TYPE_SITES, Long.valueOf(this.site.getId().longValue()));
            this.updateMainPanelSize();
        }
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.filteredSchedules.setMessageArea(messageArea);
    }

    protected void updateMainPanelSize() {
        int offsetWidth = 380;
        int offsetHeight = 280;
        this.filteredSchedules.updateSize(offsetWidth, offsetHeight);
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                JobsTab.this.updateMainPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }
}

