/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISitePartnerService;
import com.ericsson.cms.sites.ui.client.IUISitePartnerServiceAsync;
import com.ericsson.cms.sites.ui.client.PropertiesForm;
import com.ericsson.cms.sites.ui.client.entities.UIContact;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISitePartner;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerMessages;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PartnerInfoPanel
extends Composite {
    private static final String STYLE_TEXTBOX = "sites-partnerTab-textbox";
    private VerticalContainer mainPanel;
    private FormContainer formContainer;
    private LabelWidget contextIdValueWidget = new LabelWidget();
    private TextBoxWidget providerIdValueWidget;
    private TextBoxWidget lookupKeyValueWidget;
    private TextBoxWidget firstNameValueWidget;
    private TextBoxWidget lastNameValueWidget;
    private TextBoxWidget emailValueWidget;
    private PropertiesForm propertiesForm = new PropertiesForm();
    private MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private IUISitePartnerServiceAsync service = (IUISitePartnerServiceAsync)GWT.create(IUISitePartnerService.class);
    private SitePartnerConstants constants = (SitePartnerConstants)GWT.create(SitePartnerConstants.class);
    private SitePartnerMessages messages = (SitePartnerMessages)GWT.create(SitePartnerMessages.class);
    private UISitePartner partner;
    private NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
    private MessageArea messageArea;

    public PartnerInfoPanel() {
        this.buildUI();
        this.initWidget((Widget)this.mainPanel);
    }

    public void showSite(UISite site) {
        if (site != null) {
            if (site.getId() != null) {
                this.busyIndicator.center();
                this.service.getSitePartner(site.getId(), (AsyncCallback<UISitePartner>)new NeptuneAsyncCallback<UISitePartner>(){

                    public void onNeptuneFailure(Throwable caught) {
                        PartnerInfoPanel.this.showError("Unable to get partner information for this site. | Reason: " + caught != null ? caught.getLocalizedMessage() : null);
                        PartnerInfoPanel.this.formContainer.setVisible(false);
                        PartnerInfoPanel.this.busyIndicator.hide();
                    }

                    public void onNeptuneSuccess(UISitePartner result) {
                        PartnerInfoPanel.this.partner = result;
                        PartnerInfoPanel.this.updateForm(result);
                        PartnerInfoPanel.this.formContainer.setVisible(true);
                        PartnerInfoPanel.this.busyIndicator.hide();
                    }
                });
            } else {
                UISitePartner sitePartner;
                this.partner = sitePartner = new UISitePartner();
                this.updateForm(sitePartner);
                this.formContainer.setVisible(true);
                this.busyIndicator.hide();
            }
        }
    }

    public UISitePartner getPartnerFromForm() {
        this.updatePartnerFromForm();
        return this.partner;
    }

    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    public void validate(final AsyncCallback<List<String>> callback) {
        String email;
        String lastName;
        String firstName;
        String lookupKey;
        final ArrayList<String> errors = new ArrayList<String>();
        String providerId = this.providerIdValueWidget.getText();
        if (providerId != null) {
            if ((providerId = providerId.trim()).length() > 25) {
                errors.add(this.messages.errorLongProviderId(25));
            }
            if (providerId.indexOf(47) != -1) {
                errors.add(this.messages.errorProviderIdRestrictedChar('/'));
            }
        }
        if ((lookupKey = this.lookupKeyValueWidget.getText()) != null && (lookupKey = lookupKey.trim()).length() > 25) {
            errors.add(this.messages.errorLongLookupKey(25));
        }
        if ((firstName = this.firstNameValueWidget.getText()) != null && !(firstName = firstName.trim()).isEmpty()) {
            if (firstName.length() > 25) {
                errors.add(this.messages.errorLongFirstName(25));
            }
            if (firstName.matches(".*\\d.*")) {
                errors.add(this.constants.errorFirstNameNumericChars());
            }
        }
        if ((lastName = this.lastNameValueWidget.getText()) != null && !(lastName = lastName.trim()).isEmpty()) {
            if (lastName.length() > 25) {
                errors.add(this.messages.errorLongLastName(25));
            }
            if (lastName.matches(".*\\d.*")) {
                errors.add(this.constants.errorLastNameNumericChars());
            }
        }
        if ((email = this.emailValueWidget.getText()) != null && !(email = email.trim()).isEmpty()) {
            if (email.length() > 50) {
                errors.add(this.messages.errorLongEmail(50));
            }
            if (email.indexOf(64) == -1 || email.indexOf(46) == -1) {
                errors.add(this.constants.errorInvalidEmail());
            }
        }
        errors.addAll(this.propertiesForm.validate());
        this.updatePartnerFromForm();
        this.busyIndicator.center();
        this.service.validate(this.partner, new AsyncCallback<Set<String>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
                PartnerInfoPanel.this.busyIndicator.hide();
            }

            public void onSuccess(Set<String> serverErrors) {
                if (serverErrors != null) {
                    for (String se : serverErrors) {
                        errors.add(PartnerInfoPanel.this.constants.getString(se));
                    }
                }
                callback.onSuccess((Object)errors);
                PartnerInfoPanel.this.busyIndicator.hide();
            }
        });
    }

    private void updatePartnerFromForm() {
        this.partner.setProviderId(this.trim(this.providerIdValueWidget.getText()));
        this.partner.setLookupKey(this.trim(this.lookupKeyValueWidget.getText()));
        this.partner.setContact(new UIContact());
        this.partner.getContact().setFirstName(this.trim(this.firstNameValueWidget.getText()));
        this.partner.getContact().setLastName(this.trim(this.lastNameValueWidget.getText()));
        this.partner.getContact().setEmail(this.trim(this.emailValueWidget.getText()));
        this.partner.setProperties(this.propertiesForm.getProperties());
    }

    private void buildUI() {
        this.mainPanel = new VerticalContainer();
        this.providerIdValueWidget = new TextBoxWidget();
        this.providerIdValueWidget.addStyleName(STYLE_TEXTBOX);
        this.lookupKeyValueWidget = new TextBoxWidget();
        this.lookupKeyValueWidget.addStyleName(STYLE_TEXTBOX);
        this.firstNameValueWidget = new TextBoxWidget();
        this.firstNameValueWidget.addStyleName(STYLE_TEXTBOX);
        this.lastNameValueWidget = new TextBoxWidget();
        this.lastNameValueWidget.addStyleName(STYLE_TEXTBOX);
        this.emailValueWidget = new TextBoxWidget();
        this.emailValueWidget.addStyleName(STYLE_TEXTBOX);
        this.formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.formContainer.addRow(this.constants.fieldLabelContextId(), (Widget)this.contextIdValueWidget);
        this.formContainer.addRow(this.constants.fieldLabelProviderId(), (Widget)this.providerIdValueWidget);
        this.formContainer.addRow(this.constants.fieldLabelLookupKey(), (Widget)this.lookupKeyValueWidget);
        this.formContainer.addRow(this.constants.fieldLabelFirstName(), (Widget)this.firstNameValueWidget);
        this.formContainer.addRow(this.constants.fieldLabelLastName(), (Widget)this.lastNameValueWidget);
        this.formContainer.addRow(this.constants.fieldLabelEmail(), (Widget)this.emailValueWidget);
        this.formContainer.addRow("Properties", (Widget)this.propertiesForm);
        this.mainPanel.add((Widget)this.formContainer);
    }

    private void updateForm(UISitePartner partner) {
        if (partner != null) {
            long contextId = partner.getContextId();
            if (contextId > 0L) {
                this.contextIdValueWidget.setText(Long.toString(contextId));
            } else {
                this.contextIdValueWidget.setText(null);
            }
            this.providerIdValueWidget.setText(partner.getProviderId());
            this.lookupKeyValueWidget.setText(partner.getLookupKey());
            UIContact contact = partner.getContact();
            if (contact != null) {
                this.firstNameValueWidget.setText(contact.getFirstName());
                this.lastNameValueWidget.setText(contact.getLastName());
                this.emailValueWidget.setText(contact.getEmail());
            } else {
                this.firstNameValueWidget.setText(null);
                this.lastNameValueWidget.setText(null);
                this.emailValueWidget.setText(null);
            }
            boolean isFormEditable = this.security.isUserInRole("Sites_Modify") || this.security.isUserInRole("Sites_Create") && contextId <= 0L;
            this.setUpdateFormEditable(isFormEditable);
            this.propertiesForm.setProperties(partner.getProperties(), isFormEditable);
        }
    }

    private void setUpdateFormEditable(boolean isFormEditable) {
        this.providerIdValueWidget.setEnabled(isFormEditable);
        this.lookupKeyValueWidget.setEnabled(isFormEditable);
        this.firstNameValueWidget.setEnabled(isFormEditable);
        this.lastNameValueWidget.setEnabled(isFormEditable);
        this.emailValueWidget.setEnabled(isFormEditable);
    }

    private void showError(String message) {
        this.messageArea.setErrorMessage(message);
    }

    private void showInfo(String message) {
        this.messageArea.setInfoMessage(message);
    }

    private String trim(String s) {
        if (s == null) {
            return s;
        }
        return s.trim();
    }
}

