/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.entities.UIProperty;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerMessages;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertiesForm
extends Composite {
    private static final String STYLE_HEAD = "sites-partnerTab-properties-head";
    private static final String STYLE_BODY = "sites-partnerTab-properties-body";
    private static final String STYLE_TEXTBOX = "sites-partnerTab-properties-textbox";
    private FlexTableContainer table = new FlexTableContainer();
    private Map<ImageWidget, Set<HandlerRegistration>> handlersMap = new HashMap<ImageWidget, Set<HandlerRegistration>>();
    private SitePartnerConstants constants = (SitePartnerConstants)GWT.create(SitePartnerConstants.class);
    private SitePartnerMessages messages = (SitePartnerMessages)GWT.create(SitePartnerMessages.class);
    private ISiteClientBundle imagesBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);

    public PropertiesForm() {
        this.initWidget((Widget)this.table);
    }

    public void setProperties(List<UIProperty> props, boolean editable) {
        this.table.removeAllRows();
        this.table.getRowFormatter().addStyleName(0, STYLE_HEAD);
        this.table.setWidget(0, 0, (Widget)new LabelWidget("Name"));
        this.table.setWidget(0, 1, (Widget)new LabelWidget("Value"));
        for (UIProperty p : props) {
            this.addRow(p.getName(), p.getValue(), editable);
        }
        if (editable) {
            this.addNewNonDeletableRow();
        }
    }

    private void addNewNonDeletableRow() {
        this.addRow(null, null, true);
    }

    private void addRow(String name, String value, boolean editable) {
        HandlerRegistration hr;
        int rowIndex = this.table.getRowCount();
        this.table.getRowFormatter().addStyleName(rowIndex, STYLE_BODY);
        HashSet<HandlerRegistration> hrSet = new HashSet<HandlerRegistration>();
        TextBoxWidget nameWidget = new TextBoxWidget(name);
        nameWidget.addStyleName(STYLE_TEXTBOX);
        nameWidget.setEnabled(editable);
        if (editable) {
            hr = nameWidget.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    PropertiesForm.this.makeSureOfOneBlankRow();
                }
            });
            hrSet.add(hr);
        }
        this.table.setWidget(rowIndex, 0, (Widget)nameWidget);
        TextBoxWidget valueWidget = new TextBoxWidget(value);
        valueWidget.addStyleName(STYLE_TEXTBOX);
        valueWidget.setEnabled(editable);
        if (editable) {
            hr = valueWidget.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    PropertiesForm.this.makeSureOfOneBlankRow();
                }
            });
            hrSet.add(hr);
        }
        this.table.setWidget(rowIndex, 1, (Widget)valueWidget);
        final ImageWidget deleteIcon = new ImageWidget();
        deleteIcon.setResource(this.imagesBundle.deleteIcon());
        hr = deleteIcon.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int rowIndex = PropertiesForm.this.findRowIndex((Widget)deleteIcon);
                PropertiesForm.this.table.removeRow(rowIndex);
                Set hrSet = (Set)PropertiesForm.this.handlersMap.remove(deleteIcon);
                for (HandlerRegistration hr : hrSet) {
                    hr.removeHandler();
                }
                PropertiesForm.this.makeSureOfOneBlankRow();
            }
        });
        hrSet.add(hr);
        deleteIcon.setVisible(editable);
        this.table.setWidget(rowIndex, 2, (Widget)deleteIcon);
        this.handlersMap.put(deleteIcon, hrSet);
    }

    public Set<String> validate() {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> errors = new HashSet<String>();
        int i = 1;
        while (i < this.table.getRowCount()) {
            String name = this.getName(i);
            String value = this.getValue(i);
            if (!this.isBlank(name) || !this.isBlank(value)) {
                if (this.isBlank(name)) {
                    errors.add(this.constants.errorEmptyPropertyName());
                } else if (name.length() > 100) {
                    errors.add(this.messages.errorLongPropertyName(name, 100));
                }
                if (this.isBlank(value)) {
                    errors.add(this.constants.errorEmptyPropertyValue());
                } else if (value.length() > 250) {
                    errors.add(this.messages.errorLongPropertyValue(value, 250));
                }
                if (names.contains(name)) {
                    errors.add(this.constants.errorDuplicateProperty());
                } else {
                    names.add(name);
                }
            }
            ++i;
        }
        return errors;
    }

    public List<UIProperty> getProperties() {
        ArrayList<UIProperty> props = new ArrayList<UIProperty>();
        int i = 1;
        while (i < this.table.getRowCount()) {
            String name = this.getName(i);
            String value = this.getValue(i);
            if (!this.isBlank(name) || !this.isBlank(value)) {
                props.add(new UIProperty(name, value));
            }
            ++i;
        }
        return props;
    }

    private int findRowIndex(Widget w) {
        int i = 1;
        while (i < this.table.getRowCount()) {
            if (this.table.getWidget(i, 2).equals(w)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void makeSureOfOneBlankRow() {
        int numBlankRows = this.getNumBlankRows();
        if (numBlankRows == 0) {
            this.addNewNonDeletableRow();
        } else {
            int i = 1;
            while (i < this.table.getRowCount()) {
                ImageWidget deleteIcon = (ImageWidget)this.table.getWidget(i, 2);
                if (this.isBlank(i)) {
                    deleteIcon.setVisible(numBlankRows > 1);
                } else {
                    deleteIcon.setVisible(true);
                }
                ++i;
            }
        }
    }

    private int getNumBlankRows() {
        int count = 0;
        int i = 1;
        while (i < this.table.getRowCount()) {
            if (this.isBlank(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean isBlank(int rowIndex) {
        return this.isBlank(this.getName(rowIndex)) && this.isBlank(this.getValue(rowIndex));
    }

    private String getName(int rowIndex) {
        TextBoxWidget nameWidget = (TextBoxWidget)this.table.getWidget(rowIndex, 0);
        String name = nameWidget.getText();
        if (name != null) {
            name = name.trim();
        }
        return name;
    }

    private String getValue(int rowIndex) {
        TextBoxWidget valueWidget = (TextBoxWidget)this.table.getWidget(rowIndex, 1);
        String value = valueWidget.getText();
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }
}

