/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.entities.UIActionOnFailureOption;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RetryConfPanel
extends Composite {
    private VerticalContainer mainPanel;
    private HorizontalContainer listBoxContainer;
    private ListBoxWidget<UIActionOnFailureOption> retryActionListBox;
    private FormContainer form;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private LabelWidget retryAttemptLabel;
    private LabelWidget retryWaitTimeLabel;
    private TextBoxWidget retryAttemptTextWidget = new TextBoxWidget();
    private TextBoxWidget retryWaitTimeTextWidget = new TextBoxWidget();
    private HorizontalContainer retryWaitTimeValueWidget;

    public RetryConfPanel() {
        this.mainPanel = new VerticalContainer();
        this.listBoxContainer = new HorizontalContainer();
        this.listBoxContainer.setSpacing(1);
        this.mainPanel.add((Widget)this.listBoxContainer);
        this.retryActionListBox = new ListBoxWidget();
        this.retryActionListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RetryConfPanel.this.drawRetryConfFields(5, 5);
            }
        });
        this.listBoxContainer.add(this.retryActionListBox);
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.mainPanel.add((Widget)this.form);
        this.initWidget((Widget)this.mainPanel);
    }

    private void clear() {
        this.retryActionListBox.clear();
        this.drawRetryConfFields(null, null);
    }

    public void setData(UIActionOnFailureOption selectedAction, Integer retryAttemps, Integer retryWaitTime) {
        this.clear();
        this.retryActionListBox.addItem("", null);
        UIActionOnFailureOption[] uIActionOnFailureOptionArray = UIActionOnFailureOption.values();
        int n = uIActionOnFailureOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIActionOnFailureOption action = uIActionOnFailureOptionArray[n2];
            this.retryActionListBox.addItem(action.name(), (Object)action);
            ++n2;
        }
        this.retryActionListBox.setSelectedItem((Object)selectedAction);
        this.drawRetryConfFields(retryAttemps, retryWaitTime);
    }

    public UIActionOnFailureOption getActionOnFailure() {
        return (UIActionOnFailureOption)((Object)this.retryActionListBox.getSelectedItem());
    }

    public String getRetryAttempts() {
        return this.retryAttemptTextWidget.getText();
    }

    public String getRetryWaitTime() {
        return this.retryWaitTimeTextWidget.getText();
    }

    private void drawRetryConfFields(Integer retryAttemps, Integer retryWaitTime) {
        this.mainPanel.remove((Widget)this.form);
        this.retryAttemptTextWidget.setText(null);
        this.retryWaitTimeTextWidget.setText(null);
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.mainPanel.add((Widget)this.form);
        if (retryAttemps != null && this.retryActionListBox.getSelectedItem() != null && retryWaitTime != null) {
            this.retryAttemptLabel = new LabelWidget(this.constants.retryAttempts());
            this.retryAttemptTextWidget.setText(String.valueOf(retryAttemps));
            this.form.addRow(this.retryAttemptLabel, (Widget)this.retryAttemptTextWidget, true);
            this.retryWaitTimeLabel = new LabelWidget(this.constants.retryWaitTime());
            this.retryWaitTimeValueWidget = new HorizontalContainer();
            this.retryWaitTimeValueWidget.add((Widget)this.retryWaitTimeTextWidget);
            LabelWidget secondLabel = new LabelWidget(this.constants.seconds());
            this.retryWaitTimeValueWidget.add((Widget)secondLabel);
            this.retryWaitTimeTextWidget.setText(String.valueOf(retryWaitTime));
            this.form.addRow(this.retryWaitTimeLabel, (Widget)this.retryWaitTimeValueWidget, true);
        }
    }

    public String getRetryAttemptLabel() {
        return this.retryAttemptLabel.getText();
    }

    public String getRetryWaitTimeLabel() {
        return this.retryWaitTimeLabel.getText();
    }
}

