/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.SitesRuleListingPanel;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.RulesTabConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.IRulesTab;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Map;

public class RulesTab
extends Composite
implements ISiteTab,
IRulesTab {
    private static final int MAIN_PANEL_OFFSET_HEIGHT = 250;
    private UISite site;
    private VerticalContainer mainPanel;
    private ScrollContainer scrollPanel;
    private SitesRuleListingPanel validationRuleSetsPanel;
    private SitesRuleListingPanel normalizationRuleSetsPanel;
    private SitesRuleListingPanel processingRuleSetsPanel;
    private SitesRuleListingPanel targetingRuleSetsPanel;
    private SitesRuleListingPanel prioritizationRuleSetsPanel;
    private MessageArea messageArea;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private RulesTabConstants tabConstants = (RulesTabConstants)GWT.create(RulesTabConstants.class);
    private HandlerRegistration windowRegistration = null;

    public RulesTab() {
        this.mainPanel = new VerticalContainer();
        this.mainPanel.setSpacing(10);
        this.scrollPanel = new ScrollContainer();
        this.scrollPanel.add((Widget)this.mainPanel);
        this.validationRuleSetsPanel = new SitesRuleListingPanel(Packages.VALIDATION);
        this.validationRuleSetsPanel.getWidget(0).setVisible(false);
        RoundedDisclosureContainer rValidation = new RoundedDisclosureContainer((Widget)new LabelWidget(this.tabConstants.validationRules()), true);
        rValidation.addStyleName("sites-basicTab-disclosureContainer");
        rValidation.setContent((Widget)this.validationRuleSetsPanel);
        this.mainPanel.add((Widget)rValidation);
        this.normalizationRuleSetsPanel = new SitesRuleListingPanel(Packages.NORMALIZATION);
        this.normalizationRuleSetsPanel.getWidget(0).setVisible(false);
        RoundedDisclosureContainer rNormalization = new RoundedDisclosureContainer((Widget)new LabelWidget(this.tabConstants.normalizationRules()), true);
        rNormalization.addStyleName("sites-basicTab-disclosureContainer");
        rNormalization.setContent((Widget)this.normalizationRuleSetsPanel);
        this.mainPanel.add((Widget)rNormalization);
        this.processingRuleSetsPanel = new SitesRuleListingPanel(Packages.PROCESSING);
        this.processingRuleSetsPanel.getWidget(0).setVisible(false);
        RoundedDisclosureContainer rProcessingRules = new RoundedDisclosureContainer((Widget)new LabelWidget(this.tabConstants.contentProcessingRules()), true);
        rProcessingRules.addStyleName("sites-basicTab-disclosureContainer");
        rProcessingRules.setContent((Widget)this.processingRuleSetsPanel);
        this.mainPanel.add((Widget)rProcessingRules);
        this.targetingRuleSetsPanel = new SitesRuleListingPanel(Packages.TARGETING);
        this.targetingRuleSetsPanel.getWidget(0).setVisible(false);
        RoundedDisclosureContainer rTargeting = new RoundedDisclosureContainer((Widget)new LabelWidget(this.tabConstants.targetingRules()), true);
        rTargeting.addStyleName("sites-basicTab-disclosureContainer");
        rTargeting.setContent((Widget)this.targetingRuleSetsPanel);
        this.mainPanel.add((Widget)rTargeting);
        this.prioritizationRuleSetsPanel = new SitesRuleListingPanel(Packages.PRIORITIZATION);
        this.prioritizationRuleSetsPanel.getWidget(0).setVisible(false);
        RoundedDisclosureContainer rPriority = new RoundedDisclosureContainer((Widget)new LabelWidget(this.tabConstants.priotizationRules()), true);
        rPriority.addStyleName("sites-basicTab-disclosureContainer");
        rPriority.setContent((Widget)this.prioritizationRuleSetsPanel);
        this.mainPanel.add((Widget)rPriority);
        this.initWidget((Widget)this.scrollPanel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                RulesTab.this.updateMainPanelSize();
            }
        });
    }

    @Override
    public String getName() {
        return "Rules";
    }

    @Override
    public String getDisplayName() {
        return this.constants.rulesTabName();
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        this.site = site;
        return site != null && site.getType() != UISiteType.TRACKING;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && this.site != null) {
            History.newItem((String)Anchors.getAnchor(this.site.getId(), this.site.getParentId(), this.getName()), (boolean)false);
            this.validationRuleSetsPanel.setSite(this.site.getId());
            this.normalizationRuleSetsPanel.setSite(this.site.getId());
            this.processingRuleSetsPanel.setSite(this.site.getId());
            this.targetingRuleSetsPanel.setSite(this.site.getId());
            this.prioritizationRuleSetsPanel.setSite(this.site.getId());
        }
        this.messageArea.reset();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    protected void onLoad() {
        super.onLoad();
        this.checkUserSelfPartner();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                RulesTab.this.updateMainPanelSize();
            }
        });
    }

    public RulesComponent getRulesComponent() {
        return RulesComponent.getInstance();
    }

    protected void onUnload() {
        this.getRulesComponent().setIsSelfUserPartner(null);
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    private void checkUserSelfPartner() {
        this.getRulesComponent().checkUserAssociatedWithSelfPartner("", (IRulesTab)this);
    }

    protected void updateMainPanelSize() {
        int offsetHeight = 250;
        this.scrollPanel.setHeight(String.valueOf(Window.getClientHeight() - offsetHeight) + "px");
    }

    public void refreshTab(String anchor) {
        if (this.getRulesComponent().isUserChecked().booleanValue()) {
            this.normalizationRuleSetsPanel.setEnableButtons(RulesComponent.getInstance().getIsSelfUserPartner());
        }
    }
}

