/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.ericsson.cms.sites.ui.client.DistScheduleUISchedulerClient;
import com.ericsson.cms.sites.ui.client.MSOAdminWidgetFactory;
import com.ericsson.cms.sites.ui.client.SiteTimerUISchedulerClient;
import com.ericsson.cms.sites.ui.client.SitesUISchedulerClient;
import com.ericsson.cms.sites.ui.client.SitesViewWidgetFactory;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.portlet.DistributionPortlet;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SitesComponent
extends ComponentBase {
    private Map<String, String> info;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.info = info;
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        if (!security.isUserInRole("Sites_View")) {
            return null;
        }
        ArrayList<PortletFactory> portlets = new ArrayList<PortletFactory>();
        if (security.isUserInRole("Sites_View")) {
            DistributionPortlet distPortlet = new DistributionPortlet(security, this.info);
            portlets.add(new SitePortletFactory(distPortlet, this));
        }
        return portlets;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        ArrayList<Object> services = new ArrayList<Object>();
        if (clazz.equals(IUISchedulerClient.class)) {
            services.add(new SitesUISchedulerClient(security));
            services.add(new SiteTimerUISchedulerClient(security));
            services.add(new DistScheduleUISchedulerClient(security));
        }
        return services;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList<WidgetMenuItem> childMenuItems = new ArrayList<WidgetMenuItem>();
        GroupMenuItem rootMenuItem = new GroupMenuItem("Sites", childMenuItems);
        tabs.add((MenuItemBase)rootMenuItem);
        if (security.isUserInRole("Sites_View")) {
            SitesViewWidgetFactory factory = new SitesViewWidgetFactory(this.info);
            WidgetMenuItem viewMenuItem = new WidgetMenuItem("View", (WidgetFactory)factory, factory.getAnchorChangeListener());
            childMenuItems.add(viewMenuItem);
            MSOAdminWidgetFactory msoFactory = new MSOAdminWidgetFactory(this.info);
            WidgetMenuItem msoMenuItem = new WidgetMenuItem("MSO", (WidgetFactory)msoFactory, msoFactory.getAnchorChangeListener());
            childMenuItems.add(msoMenuItem);
        }
        return tabs;
    }

    public String getName() {
        return "SITES";
    }

    public String getDisplayName() {
        return this.constants.componentDisplayName();
    }

    private static final class SitePortletFactory
    implements PortletFactory {
        private final Portlet portlet;
        private final SitesComponent sitesComponent;

        public SitePortletFactory(Portlet portlet, SitesComponent sitesComponent) {
            this.portlet = portlet;
            this.sitesComponent = sitesComponent;
        }

        public Portlet getInstance() {
            return this.portlet;
        }

        public void release(Portlet widget) {
        }

        public Component getComponent() {
            return this.sitesComponent;
        }
    }
}

