/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.UiRuleSetsAssocWJobExpception;
import com.ericsson.cms.sites.ui.client.UiRuleSetsNotAssocWSiteExpception;
import com.ericsson.cms.sites.ui.client.i18n.RulesTabConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanelBase;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import java.util.ArrayList;
import java.util.List;

public class SitesRuleListingPanel
extends RulesListingPanelBase {
    private Integer siteId;
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants sitesConstants;
    private RulesTabConstants tabConstants;
    private ButtonWidget createButton;
    private ButtonWidget disassociateButton;

    public SitesRuleListingPanel(Packages packages) {
        super(packages, false);
        this.refreshTable();
    }

    public void setSite(Integer siteId) {
        this.siteId = siteId;
        this.refreshTable();
    }

    protected void createAndAddButtons() {
        this.createConstants();
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.CREATE) && security.isUserInRole("Sites_Modify")) {
            this.createButton = this.addButton(this.tabConstants.createRule(), "ebBtn_color_green create_button_icon", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RulesComponent.getInstance().setNewRuleAnchor(SitesRuleListingPanel.this.pkgType, SitesRuleListingPanel.this.siteId.intValue());
                }
            });
        }
        if (security.isUserInRole(Permissions.MODIFY) && security.isUserInRole("Sites_Modify")) {
            this.disassociateButton = this.addButton(this.sitesConstants.buttonLabelDissociate(), "disassociate_button_icon", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SitesRuleListingPanel.this.busyIndicator.center();
                    SitesRuleListingPanel.this.service.dissociateRuleSets(SitesRuleListingPanel.this.siteId, SitesRuleListingPanel.this.table.getSelectedIds(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            SitesRuleListingPanel.this.busyIndicator.hide();
                            SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);
                            if (caught instanceof UiRuleSetsNotAssocWSiteExpception) {
                                UiRuleSetsNotAssocWSiteExpception e = (UiRuleSetsNotAssocWSiteExpception)((Object)caught);
                                String msg = sitesMessages.dissociateFail(e.getRuleSets());
                                SitesRuleListingPanel.this.setErrorMessage(msg);
                            } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                                UiRuleSetsAssocWJobExpception e = (UiRuleSetsAssocWJobExpception)((Object)caught);
                                List<UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc> issues = e.getIssues();
                                ArrayList<String> errMsgs = new ArrayList<String>();
                                for (UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc issue : issues) {
                                    String rsId = issue.getRuleSetId();
                                    String jobNames = issue.getJobNames();
                                    String msg = sitesMessages.dissociateFailDueToJobs(rsId, jobNames);
                                    errMsgs.add(msg);
                                }
                                SitesRuleListingPanel.this.setErrorMessages(errMsgs);
                            } else {
                                SitesRuleListingPanel.this.setErrorMessage(SitesRuleListingPanel.this.sitesConstants.dissociatingRuleSetsFailed());
                            }
                        }

                        public void onNeptuneSuccess(Void result) {
                            SitesRuleListingPanel.this.refreshTable();
                            SitesRuleListingPanel.this.setInfoMessage(SitesRuleListingPanel.this.sitesConstants.dissociatingRuleSetsSucceeded());
                            SitesRuleListingPanel.this.busyIndicator.hide();
                        }
                    });
                }
            });
        }
    }

    protected void refreshTable() {
        this.createConstants();
        this.messageArea.reset();
        this.table.clear();
        if (this.siteId == null) {
            this.busyIndicator.hide();
            return;
        }
        this.busyIndicator.center();
        this.service.getRuleSetsBySiteAndPackage(this.siteId, this.pkgType, (AsyncCallback<List<UIRuleListItem>>)new NeptuneAsyncCallback<List<UIRuleListItem>>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesRuleListingPanel.this.setErrorMessage(SitesRuleListingPanel.this.sitesConstants.loadingRuleSetsFailed());
                SitesRuleListingPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UIRuleListItem> result) {
                SitesRuleListingPanel.this.populateTable(SitesRuleListingPanel.this.table, result);
                SitesRuleListingPanel.this.busyIndicator.hide();
            }
        });
    }

    public void setEnableButtons(boolean buttonEnabled) {
        this.createButton.setEnabled(buttonEnabled);
        this.disassociateButton.setEnabled(buttonEnabled);
    }

    private void createConstants() {
        if (this.sitesConstants == null) {
            this.sitesConstants = (SitesConstants)GWT.create(SitesConstants.class);
        }
        if (this.tabConstants == null) {
            this.tabConstants = (RulesTabConstants)GWT.create(RulesTabConstants.class);
        }
    }
}

