/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.BasicTab;
import com.ericsson.cms.sites.ui.client.CISInfoTab;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.JobsTab;
import com.ericsson.cms.sites.ui.client.RulesTab;
import com.ericsson.cms.sites.ui.client.SitesTree;
import com.ericsson.cms.sites.ui.client.TargetedTitlesListPanel;
import com.ericsson.cms.sites.ui.client.Util;
import com.ericsson.cms.sites.ui.client.aggregatedview.AggregatedViewTab;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.tabs.schedules.SchedulesTab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SitesTabContainer
extends Composite {
    private static final String STYLE_TABCONTAINER = "sites-tabContainer";
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";
    private static final String PMM_LICENSE_KEY = "PMMLicense";
    private VerticalContainer mainPanel;
    private MessageArea messageArea;
    private TabContainer tabContainer;
    private List<ISiteTab> tabs = new ArrayList<ISiteTab>();
    private BasicTab basicTab;
    private RulesTab rulesTab;
    private JobsTab jobsTab;
    private TargetedTitlesListPanel targetedTitlesTab;
    private AggregatedViewTab aggViewTab;
    private MSOOverridesTab msoOverridesTab;
    private SchedulesTab schedulesTab;
    private CISInfoTab cisInfoTab;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SiteCRUDNotifier crudNotifier;
    private SitesTree sitesTree;
    private NeptuneSecurity security;
    private Map<String, String> info;
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages messages = (SitesMessages)GWT.create(SitesMessages.class);

    public SitesTabContainer(SitesTree sitesTree, MessageArea messageArea, Map<String, String> info) {
        this.sitesTree = sitesTree;
        this.info = info;
        this.messageArea = messageArea;
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.crudNotifier = new SiteCRUDNotifier(){

            @Override
            public void created(UISite site, ISiteTab caller) {
                this.setSite(site, caller);
                if (site.getType() == UISiteType.TRACKING) {
                    History.newItem((String)Anchors.getAnchor(site.getId(), site.getParentId()), (boolean)false);
                } else {
                    History.newItem((String)Anchors.getAnchor(site.getId(), null), (boolean)false);
                }
                SitesTabContainer.this.sitesTree.reload(site.getId(), site.getParentId());
            }

            @Override
            public void deleted(UISite site, ISiteTab caller) {
                this.setSite(null, caller);
                History.newItem((String)"Sites.View", (boolean)false);
                SitesTabContainer.this.sitesTree.reload(null, null);
            }

            @Override
            public void updated(UISite site, ISiteTab caller) {
                this.setSite(site, caller);
                SitesTabContainer.this.sitesTree.reload(site.getId(), site.getParentId());
            }

            private void setSite(UISite site, ISiteTab ignoreTab) {
                int i = 0;
                while (i < SitesTabContainer.this.tabs.size()) {
                    ISiteTab tab = (ISiteTab)SitesTabContainer.this.tabs.get(i);
                    if (tab != ignoreTab) {
                        boolean enabled = tab.setSite(site, null);
                        SitesTabContainer.this.tabContainer.getTabBar().setTabEnabled(i, enabled);
                    }
                    ++i;
                }
            }
        };
        this.mainPanel = new VerticalContainer();
        this.mainPanel.setWidth("100%");
        this.tabContainer = new TabContainer();
        this.mainPanel.add((Widget)this.tabContainer);
        this.tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int i = 0;
                while (i < SitesTabContainer.this.tabs.size()) {
                    ((ISiteTab)SitesTabContainer.this.tabs.get(i)).setSelected(i == (Integer)event.getSelectedItem());
                    ++i;
                }
            }
        });
        this.tabContainer.addStyleName(STYLE_TABCONTAINER);
        this.addTabs();
        this.initWidget((Widget)this.mainPanel);
    }

    private void addTabs() {
        this.basicTab = new BasicTab(this.info);
        this.basicTab.setCRUDNotifier(this.crudNotifier);
        this.basicTab.setMessageArea(this.messageArea);
        this.basicTab.setParentTabContainer(this);
        this.basicTab.setTreeWidget(this.sitesTree);
        this.tabs.add(this.basicTab);
        this.tabContainer.add((Widget)this.basicTab, this.basicTab.getDisplayName());
        this.rulesTab = new RulesTab();
        this.rulesTab.setCRUDNotifier(this.crudNotifier);
        this.rulesTab.setMessageArea(this.messageArea);
        this.tabs.add(this.rulesTab);
        this.tabContainer.add((Widget)this.rulesTab, this.rulesTab.getDisplayName());
        boolean isSchedulerLicensed = Boolean.parseBoolean(this.info.get(SCHEDULER_LICENSE_KEY));
        if (isSchedulerLicensed && this.security.isUserInRole("Scheduler_View")) {
            this.jobsTab = new JobsTab();
            this.jobsTab.setCRUDNotifier(this.crudNotifier);
            this.jobsTab.setMessageArea(this.messageArea);
            this.tabs.add(this.jobsTab);
            this.tabContainer.add((Widget)this.jobsTab, this.jobsTab.getDisplayName());
        }
        this.targetedTitlesTab = new TargetedTitlesListPanel(this.info);
        this.targetedTitlesTab.setCRUDNotifier(this.crudNotifier);
        this.targetedTitlesTab.setMessageArea(this.messageArea);
        this.tabs.add(this.targetedTitlesTab);
        this.tabContainer.add((Widget)this.targetedTitlesTab, this.targetedTitlesTab.getDisplayName());
        this.aggViewTab = new AggregatedViewTab(this.info);
        this.aggViewTab.setCRUDNotifier(this.crudNotifier);
        this.aggViewTab.setMessageArea(this.messageArea);
        this.tabs.add(this.aggViewTab);
        this.tabContainer.add((Widget)this.aggViewTab, this.aggViewTab.getDisplayName());
        this.msoOverridesTab = new MSOOverridesTab(this.info);
        this.msoOverridesTab.setCRUDNotifier(this.crudNotifier);
        this.msoOverridesTab.setMessageArea(this.messageArea);
        boolean isPMMLicensed = Boolean.parseBoolean(this.info.get(PMM_LICENSE_KEY));
        if (isPMMLicensed && isSchedulerLicensed && this.security.isUserInRole("Schedules_View") && this.security.isUserInRole("Scheduler_View")) {
            this.schedulesTab = new SchedulesTab();
            this.schedulesTab.setCRUDNotifier(this.crudNotifier);
            this.schedulesTab.setMessageArea(this.messageArea);
            this.tabs.add(this.schedulesTab);
            this.tabContainer.add((Widget)this.schedulesTab, this.schedulesTab.getDisplayName());
        }
        this.cisInfoTab = new CISInfoTab();
        this.cisInfoTab.setCRUDNotifier(this.crudNotifier);
        this.cisInfoTab.setMessageArea(this.messageArea);
        this.tabs.add(this.cisInfoTab);
        this.tabContainer.add((Widget)this.cisInfoTab, this.cisInfoTab.getDisplayName());
    }

    private int findIndexOfTab(String tabName) {
        int i = 0;
        while (i < this.tabs.size()) {
            if (this.tabs.get(i).getName().equals(tabName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void anchorChanged(final String anchor) {
        if (this.isBlank(anchor)) {
            this.sitesTree.reload(null, null);
            this.reset();
            this.showSite(null, null, 0);
        } else if (anchor.startsWith("?")) {
            String tabName;
            int tabIndexToSelect;
            if (!this.security.isUserInRole("Sites_View") && !this.security.isUserInRole("Sites_Modify")) {
                this.handleUnauthorizedAccess();
                return;
            }
            String paramsStr = anchor.substring(1);
            Map<String, String> params = Util.getParams(paramsStr);
            String idStr = params.get("id");
            int id = -1;
            try {
                id = Integer.parseInt(idStr);
            }
            catch (Exception exception) {
                Window.alert((String)this.constants.invalidSiteId());
                return;
            }
            Integer parentId = null;
            if (params.containsKey("parentSiteId")) {
                String parentIdStr = params.get("parentSiteId");
                try {
                    parentId = Integer.valueOf(parentIdStr);
                }
                catch (Exception exception) {
                    Window.alert((String)this.constants.invalidParentSiteId());
                    return;
                }
            }
            if ((tabIndexToSelect = this.findIndexOfTab(tabName = params.get("tab"))) == -1) {
                tabIndexToSelect = 0;
            }
            this.showSite(id, parentId, params, tabIndexToSelect);
            this.sitesTree.select(id, parentId);
        } else if (anchor.equals("CreateLogicalSite")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            this.internalShowCreateLogicalSite();
            this.sitesTree.select(null, null);
        } else if (anchor.equals("CreateDistributionSite")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            this.verifyCreateDistSiteLicense(new Command(){

                public void execute() {
                    SitesTabContainer.this.internalShowCreateDistributionSite(null);
                    SitesTabContainer.this.sitesTree.select(null, null);
                }
            });
        } else if (anchor.startsWith("CreateDistributionSite?parentSiteId=")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            this.verifyCreateDistSiteLicense(new Command(){

                public void execute() {
                    String parentSiteIdStr = anchor.substring("CreateDistributionSite?parentSiteId=".length());
                    int parentSiteId = -1;
                    try {
                        parentSiteId = Integer.parseInt(parentSiteIdStr);
                    }
                    catch (Exception exception) {
                        Window.alert((String)SitesTabContainer.this.constants.invalidParentSiteId());
                        return;
                    }
                    SitesTabContainer.this.internalShowCreateDistributionSite(parentSiteId);
                    SitesTabContainer.this.sitesTree.select(parentSiteId, null);
                }
            });
        } else if (anchor.equals("CreateMediaPathDistributionSite")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            this.verifyCreateDistSiteLicense(new Command(){

                public void execute() {
                    SitesTabContainer.this.internalShowCreateMediaPathDistributionSite(null);
                    SitesTabContainer.this.sitesTree.select(null, null);
                }
            });
        } else if (anchor.startsWith("CreateMediaPathDistributionSite?parentSiteId=")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            this.verifyCreateDistSiteLicense(new Command(){

                public void execute() {
                    String parentSiteIdStr = anchor.substring("CreateMediaPathDistributionSite?parentSiteId=".length());
                    int parentSiteId = -1;
                    try {
                        parentSiteId = Integer.parseInt(parentSiteIdStr);
                    }
                    catch (Exception exception) {
                        Window.alert((String)SitesTabContainer.this.constants.invalidParentSiteId());
                        return;
                    }
                    SitesTabContainer.this.internalShowCreateMediaPathDistributionSite(parentSiteId);
                    SitesTabContainer.this.sitesTree.select(parentSiteId, null);
                }
            });
        } else if (anchor.startsWith("CreateTrackingSite?parentSiteId=")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            this.verifyCreateTrackSiteLicense(new Command(){

                public void execute() {
                    String parentSiteIdStr = anchor.substring("CreateTrackingSite?parentSiteId=".length());
                    int parentSiteId = -1;
                    try {
                        parentSiteId = Integer.parseInt(parentSiteIdStr);
                    }
                    catch (Exception exception) {
                        Window.alert((String)SitesTabContainer.this.constants.invalidParentSiteId());
                        return;
                    }
                    SitesTabContainer.this.internalShowCreateTrackingSite(parentSiteId);
                    SitesTabContainer.this.sitesTree.select(parentSiteId, null);
                }
            });
        } else if (anchor.startsWith("AddExistingTrackingSite?parentSiteId=")) {
            if (!this.security.isUserInRole("Sites_Create")) {
                this.handleUnauthorizedAccess();
                return;
            }
            String parentSiteIdStr = anchor.substring("AddExistingTrackingSite?parentSiteId=".length());
            int parentSiteId = -1;
            try {
                parentSiteId = Integer.parseInt(parentSiteIdStr);
            }
            catch (Exception exception) {
                Window.alert((String)this.constants.invalidParentSiteId());
                return;
            }
            this.internalShowAddExistingTrackingSite(parentSiteId);
            this.sitesTree.select(parentSiteId, null);
        } else {
            Window.alert((String)this.constants.invalidURL());
        }
    }

    public void showSite(int siteId, Integer parentSiteId) {
        History.newItem((String)Anchors.getAnchor(siteId, parentSiteId), (boolean)false);
        this.showSite(siteId, parentSiteId, null, 0);
    }

    public void showCreateLogicalSite() {
        History.newItem((String)"Sites.View.CreateLogicalSite", (boolean)false);
        this.internalShowCreateLogicalSite();
    }

    public void showCreateDistributionSite(final Integer parentSiteId) {
        this.verifyCreateDistSiteLicense(new Command(){

            public void execute() {
                if (parentSiteId == null) {
                    History.newItem((String)"Sites.View.CreateDistributionSite", (boolean)false);
                } else {
                    History.newItem((String)("Sites.View.CreateDistributionSite?parentSiteId=" + parentSiteId), (boolean)false);
                }
                SitesTabContainer.this.internalShowCreateDistributionSite(parentSiteId);
            }
        });
    }

    public void showCreateMediaPathDistributionSite(final Integer parentSiteId) {
        this.verifyCreateDistSiteLicense(new Command(){

            public void execute() {
                if (parentSiteId == null) {
                    History.newItem((String)"Sites.View.CreateMediaPathDistributionSite", (boolean)false);
                } else {
                    History.newItem((String)("Sites.View.CreateMediaPathDistributionSite?parentSiteId=" + parentSiteId), (boolean)false);
                }
                SitesTabContainer.this.internalShowCreateMediaPathDistributionSite(parentSiteId);
            }
        });
    }

    private void verifyCreateDistSiteLicense(final Command command) {
        this.busyIndicator.center();
        this.service.hasReachedMaxLicensedDistributionSites((AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesTabContainer.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(SitesTabContainer.this.constants.unableToVerifyLicense()) + SitesTabContainer.this.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(Boolean result) {
                if (result.booleanValue()) {
                    SitesTabContainer.this.busyIndicator.hide();
                    Window.alert((String)SitesTabContainer.this.constants.reachedLicensedMaxDistSites());
                    return;
                }
                command.execute();
                SitesTabContainer.this.busyIndicator.hide();
            }
        });
    }

    public void showCreateTrackingSite(final int parentSiteId) {
        this.verifyCreateTrackSiteLicense(new Command(){

            public void execute() {
                History.newItem((String)("Sites.View.CreateTrackingSite?parentSiteId=" + parentSiteId), (boolean)false);
                SitesTabContainer.this.internalShowCreateTrackingSite(parentSiteId);
            }
        });
    }

    private void verifyCreateTrackSiteLicense(final Command command) {
        this.busyIndicator.center();
        this.service.hasReachedMaxLicensedTrackingSites((AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesTabContainer.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(SitesTabContainer.this.constants.unableToVerifyLicense()) + SitesTabContainer.this.getFailureMessageSuffix(caught)));
            }

            public void onNeptuneSuccess(Boolean result) {
                if (result.booleanValue()) {
                    SitesTabContainer.this.busyIndicator.hide();
                    Window.alert((String)SitesTabContainer.this.constants.reachedLicensedMaxTrackingSites());
                    return;
                }
                command.execute();
                SitesTabContainer.this.busyIndicator.hide();
            }
        });
    }

    public void showAddExistingTrackingSite(int parentSiteId) {
        History.newItem((String)("Sites.View.AddExistingTrackingSite?parentSiteId=" + parentSiteId), (boolean)false);
        this.internalShowAddExistingTrackingSite(parentSiteId);
    }

    private void reset() {
        this.messageArea.reset();
    }

    private void internalShowCreateLogicalSite() {
        this.reset();
        this.disableAllTabsOtherThanBasic();
        this.basicTab.showCreateLogicalSite();
        this.tabContainer.selectTab(0);
    }

    private void internalShowCreateDistributionSite(Integer parentSiteId) {
        this.reset();
        this.disableAllTabsOtherThanBasic();
        this.basicTab.showCreateDistributionSite(parentSiteId);
        this.tabContainer.selectTab(0);
    }

    private void internalShowCreateMediaPathDistributionSite(Integer parentSiteId) {
        this.reset();
        this.disableAllTabsOtherThanBasic();
        this.basicTab.showCreateMediaPathDistributionSite(parentSiteId);
        this.tabContainer.selectTab(0);
    }

    private void internalShowCreateTrackingSite(int parentSiteId) {
        this.reset();
        this.disableAllTabsOtherThanBasic();
        this.basicTab.showCreateTrackingSite(parentSiteId);
        this.tabContainer.selectTab(0);
    }

    private void internalShowAddExistingTrackingSite(final int parentSiteId) {
        this.reset();
        this.disableAllTabsOtherThanBasic();
        this.basicTab.showAddExistingTrackingSite(parentSiteId, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Void result) {
                SitesTabContainer.this.showSite(parentSiteId, null);
                SitesTabContainer.this.sitesTree.reload(parentSiteId, null);
            }
        });
        this.tabContainer.selectTab(0);
    }

    private void showSite(final int siteId, Integer parentSiteId, final Map<String, String> params, final int tabToSelect) {
        this.reset();
        this.busyIndicator.center();
        this.service.get(siteId, parentSiteId, (AsyncCallback<UISite>)new NeptuneAsyncCallback<UISite>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesTabContainer.this.messageArea.setErrorMessage(String.valueOf(SitesTabContainer.this.messages.loadSiteFailed(siteId)) + SitesTabContainer.this.getFailureMessageSuffix(caught));
                SitesTabContainer.this.showSite(null, null, 0);
                SitesTabContainer.this.sitesTree.select(null, null);
                SitesTabContainer.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UISite site) {
                SitesTabContainer.this.showSite(site, params, tabToSelect);
                SitesTabContainer.this.busyIndicator.hide();
            }
        });
    }

    private void showSite(UISite site, Map<String, String> params, int tabToSelect) {
        int i = 0;
        while (i < this.tabs.size()) {
            boolean enabled = this.tabs.get(i).setSite(site, params);
            this.tabContainer.getTabBar().setTabEnabled(i, enabled);
            ++i;
        }
        this.tabContainer.selectTab(tabToSelect);
    }

    private void disableAllTabsOtherThanBasic() {
        int i = 1;
        while (i < this.tabs.size()) {
            this.tabs.get(i).setSite(null, null);
            this.tabContainer.getTabBar().setTabEnabled(i, false);
            ++i;
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }

    private String getFailureMessageSuffix(Throwable caught) {
        return " | " + this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "");
    }

    private void handleUnauthorizedAccess() {
        Window.alert((String)this.constants.unAuthorizedAction());
    }

    protected void onLoad() {
        super.onLoad();
    }

    protected void onUnload() {
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }

    public static interface SiteCRUDNotifier {
        public void created(UISite var1, ISiteTab var2);

        public void updated(UISite var1, ISiteTab var2);

        public void deleted(UISite var1, ISiteTab var2);
    }
}

