/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.SitesTreeButtonsPanel;
import com.ericsson.cms.sites.ui.client.bundle.SiteClientBundle;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.MenuBarWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SitesTree
extends TreeWidget {
    private NeptuneSecurity security;
    private boolean loaded;
    private TreeItem sitesRoot;
    private PopupContainer contextMenuContainer = new PopupContainer(true);
    private Set<UISiteTreeNode> openedSiteNodes = new HashSet<UISiteTreeNode>();
    private SitesTabContainer detailView;
    private SitesTreeButtonsPanel buttonsPanel;
    private static final SiteClientBundle bundle = new SiteClientBundle();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public SitesTree(NeptuneSecurity security) {
        this.security = security;
        this.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                UISiteTreeNode nodeData = (UISiteTreeNode)((TreeItem)event.getTarget()).getUserObject();
                if (nodeData == null) {
                    return;
                }
                SitesTree.this.openedSiteNodes.add(nodeData);
                TreeItem openedItem = (TreeItem)event.getTarget();
                openedItem.setWidget(SitesTreeItem.getWidget(nodeData, true));
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<TreeItem>(){

            public void onClose(CloseEvent<TreeItem> event) {
                UISiteTreeNode nodeData = (UISiteTreeNode)((TreeItem)event.getTarget()).getUserObject();
                if (nodeData == null) {
                    return;
                }
                SitesTree.this.openedSiteNodes.remove(nodeData);
                TreeItem closedItem = (TreeItem)event.getTarget();
                closedItem.setWidget(SitesTreeItem.getWidget(nodeData, false));
            }
        });
        this.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem selectedItem = (TreeItem)event.getSelectedItem();
                UISiteTreeNode nodeData = (UISiteTreeNode)selectedItem.getUserObject();
                if (nodeData == null) {
                    return;
                }
                int id = nodeData.getId();
                Integer parentId = null;
                if (nodeData.getType() == UISiteType.TRACKING) {
                    TreeItem parentItem = selectedItem.getParentItem();
                    UISiteTreeNode parentNodeData = (UISiteTreeNode)parentItem.getUserObject();
                    parentId = parentNodeData.getId();
                }
                SitesTree.this.detailView.showSite(id, parentId);
                SitesTree.this.buttonsPanel.setSiteInfo(nodeData);
            }
        });
    }

    public SitesTree(Tree.Resources images, NeptuneSecurity security) {
        super(images);
        this.security = security;
        this.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                UISiteTreeNode nodeData = (UISiteTreeNode)((TreeItem)event.getTarget()).getUserObject();
                if (nodeData == null) {
                    return;
                }
                SitesTree.this.openedSiteNodes.add(nodeData);
                TreeItem openedItem = (TreeItem)event.getTarget();
                openedItem.setWidget(SitesTreeItem.getWidget(nodeData, true));
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<TreeItem>(){

            public void onClose(CloseEvent<TreeItem> event) {
                UISiteTreeNode nodeData = (UISiteTreeNode)((TreeItem)event.getTarget()).getUserObject();
                if (nodeData == null) {
                    return;
                }
                SitesTree.this.openedSiteNodes.remove(nodeData);
                TreeItem closedItem = (TreeItem)event.getTarget();
                closedItem.setWidget(SitesTreeItem.getWidget(nodeData, false));
            }
        });
        this.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem selectedItem = (TreeItem)event.getSelectedItem();
                UISiteTreeNode nodeData = (UISiteTreeNode)selectedItem.getUserObject();
                if (nodeData == null) {
                    return;
                }
                int id = nodeData.getId();
                Integer parentId = null;
                if (nodeData.getType() == UISiteType.TRACKING) {
                    TreeItem parentItem = selectedItem.getParentItem();
                    UISiteTreeNode parentNodeData = (UISiteTreeNode)parentItem.getUserObject();
                    parentId = parentNodeData.getId();
                }
                SitesTree.this.detailView.showSite(id, parentId);
                SitesTree.this.buttonsPanel.setSiteInfo(nodeData);
            }
        });
    }

    public void setDetailView(SitesTabContainer detailView) {
        this.detailView = detailView;
    }

    public void setButtonsPanel(SitesTreeButtonsPanel buttonsPanel) {
        this.buttonsPanel = buttonsPanel;
    }

    public void reload(final Integer siteIdToSelect, final Integer parentSiteIdToSelect) {
        this.busyIndicator.center();
        this.service.getSiteTree((AsyncCallback<List<UISiteTreeNode>>)new NeptuneAsyncCallback<List<UISiteTreeNode>>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesTree.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(SitesTree.this.constants.loadingSitesFailed()) + " | " + SitesTree.this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "")));
            }

            public void onNeptuneSuccess(List<UISiteTreeNode> result) {
                SitesTree.this.loaded = true;
                SitesTree.this.renderTree(result);
                SitesTree.this.buttonsPanel.reset();
                if (siteIdToSelect != null) {
                    SitesTree.this.selectTreeItem(siteIdToSelect, parentSiteIdToSelect);
                }
                SitesTree.this.busyIndicator.hide();
            }
        });
    }

    public void select(Integer siteIdToSelect, Integer parentSiteIdToSelect) {
        if (!this.loaded) {
            this.reload(siteIdToSelect, parentSiteIdToSelect);
        } else if (siteIdToSelect == null) {
            this.clearSelection();
        } else {
            this.selectTreeItem(siteIdToSelect, parentSiteIdToSelect);
        }
    }

    private void renderTree(List<UISiteTreeNode> treeData) {
        this.removeItems();
        this.propagateError(treeData);
        this.addToTreeItem(null, treeData);
        Iterator<UISiteTreeNode> openedSiteNodeIter = this.openedSiteNodes.iterator();
        while (openedSiteNodeIter.hasNext()) {
            UISiteTreeNode openedSiteNode = openedSiteNodeIter.next();
            boolean foundAndHasChildren = false;
            Iterator treeItemIterator = this.treeItemIterator();
            while (treeItemIterator.hasNext()) {
                TreeItem treeItem = (TreeItem)treeItemIterator.next();
                if (!openedSiteNode.equals(treeItem.getUserObject())) continue;
                if (treeItem.getChildCount() <= 0) break;
                treeItem.setState(true, false);
                foundAndHasChildren = true;
                break;
            }
            if (foundAndHasChildren) continue;
            openedSiteNodeIter.remove();
        }
    }

    private void addToTreeItem(TreeItem parentTreeItem, List<UISiteTreeNode> treeData) {
        for (UISiteTreeNode nodeData : treeData) {
            SitesTreeItem treeItem = new SitesTreeItem(nodeData);
            if (parentTreeItem != null) {
                parentTreeItem.addItem((TreeItem)treeItem);
            } else {
                this.addItem(treeItem);
            }
            if (!nodeData.hasChildren()) continue;
            this.addToTreeItem(treeItem, nodeData.getChildren());
        }
    }

    private boolean propagateError(List<UISiteTreeNode> treeData) {
        boolean isError = false;
        for (UISiteTreeNode nodeData : treeData) {
            if (nodeData.hasChildren()) {
                nodeData.setDescendantHasError(this.propagateError(nodeData.getChildren()));
            } else {
                nodeData.setDescendantHasError(nodeData.isError());
            }
            if (!nodeData.isError() && !nodeData.isDescendantHasError()) continue;
            isError = true;
        }
        return isError;
    }

    private void setupContextMenu() {
        this.addDomHandler((EventHandler)new ContextMenuHandler(){

            public void onContextMenu(ContextMenuEvent event) {
                SitesTree.this.showContextMenu();
                event.preventDefault();
                event.stopPropagation();
            }
        }, ContextMenuEvent.getType());
    }

    private void showContextMenu() {
        TreeItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        MenuBarWidget menu = new MenuBarWidget(true);
        this.contextMenuContainer.setWidget((Widget)menu);
        boolean hasMenuItems = false;
        if (selectedItem == this.getItem(0)) {
            if (this.security.isUserInRole("Sites_Create")) {
                hasMenuItems = true;
                menu.addItem(this.constants.menuCreateTopLevelLogicalSite(), (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        SitesTree.this.hideContextMenu();
                        SitesTree.this.detailView.showCreateLogicalSite();
                    }
                });
                menu.addItem(this.constants.menuCreateTopLevelDistributionSite(), (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        SitesTree.this.hideContextMenu();
                        SitesTree.this.detailView.showCreateDistributionSite(null);
                    }
                });
                menu.addItem(this.constants.menuCreateTopLevelMediapathDistributionSite(), (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        SitesTree.this.hideContextMenu();
                        SitesTree.this.detailView.showCreateMediaPathDistributionSite(null);
                    }
                });
            }
        } else {
            final UISiteTreeNode siteNode = (UISiteTreeNode)selectedItem.getUserObject();
            switch (siteNode.getType()) {
                case LOGICAL: {
                    if (!this.security.isUserInRole("Sites_Create")) break;
                    hasMenuItems = true;
                    menu.addItem(this.constants.menuCreateChildDistributionSite(), (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            SitesTree.this.hideContextMenu();
                            SitesTree.this.detailView.showCreateDistributionSite(siteNode.getId());
                        }
                    });
                    menu.addItem(this.constants.menuCreateChildMediapathDistributionSite(), (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            SitesTree.this.hideContextMenu();
                            SitesTree.this.detailView.showCreateMediaPathDistributionSite(siteNode.getId());
                        }
                    });
                    break;
                }
                case DISTRIBUTION: 
                case MEDIAPATH_DISTRIBUTION: {
                    if (!this.security.isUserInRole("Sites_View") || !this.security.isUserInRole("Sites_Create")) break;
                    hasMenuItems = true;
                    menu.addItem(this.constants.menuCreateChildTrackingSite(), (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            SitesTree.this.hideContextMenu();
                            SitesTree.this.detailView.showCreateTrackingSite(siteNode.getId());
                        }
                    });
                    menu.addItem(this.constants.menuAddExistingTrackingSite(), (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            SitesTree.this.hideContextMenu();
                            SitesTree.this.detailView.showAddExistingTrackingSite(siteNode.getId());
                        }
                    });
                    break;
                }
                case TRACKING: {
                    if (!siteNode.isShared() || !this.security.isUserInRole("Sites_Modify")) break;
                    hasMenuItems = true;
                    menu.addItem(this.constants.menuDissociateFromParent(), (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            SitesTree.this.hideContextMenu();
                            SitesTree.this.dissociateFromParent(siteNode.getId(), siteNode.getParent().getId());
                        }
                    });
                }
            }
        }
        if (hasMenuItems) {
            Widget relativeWidget = selectedItem != null ? selectedItem.getWidget() : this.getItem(0).getWidget();
            this.contextMenuContainer.setPopupPosition(relativeWidget.getAbsoluteLeft(), relativeWidget.getAbsoluteTop() + relativeWidget.getOffsetHeight());
            this.contextMenuContainer.show();
        }
    }

    private void hideContextMenu() {
        this.contextMenuContainer.hide();
    }

    private void dissociateFromParent(int trackingSiteId, final int parentDistSiteId) {
        this.busyIndicator.center();
        this.service.dissociateTrackingSite(trackingSiteId, parentDistSiteId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesTree.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(SitesTree.this.constants.dissociatingTrackingSiteFailed()) + " | " + SitesTree.this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "")));
            }

            public void onNeptuneSuccess(Void result) {
                SitesTree.this.reload(parentDistSiteId, null);
                SitesTree.this.detailView.showSite(parentDistSiteId, null);
            }
        });
    }

    private void selectTreeItem(int id, Integer parentSiteId) {
        SitesTreeItem item = null;
        if (parentSiteId != null) {
            SitesTreeItem parentItem = this.findFirstTreeItemById(parentSiteId, null);
            if (parentItem != null) {
                item = this.findFirstTreeItemById(id, parentItem);
            }
        } else {
            item = this.findFirstTreeItemById(id, null);
        }
        if (item != null) {
            item.getTree().setSelectedItem((TreeItem)item, false);
            item.getTree().ensureSelectedItemVisible();
            UISiteTreeNode selectedUiSiteTreeNode = (UISiteTreeNode)item.getUserObject();
            this.buttonsPanel.setSiteInfo(selectedUiSiteTreeNode);
        }
    }

    private SitesTreeItem findFirstTreeItemById(int id, TreeItem parentItem) {
        SitesTreeItem retItem = null;
        if (parentItem != null) {
            int numChildItems = parentItem.getChildCount();
            int i = 0;
            while (i < numChildItems) {
                int candidateId;
                UISiteTreeNode uiNode;
                TreeItem childItem = parentItem.getChild(i);
                if (childItem == null || !(childItem instanceof SitesTreeItem) || (uiNode = (UISiteTreeNode)childItem.getUserObject()) == null || (retItem = id == (candidateId = uiNode.getId()) ? (SitesTreeItem)childItem : this.findFirstTreeItemById(id, childItem)) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int numRootItems = this.getItemCount();
            int i = 0;
            while (i < numRootItems) {
                int candidateId;
                UISiteTreeNode uiNode;
                TreeItem rootItem = this.getItem(i);
                if (rootItem == null || !(rootItem instanceof SitesTreeItem) || (uiNode = (UISiteTreeNode)rootItem.getUserObject()) == null || (retItem = id == (candidateId = uiNode.getId()) ? (SitesTreeItem)rootItem : this.findFirstTreeItemById(id, rootItem)) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        return retItem;
    }

    private void clearSelection() {
        this.clearSelection(this.sitesRoot);
        this.buttonsPanel.reset();
    }

    private boolean clearSelection(TreeItem item) {
        if (item == null) {
            return false;
        }
        if (item.isSelected()) {
            item.setSelected(false);
            return true;
        }
        if (item.getChildCount() > 0) {
            int i = 0;
            while (i < item.getChildCount()) {
                boolean cleared = this.clearSelection(item.getChild(i));
                if (cleared) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static class SitesTreeItem
    extends TreeItem {
        private static final String STYLE_TREEITEM_SELECTED = "sites-treeItem-selected";
        private static final String STYLE_TREEITEM = "sites-treeItem";

        public SitesTreeItem(UISiteTreeNode nodeData) {
            super(SitesTreeItem.getWidget(nodeData, false));
            this.setUserObject(nodeData);
        }

        private static Widget getWidget(UISiteTreeNode nodeData, boolean isLocalError) {
            HorizontalContainer container = new HorizontalContainer();
            container.setSpacing(2);
            ImageWidget icon = SitesTreeItem.getImage(nodeData, isLocalError);
            container.add((Widget)icon);
            LabelWidget label = new LabelWidget(nodeData.getName());
            container.add((Widget)label);
            return container;
        }

        private static ImageWidget getImage(UISiteTreeNode siteNode, boolean isLocalError) {
            ImageWidget icon = new ImageWidget();
            bundle.updateSiteIcon((Image)icon, siteNode, isLocalError);
            return icon;
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            if (selected) {
                this.getWidget().addStyleName(STYLE_TREEITEM_SELECTED);
            } else {
                this.getWidget().removeStyleName(STYLE_TREEITEM_SELECTED);
            }
        }
    }
}

