/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.CreateSiteDialogBox;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class SitesTreeButtonsPanel
extends Composite {
    private static final String STYLE_SITES_TREE_BUTTONS_PANEL = "sites-tree-buttons-panel";
    private Button createButton;
    private FlowPanel buttonsPanel;
    private SitesTabContainer detailView;
    private NeptuneSecurity security;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public SitesTreeButtonsPanel(final NeptuneSecurity security) {
        this.security = security;
        this.buttonsPanel = new FlowPanel();
        this.buttonsPanel.setStyleName(STYLE_SITES_TREE_BUTTONS_PANEL);
        this.createButton = new Button(this.constants.buttonLabelCreate());
        this.buttonsPanel.add((Widget)this.createButton);
        this.createButton.removeStyleName("gwt-Button");
        this.createButton.addStyleName("ebBtn");
        this.createButton.addStyleName("ebBtn_color_green");
        this.createButton.addStyleName("create_button_icon");
        this.createButton.addClickHandler(new ClickHandler(){

            public void onClick(final ClickEvent event) {
                final CreateSiteDialogBox createSiteDialogBox = new CreateSiteDialogBox(security, true, true, SitesTreeButtonsPanel.this.detailView);
                createSiteDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                    public void setPosition(int offsetWidth, int offsetHeight) {
                        Button source = (Button)event.getSource();
                        int left = source.getAbsoluteLeft() + source.getOffsetWidth();
                        int top = source.getAbsoluteTop() - offsetHeight;
                        createSiteDialogBox.setPopupPosition(left, top);
                    }
                });
            }
        });
        this.initWidget((Widget)this.buttonsPanel);
        this.reset();
    }

    public void setSiteInfo(UISiteTreeNode siteInfo) {
        this.configureButtons(this.security, siteInfo);
    }

    private void configureButtons(NeptuneSecurity security, UISiteTreeNode siteInfo) {
        this.reset();
    }

    public void reset() {
        this.createButton.setEnabled(this.security.isUserInRole("Sites_Create"));
    }

    public void setDetailView(SitesTabContainer detailView) {
        this.detailView = detailView;
    }
}

