/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.SitesTree;
import com.ericsson.cms.sites.ui.client.SitesTreeButtonsPanel;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeResource;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.Map;

public class SitesViewPanel
extends Composite
implements WidgetMenuItem.AnchorChangeListener {
    private static final String STYLE_SITES_TREE_DOCK_PANEL = "sites-tree-dock-panel";
    private static final String STYLE_SITES_TABCONTAINER_DOCK_PANEL = "sites-tabContainer-dock-panel";
    private static final int CMS_MENU_HEADER_HEIGHT = 178;
    private static final int SITES_TREE_WIDTH = 193;
    private HeaderPanel breadCrumbsPanel;
    private SitesTree treeWidget;
    private SitesTabContainer sitesTabContainer;
    private SitesTreeButtonsPanel buttonsPanel;
    private DockPanel leftDockPanel;
    private VerticalPanel sitesTreeContainer;
    private ScrollPanel sitesTreeScrollPanel;
    private VerticalPanel sitesListPanel;
    private DockPanel rightDockPanel;
    private MessageArea messageArea;
    private HandlerRegistration windowRegistration = null;
    private Scheduler.ScheduledCommand resizeCommand;
    private ISiteClientBundle bundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public SitesViewPanel(NeptuneSecurity security, Map<String, String> info) {
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setSpacing(10);
        this.breadCrumbsPanel = new HeaderPanel(this.constants.breadCrumbsViewSites());
        this.breadCrumbsPanel.setStyleName("sites-header-style");
        mainPanel.add((Widget)this.breadCrumbsPanel);
        HorizontalContainer hc = new HorizontalContainer();
        Image imgActLogSite = new Image(this.bundle.logicalSite());
        Image imgInActLogSite = new Image(this.bundle.logicalSiteDisabled());
        Image imgActDisSite = new Image(this.bundle.distributionSite());
        Image imgInActDisSite = new Image(this.bundle.distributionSiteDisabled());
        Image imgActTrkSite = new Image(this.bundle.trackingSite());
        Image imgInActTrkSite = new Image(this.bundle.trackingSiteDisabled());
        Image imgInActSharedTrkSite = new Image(this.bundle.sharedTrackingSiteDisabled());
        Image imgActSharedTrkSite = new Image(this.bundle.sharedTrackingSite());
        LabelWidget lblActLogSite = new LabelWidget(this.constants.activeLogical());
        LabelWidget lblInActLogSite = new LabelWidget(this.constants.inActiveLogical());
        LabelWidget lblActDisSite = new LabelWidget(this.constants.activeDist());
        LabelWidget lblInActDisSite = new LabelWidget(this.constants.inActiveDist());
        LabelWidget lblActTrkSite = new LabelWidget(this.constants.activeTrack());
        LabelWidget lblInActTrkSite = new LabelWidget(this.constants.inActiveTrack());
        LabelWidget lblActSharedTrkSite = new LabelWidget(this.constants.activeSharedTrack());
        LabelWidget lblInActSharedTrkSite = new LabelWidget(this.constants.inActiveSharedTrack());
        hc.add((Widget)imgActLogSite);
        hc.add((Widget)lblActLogSite);
        hc.add((Widget)imgInActLogSite);
        hc.add((Widget)lblInActLogSite);
        hc.add((Widget)imgActDisSite);
        hc.add((Widget)lblActDisSite);
        hc.add((Widget)imgInActDisSite);
        hc.add((Widget)lblInActDisSite);
        hc.add((Widget)imgActTrkSite);
        hc.add((Widget)lblActTrkSite);
        hc.add((Widget)imgInActTrkSite);
        hc.add((Widget)lblInActTrkSite);
        hc.add((Widget)imgActSharedTrkSite);
        hc.add((Widget)lblActSharedTrkSite);
        hc.add((Widget)imgInActSharedTrkSite);
        hc.add((Widget)lblInActSharedTrkSite);
        hc.setStyleName("sites-Legend-Icons");
        mainPanel.add((Widget)hc);
        HorizontalContainer horizontalPanel = new HorizontalContainer();
        mainPanel.add((Widget)horizontalPanel);
        horizontalPanel.setWidth("100%");
        horizontalPanel.setHeight("100%");
        TreeResource images = new TreeResource();
        this.treeWidget = new SitesTree((Tree.Resources)images, security);
        this.sitesTreeContainer = new VerticalPanel();
        this.sitesTreeContainer.add((Widget)this.treeWidget);
        this.sitesTreeScrollPanel = new ScrollPanel();
        this.sitesTreeScrollPanel.add((Widget)this.sitesTreeContainer);
        this.buttonsPanel = new SitesTreeButtonsPanel(security);
        this.leftDockPanel = new DockPanel();
        this.leftDockPanel.add((Widget)this.buttonsPanel, DockPanel.SOUTH);
        this.leftDockPanel.add((Widget)this.sitesTreeScrollPanel, DockPanel.CENTER);
        this.leftDockPanel.setStyleName(STYLE_SITES_TREE_DOCK_PANEL);
        horizontalPanel.add((Widget)this.leftDockPanel);
        horizontalPanel.setCellHorizontalAlignment((Widget)this.leftDockPanel, HasHorizontalAlignment.ALIGN_LEFT);
        horizontalPanel.setCellWidth((Widget)this.leftDockPanel, "200px");
        VerticalPanel messagePanel = new VerticalPanel();
        this.messageArea = new MessageArea();
        messagePanel.add((Widget)this.messageArea);
        this.sitesTabContainer = new SitesTabContainer(this.treeWidget, this.messageArea, info);
        this.rightDockPanel = new DockPanel();
        this.rightDockPanel.add((Widget)messagePanel, DockPanel.NORTH);
        this.rightDockPanel.add((Widget)this.sitesTabContainer, DockPanel.CENTER);
        this.rightDockPanel.setStyleName(STYLE_SITES_TABCONTAINER_DOCK_PANEL);
        horizontalPanel.add((Widget)this.rightDockPanel);
        horizontalPanel.setCellHorizontalAlignment((Widget)this.rightDockPanel, HasHorizontalAlignment.ALIGN_LEFT);
        this.treeWidget.setDetailView(this.sitesTabContainer);
        this.treeWidget.setButtonsPanel(this.buttonsPanel);
        this.buttonsPanel.setDetailView(this.sitesTabContainer);
        this.initWidget((Widget)mainPanel);
        this.resizeCommand = new Scheduler.ScheduledCommand(){

            public void execute() {
                SitesViewPanel.this.resizeSitesTreeScrollPanel();
            }
        };
        this.updateSitesTreeScrollPanelSize();
    }

    public void anchorChanged(String anchor) {
        this.sitesTabContainer.anchorChanged(anchor);
    }

    protected void updateSitesTreeScrollPanelSize() {
        Scheduler.get().scheduleDeferred(this.resizeCommand);
    }

    protected void resizeSitesTreeScrollPanel() {
        int treeWidth = 193;
        int treeHeight = Window.getClientHeight() - 178;
        treeHeight -= this.breadCrumbsPanel.getOffsetHeight();
        this.treeWidget.setPixelSize(treeWidth, treeHeight -= this.buttonsPanel.getOffsetHeight());
        this.sitesTabContainer.setPixelSize(Window.getClientWidth() - treeWidth - 100, treeHeight + this.buttonsPanel.getOffsetHeight() - 100);
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                SitesViewPanel.this.updateSitesTreeScrollPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }
}

