/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StatusPluginPanel
extends Composite
implements ChangeHandler {
    public static final int DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH = 10;
    public static final int DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH_EXCESS = 5;
    public static final String DEFAULT_PROPERTY_VALUE_NULL_STRING = "";
    private VerticalContainer container;
    private HorizontalContainer listBoxContainer;
    private ListBoxWidget<UIStatusPlugin> listBox;
    private FlexTable propsTable;
    private ImageWidget isNotLoadedImage;
    private ISiteClientBundle clientBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);
    private UIStatusPlugin associatedPlugin;
    private List<UIStatusPlugin> availablePlugins = new ArrayList<UIStatusPlugin>();
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private static final String NOT_LOAD_STYLE = "not_loaded_image";

    public StatusPluginPanel() {
        this.container = new VerticalContainer();
        this.initWidget((Widget)this.container);
        this.container.setBorderWidth(1);
        this.listBoxContainer = new HorizontalContainer();
        this.listBoxContainer.setSpacing(1);
        this.isNotLoadedImage = new ImageWidget();
        this.isNotLoadedImage.setResource(this.clientBundle.sitePluginConfigurationError());
        this.isNotLoadedImage.addStyleName(NOT_LOAD_STYLE);
        this.isNotLoadedImage.setTitle(this.constants.invalidStatusPlugin());
        this.isNotLoadedImage.setVisible(false);
        this.listBoxContainer.add((Widget)this.isNotLoadedImage);
        this.listBox = new ListBoxWidget();
        this.listBox.addChangeHandler((ChangeHandler)this);
        this.listBoxContainer.add(this.listBox);
        this.container.add((Widget)this.listBoxContainer);
        this.propsTable = new FlexTable();
        this.container.add((Widget)this.propsTable);
    }

    public void setAssociatedPlugin(UIStatusPlugin uiStatusPlugin) {
        this.associatedPlugin = uiStatusPlugin;
        this.displayAssociatedPlugin();
    }

    public UIStatusPlugin getAssociatedPlugin() {
        return this.associatedPlugin;
    }

    public void setAvailablePlugins(List<UIStatusPlugin> availablePlugins) {
        if (availablePlugins != null) {
            this.availablePlugins.clear();
            this.availablePlugins.addAll(availablePlugins);
            this.listBox.clear();
            for (UIStatusPlugin uiStatusPlugin : availablePlugins) {
                this.addPluginToListBox(uiStatusPlugin);
            }
        }
        if (this.associatedPlugin != null) {
            this.displayAssociatedPlugin();
        }
    }

    private void displayAssociatedPlugin() {
        boolean isAssociatedPluginAvailable = this.availablePlugins.contains(this.associatedPlugin);
        if (!isAssociatedPluginAvailable) {
            this.addPluginToListBox(this.associatedPlugin);
            this.isNotLoadedImage.setVisible(true);
        } else {
            this.isNotLoadedImage.setVisible(false);
        }
        this.listBox.setSelectedItem((Object)this.associatedPlugin);
        this.refreshView();
    }

    private void refreshView() {
        if (this.associatedPlugin != null) {
            this.updatePropsTable(this.associatedPlugin);
        }
    }

    private void updatePropsTable(UIStatusPlugin uiStatusPlugin) {
        if (uiStatusPlugin != null) {
            this.propsTable.clear(false);
            Map<String, String> props = uiStatusPlugin.getConfiguration();
            int row = 0;
            int column = 0;
            if (props != null) {
                for (String key : props.keySet()) {
                    String value = props.get(key);
                    value = value != null ? value : DEFAULT_PROPERTY_VALUE_NULL_STRING;
                    this.propsTable.setWidget(row, column, (Widget)new LabelWidget(key));
                    ++column;
                    TextBoxWidget valueWidget = new TextBoxWidget();
                    int valueLength = value.length();
                    int valueTextBoxLength = valueLength > 10 ? valueLength + 5 : 10;
                    valueWidget.setMaxLength(valueTextBoxLength);
                    valueWidget.setVisibleLength(valueTextBoxLength);
                    valueWidget.setText(value);
                    valueWidget.setEnabled(false);
                    this.propsTable.setWidget(row, column, (Widget)valueWidget);
                    column = 0;
                    ++row;
                }
            }
        }
    }

    private void addPluginToListBox(UIStatusPlugin uiStatusPlugin) {
        if (uiStatusPlugin != null) {
            String displayName;
            String pluginName = uiStatusPlugin.getId();
            Map<String, String> config = uiStatusPlugin.getConfiguration();
            if (config != null && (displayName = config.get("Display Name")) != null && !displayName.trim().isEmpty()) {
                pluginName = displayName;
            }
            this.listBox.addItem(pluginName, (Object)uiStatusPlugin);
        }
    }

    public void reset() {
        this.associatedPlugin = null;
        this.availablePlugins = new ArrayList<UIStatusPlugin>();
    }

    public void onChange(ChangeEvent event) {
        this.associatedPlugin = (UIStatusPlugin)this.listBox.getSelectedItem();
        boolean isAssociatedPluginAvailable = this.availablePlugins.contains(this.associatedPlugin);
        if (!isAssociatedPluginAvailable) {
            this.isNotLoadedImage.setVisible(true);
        } else {
            this.isNotLoadedImage.setVisible(false);
        }
        this.refreshView();
    }
}

