/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.TargetedTitlesTableDataProvider;
import com.ericsson.cms.sites.ui.client.TitleRecord;
import com.ericsson.cms.sites.ui.client.entities.DistributeTitlesResponse;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TargetedTitlesListPanel
extends Composite
implements IView,
ISiteTab,
ClickHandler {
    private static final int MAIN_PANEL_OFFSET_HEIGHT = 250;
    private static final String STYLE_NAME = "content-TitleListPanel";
    private static final int SPACING = 2;
    private ScrollContainer rootContainer;
    private VerticalContainer container;
    private NeptuneSecurity security;
    private String specificationName;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private MessageArea messageArea;
    private boolean selectButtonVisible = false;
    private Table<Long, TitleRecord> assetTable;
    private TargetedTitlesTableDataProvider dp;
    private ButtonWidget goButton;
    private TextBox searchBox = new TextBox();
    private ListBoxWidget<String> statusFilter = new ListBoxWidget();
    private ListBoxWidget<String> actionsListBox;
    private ListBoxWidget<String> parameterListBox;
    private ListBoxWidget<String> multiSelectParameterListBox;
    private HorizontalContainer actionListContainer;
    private static final String ACTION_DISTRIBUTE = "DISTRIBUTE";
    private static final String ACTION_DELETE = "DELETE";
    private static final String ACTION_RUN_TEMPLATE = "RUN_TEMPLATE";
    private String TARGETED_TITLES_LIST_PANEL_REFRESH_KEY = "site.targetedtitles.refreshTime";
    private int DEFAULT_TARGETED_TITLES_LIST_PANEL_REFRESH_TIME = 60;
    ButtonClickListener actionButtonHandler = null;
    boolean useMultiSelectParameters = false;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private IUISiteServiceAsync siteService = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private Timer refreshTimer;
    private int refreshPeriod;
    private UISite uiSite;
    private HandlerRegistration windowRegistration = null;

    public TargetedTitlesListPanel(Map<String, String> info) {
        this.showBusyIndicator();
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.specificationName = info.get("ContentComponent.Specification");
        this.refreshPeriod = this.getRefreshPeriod(info);
        this.initWidgets();
        this.initializeDataProvider();
        this.refreshTimer = new Timer(){

            public void run() {
                TargetedTitlesListPanel.this.refreshView();
            }
        };
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TargetedTitlesListPanel.this.updateMainPanelSize();
            }
        });
        this.hideBusyIndicator();
    }

    private void refreshView() {
        if (this.uiSite != null) {
            this.refreshView(this.uiSite);
        }
    }

    private Widget getSearchWidget() {
        VerticalPanel container = new VerticalPanel();
        HorizontalPanel mainPanel = new HorizontalPanel();
        mainPanel.addStyleName("cms_button_container");
        Label title = new Label(this.constants.filterListLabel());
        SimpleContainer simpleContainer = new SimpleContainer();
        simpleContainer.setWidget((Widget)title);
        simpleContainer.addStyleName("targeted-titles-filter-panel-header");
        container.add((Widget)simpleContainer);
        container.add((Widget)mainPanel);
        this.searchBox.setVisibleLength(40);
        this.searchBox.setMaxLength(255);
        Label text = new Label(this.constants.textLabel());
        mainPanel.add((Widget)text);
        mainPanel.add((Widget)this.searchBox);
        this.searchBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    TargetedTitlesListPanel.this.cleanup();
                    TargetedTitlesListPanel.this.assetTable.refresh();
                }
            }
        });
        Button search = new Button(this.constants.filterButton());
        search.removeStyleName("gwt-Button");
        search.addStyleName("ebBtn");
        search.addStyleName("ebBtn_color_darkBlue");
        search.addStyleName("search_button_icon");
        search.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TargetedTitlesListPanel.this.cleanup();
                TargetedTitlesListPanel.this.assetTable.refresh();
            }
        });
        Button clear = new Button(this.constants.clearButton());
        clear.removeStyleName("gwt-Button");
        clear.addStyleName("ebBtn");
        clear.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TargetedTitlesListPanel.this.cleanup();
                TargetedTitlesListPanel.this.searchBox.setText("");
                TargetedTitlesListPanel.this.statusFilter.setSelectedIndex(0);
                TargetedTitlesListPanel.this.assetTable.refresh();
            }
        });
        Label status = new Label(this.constants.statusLabel());
        status.addStyleName("targeted-titles-filter-panel-label");
        mainPanel.add((Widget)status);
        mainPanel.add(this.statusFilter);
        mainPanel.add((Widget)search);
        mainPanel.add((Widget)clear);
        int i = 0;
        while (i < mainPanel.getWidgetCount()) {
            Widget w = mainPanel.getWidget(i);
            mainPanel.setCellVerticalAlignment(w, HasVerticalAlignment.ALIGN_MIDDLE);
            ++i;
        }
        mainPanel.addStyleName("target-titles-filter-panel");
        return container;
    }

    public void clearQuickSearchData(UISiteType uiSiteType) {
        block3: {
            block2: {
                this.searchBox.setText("");
                this.statusFilter.clear();
                this.statusFilter.addItem("", (Object)"");
                if (!uiSiteType.equals((Object)UISiteType.DISTRIBUTION) && !uiSiteType.equals((Object)UISiteType.MEDIAPATH_DISTRIBUTION)) break block2;
                UIDistributionStatus[] uIDistributionStatusArray = UIDistributionStatus.values();
                int n = uIDistributionStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UIDistributionStatus item = uIDistributionStatusArray[n2];
                    this.statusFilter.addItem(this.constants.getString(item.name().toLowerCase()), (Object)item.name());
                    ++n2;
                }
                break block3;
            }
            if (!uiSiteType.equals((Object)UISiteType.TRACKING)) break block3;
            UITrackingStatus[] uITrackingStatusArray = UITrackingStatus.values();
            int n = uITrackingStatusArray.length;
            int n3 = 0;
            while (n3 < n) {
                UITrackingStatus item = uITrackingStatusArray[n3];
                this.statusFilter.addItem(this.constants.getString(item.name().toLowerCase()), (Object)item.name());
                ++n3;
            }
        }
    }

    public String getTextFilter() {
        return this.searchBox.getText().trim();
    }

    public String getStatusFilter() {
        if (this.statusFilter.getSelectedItem() == null) {
            return "";
        }
        return (String)this.statusFilter.getSelectedItem();
    }

    private int getRefreshPeriod(Map<String, String> info) {
        String refreshPeriod = info.get(this.TARGETED_TITLES_LIST_PANEL_REFRESH_KEY);
        try {
            int refresh = Integer.parseInt(refreshPeriod.trim());
            if (refresh < this.DEFAULT_TARGETED_TITLES_LIST_PANEL_REFRESH_TIME) {
                refresh = this.DEFAULT_TARGETED_TITLES_LIST_PANEL_REFRESH_TIME;
            }
            return refresh * 1000;
        }
        catch (Exception exception) {
            return this.DEFAULT_TARGETED_TITLES_LIST_PANEL_REFRESH_TIME * 1000;
        }
    }

    private void initWidgets() {
        this.rootContainer = new ScrollContainer();
        this.rootContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.rootContainer);
        this.container = new VerticalContainer();
        this.container.add(this.getSearchWidget());
        this.rootContainer.setWidget((Widget)this.container);
        this.container.setSpacing(2);
        this.actionListContainer = new HorizontalContainer();
        this.actionListContainer.addStyleName("cms_button_container");
        this.actionListContainer.setSpacing(2);
        this.actionsListBox = new ListBoxWidget(false);
        this.parameterListBox = new ListBoxWidget(false);
        this.parameterListBox.setVisible(false);
        this.multiSelectParameterListBox = new ListBoxWidget(true);
        this.multiSelectParameterListBox.setVisible(false);
        this.goButton = new ButtonWidget(this.constants.goButtonName());
        this.goButton.addClickHandler((ClickHandler)this);
        this.goButton.removeStyleName("gwt-Button");
        this.goButton.addStyleName("ebBtn");
        this.goButton.addStyleName("ebBtn_color_green");
        this.actionListContainer.add(this.actionsListBox);
        this.actionListContainer.add(this.parameterListBox);
        this.actionListContainer.add((Widget)this.goButton);
    }

    private void initializeDataProvider() {
        this.dp = new TargetedTitlesTableDataProvider(this);
        this.dp.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                TargetedTitlesListPanel.this.hideBusyIndicator();
                Window.alert((String)("Failed to initialize Asset Table Data Provider. Reason: " + (caught != null ? caught.getMessage() : "")));
            }

            public void onNeptuneSuccess(Void result) {
                TargetedTitlesListPanel.this.initializeTable();
            }
        });
    }

    private void initializeTable() {
        this.assetTable = new Table((DataProvider)this.dp);
        CookieStoreBasedPageFeatureImpl pageFeature = new CookieStoreBasedPageFeatureImpl("titleList");
        this.dp.setPageFeature((PageFeatureImpl)pageFeature);
        SortFeatureImpl sortFeature = new SortFeatureImpl(this.dp.getDefaultSortColumn(), this.dp.getDefaultSortOrder());
        for (Column<?, TitleRecord> sortableCol : this.dp.getSortableColumns()) {
            sortFeature.addSortableColumn(sortableCol);
        }
        this.dp.setSortFeature((SortFeatureImpl<Long, TitleRecord>)sortFeature);
        this.assetTable.addPageFeature((PageFeature)pageFeature);
        this.assetTable.addSortFeature((SortFeature)sortFeature);
        this.assetTable.registerWidgetOnActionContainer((Widget)this.actionListContainer);
        this.container.add(this.assetTable);
        this.assetTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                TargetedTitlesListPanel.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(Void result) {
                TargetedTitlesListPanel.this.assetTable.refresh();
            }
        });
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public Table<Long, TitleRecord> getAssetTable() {
        return this.assetTable;
    }

    public Widget getParentContainer() {
        return this.getParent();
    }

    public void reportFailure(Throwable caught) {
        this.messageArea.setErrorMessage(caught.getLocalizedMessage());
    }

    public void reportFailure(String message) {
        this.messageArea.setErrorMessage(message);
    }

    public void cleanup() {
        this.messageArea.reset();
    }

    public void refresh(String infoMessage) {
        if (this.assetTable != null) {
            this.assetTable.getPageFeature().setPageNumber(1);
            this.assetTable.showListView();
            this.assetTable.refresh();
        }
        this.rootContainer.setWidget((Widget)this.container);
        this.show(infoMessage);
        this.setWidgetForNoAction();
    }

    public void show(String infoMessage) {
        this.messageArea.setInfoMessage(infoMessage);
    }

    public boolean isSelectButtonVisible() {
        return this.selectButtonVisible;
    }

    public void setSelectButtonVisible(boolean selectButtonVisible) {
        this.selectButtonVisible = selectButtonVisible;
    }

    public IActionInput getInputToExecution() {
        return null;
    }

    public List<Long> getSeletedRecordIds() {
        List selectedIds = this.getAssetTable().getSelectedRecords();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (TitleRecord tr : selectedIds) {
            ids.add(tr.getKey());
        }
        return ids;
    }

    public void show(boolean readOnly) {
        this.goButton.setEnabled(readOnly);
        this.actionsListBox.setEnabled(readOnly);
        this.parameterListBox.setEnabled(readOnly);
        this.multiSelectParameterListBox.setEnabled(readOnly);
    }

    @Override
    public String getName() {
        return "TargetedTitles";
    }

    @Override
    public String getDisplayName() {
        return this.constants.targetedTitlesTabName();
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            if (this.uiSite != null) {
                History.newItem((String)Anchors.getAnchor(this.uiSite.getId(), this.uiSite.getParentId(), this.getName()), (boolean)false);
            }
            this.refreshTimer.scheduleRepeating(this.refreshPeriod);
            this.refreshView();
        } else {
            this.refreshTimer.cancel();
        }
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        boolean retVal = false;
        if (site != null) {
            this.setUiSite(site);
            UISiteType uiSiteType = this.uiSite.getType();
            if (UISiteType.DISTRIBUTION.equals((Object)uiSiteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)uiSiteType) || UISiteType.TRACKING.equals((Object)uiSiteType)) {
                retVal = true;
                this.clearQuickSearchData(uiSiteType);
            }
        }
        return retVal;
    }

    public void refreshView(UISite uiSite) {
        String infoMessage = null;
        this.refresh(infoMessage);
        this.actionListContainer.setVisible(false);
        if (uiSite != null) {
            UISiteType uiSiteType = uiSite.getType();
            if (UISiteType.LOGICAL.equals((Object)uiSiteType)) {
                this.showSuccessMessage("Target Titles View is not applicable for Logical Site : " + uiSite.getName());
            } else {
                this.showActions(uiSite);
            }
        } else {
            this.showErrorMessage("Could not get Site data.");
        }
    }

    private void showErrorMessage(String message) {
        this.messageArea.setErrorMessage(message);
    }

    private void showSuccessMessage(String message) {
        this.messageArea.setInfoMessage(message);
    }

    private void showActions(UISite uiSite) {
        if (uiSite != null) {
            this.parameterListBox.setVisible(false);
            this.actionsListBox.setVisible(false);
            this.goButton.setVisible(false);
            this.actionsListBox.clear();
            this.actionsListBox.addItem("", (Object)"");
            UISiteType uiSiteType = uiSite.getType();
            if (UISiteType.DISTRIBUTION.equals((Object)uiSiteType) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)uiSiteType)) {
                boolean isActive = uiSite.isActive();
                if (isActive && this.security.isUserInRole("Sites_Distribute")) {
                    this.actionsListBox.addItem("Distribute", (Object)ACTION_DISTRIBUTE);
                }
                if (this.security.isUserInRole("AssetManagement_Delete")) {
                    this.actionsListBox.addItem("Delete", (Object)ACTION_DELETE);
                }
                if (this.security.isUserInRole("WorkOrderManagement_Create")) {
                    this.actionsListBox.addItem("Run Template", (Object)ACTION_RUN_TEMPLATE);
                }
                this.actionsListBox.setVisible(true);
            } else if (UISiteType.TRACKING.equals((Object)uiSiteType)) {
                if (this.security.isUserInRole("AssetManagement_Delete")) {
                    this.actionsListBox.addItem("Delete", (Object)ACTION_DELETE);
                }
                this.actionsListBox.setVisible(true);
            }
            this.actionsListBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    String actionSelected = (String)TargetedTitlesListPanel.this.actionsListBox.getSelectedItem();
                    if (!actionSelected.trim().isEmpty()) {
                        TargetedTitlesListPanel.this.goButton.setEnabled(true);
                    } else {
                        TargetedTitlesListPanel.this.goButton.setEnabled(false);
                    }
                    if (TargetedTitlesListPanel.ACTION_RUN_TEMPLATE.equals(actionSelected)) {
                        TargetedTitlesListPanel.this.siteService.getTemplateNames((AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

                            public void onNeptuneFailure(Throwable caught) {
                                TargetedTitlesListPanel.this.showErrorMessage(caught.getMessage());
                            }

                            public void onNeptuneSuccess(List<String> result) {
                                TargetedTitlesListPanel.this.parameterListBox.clear();
                                for (String templateName : result) {
                                    TargetedTitlesListPanel.this.parameterListBox.addItem(templateName, (Object)templateName);
                                }
                            }
                        });
                        TargetedTitlesListPanel.this.parameterListBox.setVisible(true);
                    } else {
                        TargetedTitlesListPanel.this.parameterListBox.setVisible(false);
                    }
                }
            });
            this.goButton.setVisible(true);
            this.actionListContainer.setVisible(true);
            this.setWidgetForNoAction();
        }
    }

    public void onClick(ClickEvent event) {
        this.goButton.setEnabled(false);
        List<Long> selectedIds = this.getSeletedRecordIds();
        String action = (String)this.actionsListBox.getSelectedItem();
        String templateName = (String)this.parameterListBox.getSelectedItem();
        if (selectedIds != null && selectedIds.size() > 0) {
            this.executeAction(selectedIds, action, templateName);
        } else {
            this.showErrorMessage("Need selecting at least 1 Title Id to run an action.");
            this.goButton.setEnabled(true);
        }
    }

    public void executeAction(List<Long> selectedIds, String action, String templateName) {
        if (ACTION_DISTRIBUTE.equals(action)) {
            this.siteService.distributeImmediately(this.uiSite.getId(), selectedIds, (AsyncCallback<DistributeTitlesResponse>)new NeptuneAsyncCallback<DistributeTitlesResponse>(){

                public void onNeptuneFailure(Throwable caught) {
                    TargetedTitlesListPanel.this.showErrorMessage(caught.getMessage());
                }

                public void onNeptuneSuccess(DistributeTitlesResponse result) {
                    StringBuilder sb = new StringBuilder();
                    if (result.getDistributeTitleIds().isEmpty()) {
                        TargetedTitlesListPanel.this.showErrorMessage(result.getErrorMsg());
                    } else {
                        if (!result.getFailedIds().isEmpty()) {
                            sb.append("Scheduled distribution of selected titles: ");
                            for (Long successlocalId : result.getDistributeTitleIds()) {
                                sb.append(String.valueOf(successlocalId.toString()) + ", ");
                            }
                            sb.append("\nSkipped distribution of selected titles: ");
                            for (Long failedlocalId : result.getFailedIds()) {
                                sb.append(String.valueOf(failedlocalId.toString()) + ", ");
                            }
                            sb.append("\nReason: " + result.getErrorMsg());
                        } else if (result.getFailedIds().isEmpty()) {
                            sb.append("Scheduled distribution of selected titles.");
                        }
                        TargetedTitlesListPanel.this.refresh(sb.toString());
                    }
                }
            });
        } else if (ACTION_DELETE.equals(action)) {
            this.siteService.deleteLocalTitles(this.uiSite.getId(), selectedIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    TargetedTitlesListPanel.this.showErrorMessage(caught.getMessage());
                }

                public void onNeptuneSuccess(Void result) {
                    TargetedTitlesListPanel.this.show("Success deleting selected titles.");
                    Timer timer = new Timer(){

                        public void run() {
                            TargetedTitlesListPanel.this.refresh("Success deleting selected titles.");
                        }
                    };
                    timer.schedule(1000);
                }
            });
        } else if (ACTION_RUN_TEMPLATE.equals(action)) {
            this.siteService.runTemplate(this.uiSite.getId(), selectedIds, templateName, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    TargetedTitlesListPanel.this.showErrorMessage(caught.getMessage());
                }

                public void onNeptuneSuccess(Void result) {
                    TargetedTitlesListPanel.this.refresh("Scheduled work orders for selected titles.");
                }
            });
        }
    }

    private void setWidgetForNoAction() {
        this.actionsListBox.setSelectedItem((Object)"");
        this.parameterListBox.clear();
        this.parameterListBox.setVisible(false);
        this.goButton.setEnabled(false);
    }

    public boolean hasActions() {
        return this.actionsListBox.getItemCount() > 0;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void handleGetRecordsRequest() {
        this.showBusyIndicator();
    }

    public void handleGetRecordsSuccessResponse(List<TitleRecord> records) {
        this.hideBusyIndicator();
    }

    public void handleGetRecordsFailureResponse(Throwable caught) {
        this.hideBusyIndicator();
    }

    public UISite getUiSite() {
        return this.uiSite;
    }

    public void setUiSite(UISite uiSite) {
        this.uiSite = uiSite;
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                TargetedTitlesListPanel.this.updateMainPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
        this.refreshTimer.cancel();
        this.busyIndicator.hide();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    protected void updateMainPanelSize() {
        int offsetHeight = 250;
        this.rootContainer.setHeight(String.valueOf(Window.getClientHeight() - offsetHeight) + "px");
    }
}

