/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.TargetedTitleQuickSearchException;
import com.ericsson.cms.sites.ui.client.TargetedTitlesListPanel;
import com.ericsson.cms.sites.ui.client.TitleRecord;
import com.ericsson.cms.sites.ui.client.UiSortColumnType;
import com.ericsson.cms.sites.ui.client.UiTargetedTitlesRequest;
import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteTitleStatusData;
import com.ericsson.cms.sites.ui.client.entities.UISiteTitleStatusRecord;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitlePageHelper;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TargetedTitlesTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private static String TABLE_NAME = "targetedTitlesColumns";
    private NeptuneSecurity security;
    private static String SITE_STATUS = "status";
    private static String SITE_STATUS_UPDATE_TIME = "statusUpdateTime";
    private static String TITLE_ID = "id";
    private static String THUMBNAIL = "thumbnail";
    private static int LIC_LIMIT_EXCEEDED = 1;
    private static int INVALID_LICENSE = 2;
    private static int DEPENDENCY_TIMEOUT = 3;
    private static String DistributionStatus_FAILED = "FAILED";
    private TargetedTitlesListPanel view;
    private List<UiColumn> uiColumns;
    List<UiColumn> queryColumns;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    private SortOrder defaultSortOrder;
    private Column<?, TitleRecord> defaultSortColumn;
    private List<Column<?, TitleRecord>> sortableColumns = new ArrayList();
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<Long, TitleRecord> sortFeature;
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private ContentMessages contentMessage = (ContentMessages)GWT.create(ContentMessages.class);
    private IUISiteServiceAsync siteService = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private TitleClientBundle titleBundle = new TitleClientBundle();

    public TargetedTitlesTableDataProvider(TargetedTitlesListPanel view) {
        this.view = view;
        this.security = NeptuneApplication.getApplication().getSecurity();
    }

    public void init(final AsyncCallback<Void> callback) {
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(TABLE_NAME, (AsyncCallback)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                TargetedTitlesTableDataProvider.this.defaultSortOrder = SortOrder.valueOf((String)table.getDefaultSortingOrder());
                TargetedTitlesTableDataProvider.this.uiColumns = table.getColumns();
                if (TargetedTitlesTableDataProvider.this.uiColumns != null) {
                    for (UiColumn uiColumn : TargetedTitlesTableDataProvider.this.uiColumns) {
                        String colName = TableColumnNameHelper.getColumnName((String)uiColumn.getName(), (String)uiColumn.getSectionName());
                        String colDisplayName = uiColumn.getDisplayName();
                        ColumnBase<String, TitleRecord> column = new ColumnBase<String, TitleRecord>(colName, colDisplayName){

                            public View<String> getView(final TitleRecord record) {
                                if (this.getName().equalsIgnoreCase(TITLE_ID)) {
                                    if (TargetedTitlesTableDataProvider.this.security.isUserInRole("AssetManagement_View")) {
                                        return new TitleHyperLinkView(record.getTitleId());
                                    }
                                    LabelStringView view = new LabelStringView("");
                                    view.setStyleName("table-data-text");
                                    return view;
                                }
                                if (this.getName().equalsIgnoreCase(SITE_STATUS)) {
                                    View<String> iView = new View<String>(){

                                        public Widget getWidget() {
                                            return TargetedTitlesTableDataProvider.this.getImageWidget(record);
                                        }

                                        public String getStyleName() {
                                            return null;
                                        }

                                        public void release() {
                                        }
                                    };
                                    return iView;
                                }
                                if (this.getName().equalsIgnoreCase(THUMBNAIL)) {
                                    return new View<String>(){

                                        public Widget getWidget() {
                                            TitleThumbnailWidget widget = new TitleThumbnailWidget();
                                            widget.setInput(record.getTitleId(), null);
                                            return widget;
                                        }

                                        public String getStyleName() {
                                            return null;
                                        }

                                        public void release() {
                                        }
                                    };
                                }
                                LabelStringView view = new LabelStringView("");
                                List<TitleMetadata> titleMetadataList = record.getMetadata();
                                for (TitleMetadata titleMetadata : titleMetadataList) {
                                    String metadatColName = TableColumnNameHelper.getColumnName((String)titleMetadata.getName(), (String)titleMetadata.getAssetType());
                                    if (!this.getName().equalsIgnoreCase(metadatColName)) continue;
                                    view = new LabelStringView(titleMetadata.getValue());
                                }
                                return view;
                            }
                        };
                        column.setCellStyle(TargetedTitlesTableDataProvider.this.getColumnCellStyle(uiColumn));
                        if (column.getName().equals(SITE_STATUS) || column.getName().equals(THUMBNAIL)) {
                            column.setCellStyle("nwt-TableColumnPanel-dataCell-icon");
                        }
                        TargetedTitlesTableDataProvider.this.columns.add(column);
                        if (column.getName().equals(table.getDefaultSortColumnName())) {
                            TargetedTitlesTableDataProvider.this.defaultSortColumn = (Column)column;
                        }
                        if (!uiColumn.isSortable()) continue;
                        TargetedTitlesTableDataProvider.this.sortableColumns.add(column);
                    }
                }
                callback.onSuccess(null);
            }
        });
    }

    private String getColumnCellStyle(UiColumn column) {
        String style = "nwt-TableColumnPanel-dataCell-general";
        if (column.getDataType() != null) {
            switch (column.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    style = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    style = "nwt-TableColumnPanel-dataCell-numeric";
                    break;
                }
                case DATE: 
                case TIME: {
                    style = "nwt-TableColumnPanel-dataCell-date";
                }
            }
        }
        return style;
    }

    public Column<?, TitleRecord> getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public SortOrder getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    public List<Column<?, TitleRecord>> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public void setSortFeature(SortFeatureImpl<Long, TitleRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        UISite uiSite = this.view.getUiSite();
        if (uiSite != null) {
            this.view.handleGetRecordsRequest();
            this.view.cleanup();
            Integer siteId = uiSite.getId();
            UISiteType siteType = uiSite.getType();
            UiTargetedTitlesRequest uiTargetedTitlesRequest = new UiTargetedTitlesRequest();
            uiTargetedTitlesRequest.setSrchTxt(this.view.getTextFilter());
            uiTargetedTitlesRequest.setSiteTitleStatus(this.view.getStatusFilter());
            uiTargetedTitlesRequest.setColumns(this.getQueryColumns(this.uiColumns));
            uiTargetedTitlesRequest.setSiteId(siteId);
            uiTargetedTitlesRequest.setSiteType(siteType);
            final boolean exceedMaxRecord = this.checkPageInfo(uiTargetedTitlesRequest);
            String sortColumnName = this.sortFeature.getSortColumnName();
            String sortColumnAssetType = "";
            if (TableColumnNameHelper.isMetdataField((String)sortColumnName)) {
                String columnName = TableColumnNameHelper.getColumnName((String)this.sortFeature.getSortColumnName());
                String colSection = TableColumnNameHelper.getSectionName((String)this.sortFeature.getSortColumnName()).toUpperCase();
                sortColumnName = columnName;
                sortColumnAssetType = colSection;
            }
            uiTargetedTitlesRequest.setSortColumnName(sortColumnName);
            uiTargetedTitlesRequest.setSortColumnAssetType(sortColumnAssetType);
            UiSortColumnType uiSortColumnType = UiSortColumnType.METADATA;
            if (TITLE_ID.equalsIgnoreCase(sortColumnName)) {
                uiSortColumnType = UiSortColumnType.TITLE;
            }
            if (SITE_STATUS.equalsIgnoreCase(sortColumnName) || SITE_STATUS_UPDATE_TIME.equalsIgnoreCase(sortColumnName)) {
                uiSortColumnType = UiSortColumnType.SITE;
            }
            uiTargetedTitlesRequest.setSortColumnType(uiSortColumnType);
            uiTargetedTitlesRequest.setSortOrder(this.sortFeature.isAscending() ? SortOrder.ASCENDING.name() : SortOrder.DESCENDING.name());
            this.siteService.getSiteTitleStatusData(uiTargetedTitlesRequest, (AsyncCallback<UISiteTitleStatusData>)new NeptuneAsyncCallback<UISiteTitleStatusData>(){

                public void onNeptuneFailure(Throwable caught) {
                    if (caught instanceof TargetedTitleQuickSearchException) {
                        TargetedTitlesTableDataProvider.this.view.reportFailure(caught.getMessage());
                    } else {
                        callback.onFailure(caught);
                        TargetedTitlesTableDataProvider.this.pageFeature.setRecordCount(-1);
                    }
                    TargetedTitlesTableDataProvider.this.view.handleGetRecordsFailureResponse(caught);
                }

                public void onNeptuneSuccess(UISiteTitleStatusData data) {
                    ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                    List<UISiteTitleStatusRecord> ustsRecords = data.getUiSiteTitleStatusRecords();
                    for (UISiteTitleStatusRecord ustsRecord : ustsRecords) {
                        TitleRecord titleRecord = new TitleRecord();
                        titleRecord.setTitleId(ustsRecord.getTitleId());
                        titleRecord.setStatus(ustsRecord.getStatus());
                        titleRecord.setStatusDetail(ustsRecord.getStatusDetail());
                        titleRecord.setMetadata(ustsRecord.getMetadata());
                        titleRecord.setDistributionTitle(ustsRecord.isDistributionTitle());
                        records.add(titleRecord);
                    }
                    TargetedTitlesTableDataProvider.this.pageFeature.setRecordCount(data.getTotalCount());
                    callback.onSuccess(records);
                    TargetedTitlesTableDataProvider.this.view.handleGetRecordsSuccessResponse(records);
                    if (exceedMaxRecord) {
                        TargetedTitlesTableDataProvider.this.view.reportFailure(TargetedTitlesTableDataProvider.this.contentMessage.exceedMaxTitlesError());
                    }
                }
            });
        }
    }

    private boolean checkPageInfo(UiTargetedTitlesRequest uiTargetedTitlesRequest) {
        boolean exceedMaxPage = TitlePageHelper.enhancePageFeature((PageFeature)this.pageFeature);
        uiTargetedTitlesRequest.setStartIndex((this.pageFeature.getPageNumber() - 1) * this.pageFeature.getPageSize());
        uiTargetedTitlesRequest.setMaxRecordCount(this.pageFeature.getPageSize());
        return exceedMaxPage;
    }

    private List<UiColumn> getQueryColumns(List<UiColumn> uiColumns) {
        if (this.queryColumns != null) {
            return this.queryColumns;
        }
        this.queryColumns = new ArrayList<UiColumn>();
        int i = 0;
        while (i < uiColumns.size()) {
            if (!uiColumns.get(i).getName().equals(THUMBNAIL)) {
                this.queryColumns.add(uiColumns.get(i));
                if (uiColumns.get(i).getName().equals(SITE_STATUS)) {
                    uiColumns.get(i).setFieldType(UIFieldType.SITE);
                } else if (uiColumns.get(i).getName().equals(SITE_STATUS_UPDATE_TIME)) {
                    uiColumns.get(i).setFieldType(UIFieldType.SITE);
                    uiColumns.get(i).setDataType(UiColumn.DataType.DATE);
                }
            }
            ++i;
        }
        return this.queryColumns;
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private ImageWidget getImageWidget(TitleRecord record) {
        ImageWidget image = new ImageWidget();
        try {
            if (record.isDistributionTitle()) {
                String status = record.getStatus();
                this.titleBundle.updateDistributionStatusIcon((Image)image, status);
                if (status != null) {
                    if (status.equalsIgnoreCase(DistributionStatus_FAILED) && record.getStatusDetail() == LIC_LIMIT_EXCEEDED) {
                        image.setTitle(this.constants.distLimitExceeded());
                    } else if (status.equalsIgnoreCase(DistributionStatus_FAILED) && record.getStatusDetail() == INVALID_LICENSE) {
                        image.setTitle(this.constants.distInvalidLicense());
                    } else if (status.equalsIgnoreCase(DistributionStatus_FAILED) && record.getStatusDetail() == DEPENDENCY_TIMEOUT) {
                        image.setTitle(this.constants.dependencyTimeOut());
                    }
                }
            } else {
                this.titleBundle.updateTrackingStatusIcon((Image)image, record.getStatus());
            }
        }
        catch (Exception ex) {
            GWT.log((String)"", (Throwable)ex);
        }
        return image;
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    private class TitleHyperLinkView
    implements View<String> {
        long titleId;

        public TitleHyperLinkView(long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            HashMap<String, String> anchorTokens = new HashMap<String, String>();
            anchorTokens.put("Id", String.valueOf(this.titleId));
            anchorTokens.put("returnAnchor", History.getToken());
            String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
            Hyperlink hyperlink = new Hyperlink(String.valueOf(this.titleId), token);
            return hyperlink;
        }

        public String getStyleName() {
            return "table-data-link";
        }

        public void release() {
        }
    }
}

