/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TrackingSitesListPanel
extends Composite {
    private static final String TABLE_STYLE = "sites-trackingSitesList";
    private static final String HEADER_ROW_STYLE = "sites-trackingSitesList-header";
    private static final String DATA_ROW_STYLE = "sites-trackingSitesList-data";
    private BusyIndicator busyIndicator = new BusyIndicator(true);
    private VerticalContainer mainPanel = new VerticalContainer();
    private FlexTable table = new FlexTable();
    private List<CheckBoxWidget> rowCheckBoxes;
    private int distributionSiteId;
    private AsyncCallback<Void> callback;
    private Set<Integer> selectedIds = new HashSet<Integer>();
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public TrackingSitesListPanel(int distributionSiteId, AsyncCallback<Void> callback) {
        this.distributionSiteId = distributionSiteId;
        this.callback = callback;
        this.table.addStyleName(TABLE_STYLE);
        this.mainPanel.add((Widget)this.table);
        ButtonWidget addButton = new ButtonWidget(this.constants.buttonLabelAdd());
        addButton.removeStyleName("gwt-Button");
        addButton.addStyleName("ebBtn");
        addButton.addStyleName("addgreen_button_icon");
        addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TrackingSitesListPanel.this.addTrackingSites();
            }
        });
        this.mainPanel.add((Widget)addButton);
        this.load();
        this.initWidget((Widget)this.mainPanel);
    }

    private void load() {
        this.busyIndicator.center();
        this.service.getShareableTrackingSites(this.distributionSiteId, (AsyncCallback<List<UISite>>)new NeptuneAsyncCallback<List<UISite>>(){

            public void onNeptuneFailure(Throwable caught) {
                TrackingSitesListPanel.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(TrackingSitesListPanel.this.constants.loadingTrackingSitesFailed()) + " | " + (caught == null ? "" : caught.getLocalizedMessage())));
            }

            public void onNeptuneSuccess(List<UISite> trackingSites) {
                TrackingSitesListPanel.this.buildTable(trackingSites);
                TrackingSitesListPanel.this.busyIndicator.hide();
            }
        });
    }

    private void buildTable(List<UISite> trackingSites) {
        this.table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
        final CheckBoxWidget allCB = new CheckBoxWidget();
        allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (TrackingSitesListPanel.this.rowCheckBoxes != null) {
                    for (CheckBoxWidget cb : TrackingSitesListPanel.this.rowCheckBoxes) {
                        cb.setValue((Boolean)event.getValue(), true);
                    }
                }
            }
        });
        this.table.setWidget(0, 0, (Widget)allCB);
        this.table.setWidget(0, 1, (Widget)new LabelWidget(this.constants.fieldLabelName()));
        this.table.setWidget(0, 2, (Widget)new LabelWidget(this.constants.fieldLabelExternalId()));
        this.table.setWidget(0, 3, (Widget)new LabelWidget(this.constants.fieldLabelDescription()));
        this.rowCheckBoxes = new ArrayList<CheckBoxWidget>(trackingSites.size());
        int rowIndex = 1;
        for (final UISite ts : trackingSites) {
            this.table.getRowFormatter().addStyleName(rowIndex, DATA_ROW_STYLE);
            CheckBoxWidget cb = new CheckBoxWidget();
            cb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        TrackingSitesListPanel.this.selectedIds.add(ts.getId());
                    } else {
                        allCB.setValue(Boolean.valueOf(false), false);
                        TrackingSitesListPanel.this.selectedIds.remove(ts.getId());
                    }
                }
            });
            this.table.setWidget(rowIndex, 0, (Widget)cb);
            this.table.setWidget(rowIndex, 1, (Widget)new LabelWidget(ts.getName()));
            this.table.setWidget(rowIndex, 2, (Widget)new LabelWidget(ts.getExternalId()));
            this.table.setWidget(rowIndex, 3, (Widget)new LabelWidget(ts.getDescription()));
            this.rowCheckBoxes.add(cb);
            ++rowIndex;
        }
    }

    private void addTrackingSites() {
        if (this.selectedIds.isEmpty()) {
            return;
        }
        this.busyIndicator.center();
        this.service.associateTrackingSites(this.selectedIds, this.distributionSiteId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                TrackingSitesListPanel.this.busyIndicator.hide();
                Window.alert((String)(String.valueOf(TrackingSitesListPanel.this.constants.sharingTrackingSitesFailed()) + " | " + (caught == null ? "" : caught.getLocalizedMessage())));
                TrackingSitesListPanel.this.callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Void result) {
                TrackingSitesListPanel.this.busyIndicator.hide();
                TrackingSitesListPanel.this.callback.onSuccess(null);
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }
}

