/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.activity;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.activity.SitesActivitySearchPanel;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTable;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTables;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class SitesActivityResultsPanel
extends Composite {
    private static final String DIST_SITES_TAB_NAME = "Distribution Sites";
    private static final String TRACK_SITES_TAB_NAME = "Tracking Sites";
    private static final String TABLE_STYLE = "sitesActivity-resultsTable";
    private static final String HEADER_ROW_STYLE = "sitesActivity-resultsTable-header";
    private static final String HEADER_TEXT_STYLE = "sitesActivity-resultsTable-header-text";
    private static final String DATA_ROW_STYLE = "sitesActivity-resultsTable-data";
    private static final String SITE_NAME_STYLE = "sitesActivity-resultsTable-siteName";
    private VerticalContainer mainContainer;
    private MessageArea messageArea;
    private HeaderPanel header;
    private ResizableContainer resizableContainer;
    private VerticalContainer distTablesContainer;
    private VerticalContainer trackTablesContainer;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private boolean distSitesLoaded;
    private boolean trackSitesLoaded;

    public SitesActivityResultsPanel() {
        this.buildComponents();
        this.loadDistSitesData();
        this.initWidget((Widget)this.mainContainer);
    }

    private void buildComponents() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setWidth("100%");
        this.mainContainer.setSpacing(2);
        this.header = new HeaderPanel("Sites Activity Search Results");
        this.mainContainer.add((Widget)this.header);
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        this.mainContainer.add((Widget)this.messageArea);
        this.distTablesContainer = new VerticalContainer();
        this.distTablesContainer.setWidth("100%");
        this.distTablesContainer.setSpacing(2);
        this.resizableContainer = new ResizableContainer((Widget)this.distTablesContainer, DIST_SITES_TAB_NAME, null);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.messageArea);
        this.resizableContainer.setOffsetHeight(10);
        this.mainContainer.add((Widget)this.resizableContainer);
        this.resizableContainer.addButton(DIST_SITES_TAB_NAME, this.makeExportButton(UISiteType.DISTRIBUTION));
        this.resizableContainer.addButton(DIST_SITES_TAB_NAME, this.makeCancelButton());
        this.trackTablesContainer = new VerticalContainer();
        this.trackTablesContainer.setWidth("100%");
        this.resizableContainer.addTab((Widget)this.trackTablesContainer, TRACK_SITES_TAB_NAME);
        this.resizableContainer.addButton(TRACK_SITES_TAB_NAME, this.makeExportButton(UISiteType.TRACKING));
        this.resizableContainer.addButton(TRACK_SITES_TAB_NAME, this.makeCancelButton());
        this.resizableContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                switch ((Integer)event.getSelectedItem()) {
                    case 0: {
                        SitesActivityResultsPanel.this.loadDistSitesData();
                        break;
                    }
                    case 1: {
                        SitesActivityResultsPanel.this.loadTrackSitesData();
                    }
                }
            }
        });
        this.resizableContainer.setTabEnabled(TRACK_SITES_TAB_NAME, SitesActivitySearchPanel.searchForm.trackSiteEnabled);
    }

    private ButtonWidget makeCancelButton() {
        ButtonWidget cancelButton = new ButtonWidget("Cancel", new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)"Sites.Activity");
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        return cancelButton;
    }

    private ButtonWidget makeExportButton(final UISiteType siteType) {
        ButtonWidget exportButton = new ButtonWidget("Export", new ClickHandler(){

            public void onClick(ClickEvent event) {
                StringBuilder sb = new StringBuilder();
                sb.append("ExportSitesActivity?");
                this.append("siteType", siteType.name(), sb);
                sb.append("&");
                this.append("distSiteId", String.valueOf(SitesActivitySearchPanel.searchForm.distSiteId), sb);
                sb.append("&");
                this.append("trackSiteId", String.valueOf(SitesActivitySearchPanel.searchForm.trackSiteId), sb);
                sb.append("&");
                this.append("distStatus", SitesActivitySearchPanel.searchForm.distStatus.name(), sb);
                sb.append("&");
                this.append("trackStatus", SitesActivitySearchPanel.searchForm.trackStatus.name(), sb);
                sb.append("&");
                this.append("fromDate", SitesActivitySearchPanel.searchForm.fromDateStr, sb);
                sb.append("&");
                this.append("toDate", SitesActivitySearchPanel.searchForm.toDateStr, sb);
                Window.Location.replace((String)sb.toString());
            }

            private void append(String name, String value, StringBuilder sb) {
                sb.append(name).append("=").append(URL.encodeQueryString((String)value));
            }
        });
        exportButton.removeStyleName("gwt-Button");
        exportButton.addStyleName("ebBtn");
        exportButton.addStyleName("export_button_icon");
        return exportButton;
    }

    private void loadDistSitesData() {
        if (this.distSitesLoaded) {
            return;
        }
        this.messageArea.reset();
        this.busyIndicator.center();
        this.service.getDistSiteActivity(SitesActivitySearchPanel.searchForm.distSiteId, SitesActivitySearchPanel.searchForm.distStatus, SitesActivitySearchPanel.searchForm.fromDateStr, SitesActivitySearchPanel.searchForm.toDateStr, SitesActivitySearchPanel.searchForm.trackSiteId, (AsyncCallback<SiteActivityTables>)new NeptuneAsyncCallback<SiteActivityTables>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesActivityResultsPanel.this.messageArea.setErrorMessage("Unable to get distribution sites activity." + SitesActivityResultsPanel.this.getFailureMessageSuffix(caught));
                SitesActivityResultsPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(SiteActivityTables tables) {
                SitesActivityResultsPanel.this.renderTables(tables, SitesActivityResultsPanel.this.distTablesContainer);
                SitesActivityResultsPanel.this.distSitesLoaded = true;
                SitesActivityResultsPanel.this.busyIndicator.hide();
            }
        });
    }

    private void loadTrackSitesData() {
        if (this.trackSitesLoaded) {
            return;
        }
        this.messageArea.reset();
        this.busyIndicator.center();
        this.service.getTrackSiteActivity(SitesActivitySearchPanel.searchForm.trackSiteId, SitesActivitySearchPanel.searchForm.trackStatus, SitesActivitySearchPanel.searchForm.fromDateStr, SitesActivitySearchPanel.searchForm.toDateStr, SitesActivitySearchPanel.searchForm.distSiteId, (AsyncCallback<SiteActivityTables>)new NeptuneAsyncCallback<SiteActivityTables>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesActivityResultsPanel.this.messageArea.setErrorMessage("Unable to get tracking sites activity." + SitesActivityResultsPanel.this.getFailureMessageSuffix(caught));
                SitesActivityResultsPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(SiteActivityTables tables) {
                SitesActivityResultsPanel.this.renderTables(tables, SitesActivityResultsPanel.this.trackTablesContainer);
                SitesActivityResultsPanel.this.trackSitesLoaded = true;
                SitesActivityResultsPanel.this.busyIndicator.hide();
            }
        });
    }

    private void renderTables(SiteActivityTables tables, VerticalContainer container) {
        for (SiteActivityTable table : tables.getTables()) {
            HyperlinkWidget siteNameWidget = new HyperlinkWidget(table.getSiteName(), "Sites.View?id=" + table.getSiteId());
            siteNameWidget.addStyleName(SITE_NAME_STYLE);
            container.add((Widget)siteNameWidget);
            FlexTableContainer flexTable = new FlexTableContainer();
            flexTable.addStyleName(TABLE_STYLE);
            container.add((Widget)flexTable);
            int row = 0;
            int col = 0;
            flexTable.getRowFormatter().addStyleName(row, HEADER_ROW_STYLE);
            for (String string : tables.getHeaderRow()) {
                InlineLabelWidget headerColumnWidget = new InlineLabelWidget(string);
                headerColumnWidget.addStyleName(HEADER_TEXT_STYLE);
                flexTable.setWidget(row, col, (Widget)headerColumnWidget);
                flexTable.getCellFormatter().setAlignment(row, col, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
                ++col;
            }
            row = 1;
            for (List list : table.getDataRows()) {
                flexTable.getRowFormatter().addStyleName(row, DATA_ROW_STYLE);
                col = 0;
                for (SiteActivityTable.Column dataCol : list) {
                    flexTable.setWidget(row, col, dataCol.getWidget());
                    flexTable.getCellFormatter().setAlignment(row, col, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
                    ++col;
                }
                ++row;
            }
            SitesActivityResultsPanel.enableSort(flexTable.getElement());
        }
    }

    private String getFailureMessageSuffix(Throwable caught) {
        return " | " + this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "");
    }

    private static native void enableSort(Element var0);

    protected void onUnload() {
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }
}

