/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.activity;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.IServerTimeService;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.IServerTimeServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.ServerTime;
import java.util.List;

public class SitesActivitySearchPanel
extends Composite {
    private static final int DATE_BOX_LENGTH = 10;
    static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
    private VerticalContainer mainContainer;
    private MessageArea messageArea;
    private HeaderPanel header;
    private ResizableContainer resizableContainer;
    private FormContainer formContainer;
    private ListBoxWidget<UISite> distSiteWidget;
    private ListBoxWidget<UIDistributionStatus> distStatusWidget;
    private ListBoxWidget<UISite> trackSiteWidget;
    private ListBoxWidget<UITrackingStatus> trackStatusWidget;
    private DateBoxWidget fromDateBox;
    private DateBoxWidget toDateBox;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISiteServiceAsync service = (IUISiteServiceAsync)GWT.create(IUISiteService.class);
    private IServerTimeServiceAsync timeService = (IServerTimeServiceAsync)GWT.create(IServerTimeService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private ServerTime serverTime;
    static SearchForm searchForm;

    public SitesActivitySearchPanel() {
        this.buildComponents();
        this.loadData();
        this.initWidget((Widget)this.mainContainer);
    }

    public void buildComponents() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setWidth("100%");
        this.mainContainer.setSpacing(2);
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        this.header = new HeaderPanel("Sites Activity");
        this.formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.distSiteWidget = new ListBoxWidget();
        this.distSiteWidget.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SitesActivitySearchPanel.this.reloadTrackingSites();
            }
        });
        this.distStatusWidget = new ListBoxWidget();
        this.distStatusWidget.addItem("Distribution Failed", (Object)UIDistributionStatus.FAILED);
        this.distStatusWidget.addItem("Distributed", (Object)UIDistributionStatus.DISTRIBUTED);
        this.trackSiteWidget = new ListBoxWidget();
        this.trackStatusWidget = new ListBoxWidget();
        this.trackStatusWidget.addItem("Deployment Failed", (Object)UITrackingStatus.DEPLOYMENT_FAILED);
        this.trackStatusWidget.addItem("Not Deployed", (Object)UITrackingStatus.NOT_DEPLOYED);
        this.trackStatusWidget.addItem("Deployed", (Object)UITrackingStatus.DEPLOYED);
        this.formContainer.addRow("Distribution Site", this.distSiteWidget);
        this.formContainer.addRow("Distribution Status", this.distStatusWidget);
        this.formContainer.addRow("Tracking Site", this.trackSiteWidget);
        this.formContainer.addRow("Tracking Status", this.trackStatusWidget);
        this.formContainer.addRow("Date Range", this.getDateRangeWidget(), true);
        this.resizableContainer = new ResizableContainer((Widget)this.formContainer, "Search", null);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.messageArea);
        this.resizableContainer.setOffsetHeight(10);
        ButtonWidget searchButton = new ButtonWidget("Search");
        searchButton.removeStyleName("gwt-Button");
        searchButton.addStyleName("ebBtn");
        searchButton.addStyleName("ebBtn_color_darkBlue");
        searchButton.addStyleName("search_button_icon");
        searchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SitesActivitySearchPanel.this.messageArea.reset();
                if (SitesActivitySearchPanel.this.validate()) {
                    searchForm = new SearchForm();
                    SitesActivitySearchPanel.searchForm.distSiteId = SitesActivitySearchPanel.this.distSiteWidget.getSelectedItem() == null ? null : ((UISite)SitesActivitySearchPanel.this.distSiteWidget.getSelectedItem()).getId();
                    SitesActivitySearchPanel.searchForm.distStatus = (UIDistributionStatus)SitesActivitySearchPanel.this.distStatusWidget.getSelectedItem();
                    SitesActivitySearchPanel.searchForm.trackSiteEnabled = SitesActivitySearchPanel.this.trackSiteWidget.isEnabled();
                    SitesActivitySearchPanel.searchForm.trackSiteId = null;
                    SitesActivitySearchPanel.searchForm.trackStatus = null;
                    if (SitesActivitySearchPanel.searchForm.trackSiteEnabled) {
                        SitesActivitySearchPanel.searchForm.trackSiteId = SitesActivitySearchPanel.this.trackSiteWidget.getSelectedItem() == null ? null : ((UISite)SitesActivitySearchPanel.this.trackSiteWidget.getSelectedItem()).getId();
                        SitesActivitySearchPanel.searchForm.trackStatus = (UITrackingStatus)SitesActivitySearchPanel.this.trackStatusWidget.getSelectedItem();
                    }
                    SitesActivitySearchPanel.searchForm.fromDateStr = SitesActivitySearchPanel.this.fromDateBox.getTextBox().getText();
                    SitesActivitySearchPanel.searchForm.toDateStr = SitesActivitySearchPanel.this.toDateBox.getTextBox().getText();
                    History.newItem((String)"Sites.Activity.Results");
                }
            }
        });
        this.resizableContainer.addButton("Search", searchButton);
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.messageArea);
        this.mainContainer.add((Widget)this.resizableContainer);
    }

    private Widget getDateRangeWidget() {
        HorizontalContainer container = new HorizontalContainer();
        container.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.fromDateBox = new DateBoxWidget();
        this.fromDateBox.getTextBox().setVisibleLength(10);
        DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(DATE_FORMAT);
        this.fromDateBox.setFormat((DateBox.Format)fmt);
        container.add((Widget)this.fromDateBox);
        container.add((Widget)new HTMLWidget("&nbsp;&nbsp;"));
        container.add((Widget)new LabelWidget("to"));
        container.add((Widget)new HTMLWidget("&nbsp;&nbsp;"));
        this.toDateBox = new DateBoxWidget();
        this.toDateBox.getTextBox().setVisibleLength(10);
        this.toDateBox.setFormat((DateBox.Format)fmt);
        container.add((Widget)this.toDateBox);
        return container;
    }

    private void loadData() {
        this.busyIndicator.center();
        this.service.getAllSites((AsyncCallback<List<UISite>>)new NeptuneAsyncCallback<List<UISite>>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesActivitySearchPanel.this.messageArea.setErrorMessage("Unable to get list of sites." + SitesActivitySearchPanel.this.getFailureMessageSuffix(caught));
                SitesActivitySearchPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UISite> result) {
                SitesActivitySearchPanel.this.distSiteWidget.clear();
                SitesActivitySearchPanel.this.distSiteWidget.addItem("All", null);
                SitesActivitySearchPanel.this.trackSiteWidget.clear();
                SitesActivitySearchPanel.this.trackSiteWidget.addItem("All", null);
                for (UISite site : result) {
                    switch (site.getType()) {
                        case DISTRIBUTION: {
                            SitesActivitySearchPanel.this.distSiteWidget.addItem(site.getName(), (Object)site);
                            break;
                        }
                        case TRACKING: {
                            SitesActivitySearchPanel.this.trackSiteWidget.addItem(site.getName(), (Object)site);
                        }
                    }
                }
                SitesActivitySearchPanel.this.setDateRangeToServerDate();
            }
        });
    }

    private void setDateRangeToServerDate() {
        this.timeService.getCurrentTime((AsyncCallback)new NeptuneAsyncCallback<ServerTime>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesActivitySearchPanel.this.messageArea.setErrorMessage("Unable to get server time." + SitesActivitySearchPanel.this.getFailureMessageSuffix(caught));
                SitesActivitySearchPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(ServerTime result) {
                SitesActivitySearchPanel.this.serverTime = result;
                SitesActivitySearchPanel.this.fromDateBox.setValue(result.getDate());
                SitesActivitySearchPanel.this.toDateBox.setValue(result.getDate());
                SitesActivitySearchPanel.this.busyIndicator.hide();
            }
        });
    }

    private void reloadTrackingSites() {
        this.busyIndicator.center();
        Integer distSiteId = this.distSiteWidget.getSelectedItem() == null ? null : ((UISite)this.distSiteWidget.getSelectedItem()).getId();
        this.service.getAllTrackingSites(distSiteId, (AsyncCallback<List<UISite>>)new NeptuneAsyncCallback<List<UISite>>(){

            public void onNeptuneFailure(Throwable caught) {
                SitesActivitySearchPanel.this.messageArea.setErrorMessage("Unable to get list of tracking sites." + SitesActivitySearchPanel.this.getFailureMessageSuffix(caught));
                SitesActivitySearchPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UISite> result) {
                boolean emptyResult = result == null || result.isEmpty();
                SitesActivitySearchPanel.this.trackSiteWidget.setEnabled(!emptyResult);
                SitesActivitySearchPanel.this.trackStatusWidget.setEnabled(!emptyResult);
                SitesActivitySearchPanel.this.trackSiteWidget.clear();
                SitesActivitySearchPanel.this.trackSiteWidget.addItem("All", null);
                for (UISite site : result) {
                    SitesActivitySearchPanel.this.trackSiteWidget.addItem(site.getName(), (Object)site);
                }
                SitesActivitySearchPanel.this.busyIndicator.hide();
            }
        });
    }

    private boolean validate() {
        boolean error = false;
        StringBuilder html = new StringBuilder();
        html.append("<ul>");
        if (this.fromDateBox.getValue() == null || this.toDateBox.getValue() == null) {
            html.append("Provide Date Range values in YYYY-MM-DD format.");
            error = true;
        } else {
            if (this.fromDateBox.getValue().after(this.toDateBox.getValue())) {
                html.append("For Date Range field, the From Date should not be later than To Date.");
                error = true;
            }
            if (this.toDateBox.getValue().after(this.serverTime.getDate())) {
                html.append("Values of Date Range field should not be in the future.");
                error = true;
            }
        }
        html.append("</ul>");
        if (error) {
            this.messageArea.setErrorHTML(html.toString());
        }
        return !error;
    }

    private String getFailureMessageSuffix(Throwable caught) {
        return " | " + this.constants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : "");
    }

    protected void onUnload() {
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }

    static class SearchForm {
        Integer distSiteId;
        Integer trackSiteId;
        UIDistributionStatus distStatus;
        UITrackingStatus trackStatus;
        String fromDateStr;
        String toDateStr;
        boolean trackSiteEnabled;

        SearchForm() {
        }
    }
}

