/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.aggregatedview;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.aggregatedview.AggregatedItemRecord;
import com.ericsson.cms.sites.ui.client.aggregatedview.AggregatedViewTab;
import com.ericsson.cms.sites.ui.client.aggregatedview.IUIAgggregatedViewService;
import com.ericsson.cms.sites.ui.client.aggregatedview.IUIAgggregatedViewServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCount;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCountItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

class AggregatedItemDataProvider
implements DataProvider<Long, AggregatedItemRecord> {
    private List<UiColumn> uiColumns;
    private List<Column<?, AggregatedItemRecord>> columns;
    private AggregatedViewTab parent;
    private PageFeature parentPageFeature;
    private TitleClientBundle bundle = new TitleClientBundle();
    private IUIAgggregatedViewServiceAsync service = (IUIAgggregatedViewServiceAsync)GWT.create(IUIAgggregatedViewService.class);
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    private static String HREF_TITLE_ID = "Content.Search.Id=";
    private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";

    public AggregatedItemDataProvider(AggregatedViewTab parent) {
        this.parent = parent;
    }

    public void init(final AsyncCallback<Void> callback) {
        this.columns = new ArrayList();
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(UIStatusCountItem.METADATA_TABLE_NAME, (AsyncCallback)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                AggregatedItemDataProvider.this.uiColumns = table.getColumns();
                if (AggregatedItemDataProvider.this.uiColumns != null) {
                    int i = 0;
                    while (i < AggregatedItemDataProvider.this.uiColumns.size()) {
                        UiColumn uiColumn = (UiColumn)AggregatedItemDataProvider.this.uiColumns.get(i);
                        String colInternalName = TableColumnNameHelper.getColumnName((String)uiColumn.getName(), (String)uiColumn.getSectionName());
                        ColumnBase<String, AggregatedItemRecord> column = null;
                        column = i > 0 ? new ColumnBase<String, AggregatedItemRecord>(colInternalName, uiColumn.getDisplayName()){

                            public View<String> getView(AggregatedItemRecord record) {
                                UIStatusCountItem item = record.getAggregatedItem();
                                for (TitleMetadata t : item.getMetadata()) {
                                    String colInternalName = TableColumnNameHelper.getColumnName((String)t.getName(), (String)t.getAssetType());
                                    if (!colInternalName.equals(this.getName())) continue;
                                    LabelStringView view = new LabelStringView(t.getValue());
                                    return view;
                                }
                                return new LabelStringView("");
                            }
                        } : new ColumnBase<String, AggregatedItemRecord>(colInternalName, uiColumn.getDisplayName()){

                            public View<String> getView(final AggregatedItemRecord record) {
                                UIStatusCountItem item = record.getAggregatedItem();
                                for (final TitleMetadata t : item.getMetadata()) {
                                    String colInternalName = TableColumnNameHelper.getColumnName((String)t.getName(), (String)t.getAssetType());
                                    if (!colInternalName.equalsIgnoreCase(this.getName())) continue;
                                    return new View<String>(){

                                        public String getStyleName() {
                                            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{AggregatedItemDataProvider.CONTENT_VIEW_PERMISSION})) {
                                                return "table-data-link";
                                            }
                                            return "nwt-TableColumnPanel-dataCell-text";
                                        }

                                        public Widget getWidget() {
                                            String titleId = record.getAggregatedItem().getTitleId().toString();
                                            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{AggregatedItemDataProvider.CONTENT_VIEW_PERMISSION})) {
                                                UISite uiSite = AggregatedItemDataProvider.this.parent.getUiSite();
                                                String sourceAnchor = Anchors.getAnchor(uiSite.getId(), uiSite.getParentId(), AggregatedItemDataProvider.this.parent.getName());
                                                HyperlinkWidget anchor = new HyperlinkWidget(t.getValue(), String.valueOf(HREF_TITLE_ID) + titleId + "&" + sourceAnchor);
                                                anchor.setStyleName("table-data-link");
                                                return anchor;
                                            }
                                            return new LabelStringView(titleId).getWidget();
                                        }

                                        public void release() {
                                        }
                                    };
                                }
                                return new LabelStringView("");
                            }
                        };
                        column.setCellStyle(AggregatedItemDataProvider.this.getColumnCellStyle(uiColumn));
                        AggregatedItemDataProvider.this.columns.add(column);
                        ++i;
                    }
                }
                for (String statusName : UIStatusCountItem.getStatusNames()) {
                    String statusDisplayName = AggregatedItemDataProvider.this.bundle.getDistributionStatusName(statusName);
                    AggregatedItemDataProvider.this.columns.add(AggregatedItemDataProvider.this.prepareDistStatusCountColumn(statusName, statusDisplayName));
                }
                for (String statusName : UIStatusCountItem.getTrackStatusNames()) {
                    String statusDisplayName = AggregatedItemDataProvider.this.bundle.getTrackingStatusName(statusName);
                    AggregatedItemDataProvider.this.columns.add(AggregatedItemDataProvider.this.prepareTrackStatusCountColumn(statusName, statusDisplayName));
                }
                callback.onSuccess(null);
            }
        });
    }

    private String getColumnCellStyle(UiColumn column) {
        String style = "nwt-TableColumnPanel-dataCell-general";
        if (column.getDataType() != null) {
            switch (column.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    style = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    style = "nwt-TableColumnPanel-dataCell-numeric";
                    break;
                }
                case DATE: 
                case TIME: {
                    style = "nwt-TableColumnPanel-dataCell-date";
                }
            }
        }
        return style;
    }

    private Column<String, AggregatedItemRecord> prepareDistStatusCountColumn(final String colName, String displayName) {
        ColumnBase<String, AggregatedItemRecord> column = null;
        column = new ColumnBase<String, AggregatedItemRecord>(colName, displayName){

            public View<String> getView(final AggregatedItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        Integer count = record.getAggregatedItem().getStatusCount(colName);
                        if (count != null) {
                            LabelWidget label = new LabelWidget(count.toString());
                            if (count > 0) {
                                label.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        Long masterTitleId = record.getAggregatedItem().getTitleId();
                                        AggregatedItemDataProvider.this.parent.setAnchorParams(masterTitleId, true, colName);
                                        AggregatedItemDataProvider.this.parent.showLocalTitleSiteView();
                                    }
                                });
                            }
                            return label;
                        }
                        return null;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-numeric");
        return column;
    }

    private Column<String, AggregatedItemRecord> prepareTrackStatusCountColumn(final String colName, String displayName) {
        ColumnBase<String, AggregatedItemRecord> column = null;
        column = new ColumnBase<String, AggregatedItemRecord>(colName, displayName){

            public View<String> getView(final AggregatedItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        Integer count = record.getAggregatedItem().getTrackStatusCount(colName);
                        if (count != null) {
                            LabelWidget label = new LabelWidget(count.toString());
                            if (count > 0) {
                                label.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        Long masterTitleId = record.getAggregatedItem().getTitleId();
                                        AggregatedItemDataProvider.this.parent.setAnchorParams(masterTitleId, false, colName);
                                        AggregatedItemDataProvider.this.parent.showLocalTitleSiteView();
                                    }
                                });
                            }
                            return label;
                        }
                        return null;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-numeric");
        return column;
    }

    public List<Column<?, AggregatedItemRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<AggregatedItemRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<AggregatedItemRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.parent.showBusyIndicator();
        this.service.getPagedStatusCount(this.parent.getSiteId(), start, length, false, (AsyncCallback<UIStatusCount>)new NeptuneAsyncCallback<UIStatusCount>(){

            public void onNeptuneFailure(Throwable caught) {
                AggregatedItemDataProvider.this.getParentPageFeature().setRecordCount(-1);
                AggregatedItemDataProvider.this.parent.handleGetRecordsFailure(caught);
            }

            public void onNeptuneSuccess(UIStatusCount countItemList) {
                int recCount = countItemList.getTotalCount();
                AggregatedItemDataProvider.this.getParentPageFeature().setRecordCount(recCount);
                ArrayList<AggregatedItemRecord> records = new ArrayList<AggregatedItemRecord>();
                for (UIStatusCountItem countItem : countItemList.getItems()) {
                    records.add(new AggregatedItemRecord(countItem));
                }
                callback.onSuccess(records);
                AggregatedItemDataProvider.this.parent.handleGetRecordsSuccess(countItemList);
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }
}

