/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.aggregatedview;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.aggregatedview.AggregatedItemDataProvider;
import com.ericsson.cms.sites.ui.client.aggregatedview.AggregatedItemRecord;
import com.ericsson.cms.sites.ui.client.aggregatedview.TitleSiteListPanel;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCount;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.HashMap;
import java.util.Map;

public class AggregatedViewTab
extends ScrollContainer
implements ISiteTab {
    private static final int MAIN_PANEL_OFFSET_HEIGHT = 250;
    private VerticalContainer mainContainer;
    private VerticalContainer aggViewContainer;
    private LabelWidget blankLabel = new LabelWidget("");
    private PageFeature pageFeature;
    private AggregatedItemDataProvider dataProviderAggregatedCounts;
    private Table<Long, AggregatedItemRecord> tableAggregatedCounts;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private TitleSiteListPanel localTitleSitePanel;
    private MessageArea messageArea;
    private UISite site;
    private UIStatusCount statusCount = null;
    private String specificationName;
    private Timer refreshTimer;
    private int refreshPeriod;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-TitleListsPanel";
    private static final String AGGREGATED_VIEW_PANEL_REFRESH_KEY = "site.aggregatedview.refreshTime";
    private Map<String, String> anchorParams = null;
    private static final String TITLE_ANCHOR = "AggregatedView.titleId";
    private static final String DISTRIBUTION_ANCHOR = "AggregatedView.isDistribution";
    private static final String STATUS_ANCHOR = "AggregatedView.statusType";
    private int DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME = 60;
    private HandlerRegistration windowRegistration = null;

    public AggregatedViewTab(Map<String, String> info) {
        this.initWidgets(info.get("ContentComponent.Specification"));
        this.refreshPeriod = this.getRefreshPeriod(info);
        this.refreshTimer = new Timer(){

            public void run() {
                AggregatedViewTab.this.showView(AggregatedViewTab.this.site.getId());
            }
        };
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AggregatedViewTab.this.updateMainPanelSize();
            }
        });
    }

    private void initWidgets(String specificationName) {
        this.specificationName = specificationName;
        this.mainContainer = new VerticalContainer();
        this.aggViewContainer = new VerticalContainer();
        this.aggViewContainer.setSpacing(2);
        this.aggViewContainer.setStylePrimaryName(STYLE_NAME);
        this.init();
    }

    private void init() {
        this.dataProviderAggregatedCounts = new AggregatedItemDataProvider(this);
        this.dataProviderAggregatedCounts.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)("Failed to initialize Aggregated View Data Provider. Reason: " + (caught != null ? caught.getMessage() : "")));
            }

            public void onNeptuneSuccess(Void result) {
                AggregatedViewTab.this.tableAggregatedCounts = new Table((DataProvider)AggregatedViewTab.this.dataProviderAggregatedCounts);
                AggregatedViewTab.this.pageFeature = (PageFeature)new PageFeatureImpl();
                AggregatedViewTab.this.dataProviderAggregatedCounts.setParentPageFeature(AggregatedViewTab.this.pageFeature);
                AggregatedViewTab.this.tableAggregatedCounts.addPageFeature(AggregatedViewTab.this.pageFeature);
                AggregatedViewTab.this.aggViewContainer.add((Widget)AggregatedViewTab.this.tableAggregatedCounts);
                AggregatedViewTab.this.mainContainer.add((Widget)AggregatedViewTab.this.aggViewContainer);
                AggregatedViewTab.this.localTitleSitePanel = new TitleSiteListPanel(AggregatedViewTab.this, AggregatedViewTab.this.specificationName);
                AggregatedViewTab.this.localTitleSitePanel.setVisible(false);
                AggregatedViewTab.this.mainContainer.add((Widget)AggregatedViewTab.this.localTitleSitePanel);
            }
        });
    }

    private int getRefreshPeriod(Map<String, String> info) {
        String refreshPeriod = info.get(AGGREGATED_VIEW_PANEL_REFRESH_KEY);
        try {
            int refresh = Integer.parseInt(refreshPeriod.trim());
            if (refresh < this.DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME) {
                refresh = this.DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME;
            }
            return refresh * 1000;
        }
        catch (Exception exception) {
            return this.DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME * 1000;
        }
    }

    private void refreshAggregatedCountsTable() {
        if (!this.tableAggregatedCounts.isInitialized()) {
            this.tableAggregatedCounts.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    AggregatedViewTab.this.tableAggregatedCounts.refresh();
                }
            });
        } else {
            this.pageFeature.reset();
            this.tableAggregatedCounts.refresh();
        }
    }

    void handleGetRecordsSuccess(UIStatusCount statusCount) {
        this.statusCount = statusCount;
        this.busyIndicator.hide();
        if (statusCount.getItems().size() == 0) {
            String message = "No Status present for this site";
            this.tableAggregatedCounts.setVisible(false);
            this.messageArea.setInfoMessage(message);
            this.updateSizeForMessageArea();
        } else {
            this.messageArea.setInfoMessage(null);
            this.updateSizeForMessageArea();
            this.tableAggregatedCounts.setVisible(true);
        }
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    void handleGetRecordsFailure(Throwable caught) {
        this.tableAggregatedCounts.setVisible(false);
        this.busyIndicator.hide();
        this.messageArea.setErrorMessage(caught.getLocalizedMessage());
        this.updateSizeForMessageArea();
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    UIStatusCount getUIStatusCount() {
        return this.statusCount;
    }

    int getSiteId() {
        return this.site.getId();
    }

    public UISite getUiSite() {
        return this.site;
    }

    String getSpecificationName() {
        return this.specificationName;
    }

    void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void showView(int siteId) {
        String masterTitleId = null;
        String statusType = null;
        String isDist = null;
        if (this.anchorParams != null) {
            masterTitleId = this.anchorParams.get(TITLE_ANCHOR);
            isDist = this.anchorParams.get(DISTRIBUTION_ANCHOR);
            statusType = this.anchorParams.get(STATUS_ANCHOR);
        }
        if (masterTitleId != null && statusType != null && isDist != null) {
            this.showLocalTitleSiteView();
        } else {
            this.aggViewContainer.setVisible(true);
            this.localTitleSitePanel.setVisible(false);
            this.refreshAggregatedCountsTable();
        }
    }

    public void showLocalTitleSiteView() {
        this.aggViewContainer.setVisible(false);
        this.localTitleSitePanel.setVisible(true);
        this.localTitleSitePanel.showView(this.statusCount.getSiteId(), Long.parseLong(this.anchorParams.get(TITLE_ANCHOR)), Boolean.parseBoolean(this.anchorParams.get(DISTRIBUTION_ANCHOR)), this.anchorParams.get(STATUS_ANCHOR));
    }

    public void setAnchorParams(long masterTitleId, boolean isDistributionStatus, String statusType) {
        if (this.anchorParams == null) {
            this.anchorParams = new HashMap<String, String>();
        }
        this.anchorParams.put(TITLE_ANCHOR, String.valueOf(masterTitleId));
        this.anchorParams.put(DISTRIBUTION_ANCHOR, String.valueOf(isDistributionStatus));
        this.anchorParams.put(STATUS_ANCHOR, statusType);
    }

    public String getAnchorForDetailedView() {
        StringBuilder str = new StringBuilder(Anchors.getAnchor(this.site.getId(), this.site.getParentId(), this.getName()));
        str.append("&AggregatedView.titleId=" + this.anchorParams.get(TITLE_ANCHOR));
        str.append("&AggregatedView.isDistribution=" + this.anchorParams.get(DISTRIBUTION_ANCHOR));
        str.append("&AggregatedView.statusType=" + this.anchorParams.get(STATUS_ANCHOR));
        return str.toString();
    }

    @Override
    public String getName() {
        return "AggregatedView";
    }

    @Override
    public String getDisplayName() {
        return "Aggregated View";
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        this.site = site;
        this.anchorParams = params;
        return site != null && site.getType() != UISiteType.TRACKING;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.site == null) {
            return;
        }
        if (this.site.getType() == UISiteType.TRACKING) {
            this.aggViewContainer.setVisible(false);
            this.localTitleSitePanel.setVisible(false);
            this.setWidget((Widget)this.blankLabel);
            return;
        }
        if (selected) {
            History.newItem((String)Anchors.getAnchor(this.site.getId(), this.site.getParentId(), this.getName()), (boolean)false);
            this.refreshTimer.scheduleRepeating(this.refreshPeriod);
            this.showView(this.site.getId());
        } else {
            this.refreshTimer.cancel();
        }
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                AggregatedViewTab.this.updateMainPanelSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        this.refreshTimer.cancel();
        this.busyIndicator.hide();
        super.onUnload();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    protected void updateMainPanelSize() {
        int offsetHeight = 250;
        this.setHeight(String.valueOf(Window.getClientHeight() - offsetHeight) + "px");
    }

    private void updateSizeForMessageArea() {
        this.setHeight(String.valueOf(this.getOffsetHeight() - this.messageArea.getOffsetHeight()) + "px");
    }
}

