/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.aggregatedview;

import com.ericsson.cms.sites.ui.client.aggregatedview.IUIAgggregatedViewService;
import com.ericsson.cms.sites.ui.client.aggregatedview.IUIAgggregatedViewServiceAsync;
import com.ericsson.cms.sites.ui.client.aggregatedview.TitleSiteItemColumn;
import com.ericsson.cms.sites.ui.client.aggregatedview.TitleSiteItemRecord;
import com.ericsson.cms.sites.ui.client.aggregatedview.TitleSiteListPanel;
import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteList;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteListItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class TitleSiteListDataProvider
implements DataProvider<Long, TitleSiteItemRecord> {
    private TitleSiteListPanel view;
    private List<UiColumn> uiColumns;
    private List<Column<?, TitleSiteItemRecord>> columns = new ArrayList();
    private IUIAgggregatedViewServiceAsync service = (IUIAgggregatedViewServiceAsync)GWT.create(IUIAgggregatedViewService.class);
    private PageFeature parentPageFeature;
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    public static final String SITE_COLUMN_NAME = "siteName";
    private static String HREF_TITLE_ID = "Content.Search.Id=";
    private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";

    public TitleSiteListDataProvider(TitleSiteListPanel parent) {
        this.view = parent;
    }

    public void init(final AsyncCallback<Void> callback) {
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(UITitleSiteListItem.METADATA_TABLE_NAME, (AsyncCallback)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                String colName = TitleSiteListDataProvider.TITLE_ID_COLUMN_NAME;
                String displayName = "Title ID";
                TitleSiteListDataProvider.this.columns.add(TitleSiteListDataProvider.this.prepareTitleIdColumn(colName, displayName));
                TitleSiteListDataProvider.this.uiColumns = table.getColumns();
                if (TitleSiteListDataProvider.this.uiColumns != null) {
                    for (UiColumn uiColumn : TitleSiteListDataProvider.this.uiColumns) {
                        String colInternalName = TableColumnNameHelper.getColumnName((String)uiColumn.getName(), (String)uiColumn.getSectionName());
                        ColumnBase<String, TitleSiteItemRecord> column = new ColumnBase<String, TitleSiteItemRecord>(colInternalName, uiColumn.getDisplayName()){

                            public View<String> getView(TitleSiteItemRecord record) {
                                UITitleSiteListItem item = record.getTitleSiteItem();
                                for (TitleMetadata t : item.getMetadata()) {
                                    String colInternalName = TableColumnNameHelper.getColumnName((String)t.getName(), (String)t.getAssetType());
                                    if (!colInternalName.equalsIgnoreCase(this.getName())) continue;
                                    LabelStringView view = new LabelStringView(t.getValue());
                                    return view;
                                }
                                return new LabelStringView("");
                            }
                        };
                        column.setCellStyle(TitleSiteListDataProvider.this.getColumnCellStyle(uiColumn));
                        TitleSiteListDataProvider.this.columns.add(column);
                    }
                }
                TitleSiteItemColumn column = null;
                displayName = "Site";
                column = new TitleSiteItemColumn(TitleSiteListDataProvider.SITE_COLUMN_NAME, displayName){

                    @Override
                    protected String getColumnText(TitleSiteItemRecord record) {
                        return record.getTitleSiteItem().getSiteName();
                    }
                };
                column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
                TitleSiteListDataProvider.this.columns.add(column);
                callback.onSuccess(null);
            }
        });
    }

    private Column<String, TitleSiteItemRecord> prepareTitleIdColumn(String colName, String displayName) {
        ColumnBase<String, TitleSiteItemRecord> column = null;
        column = new ColumnBase<String, TitleSiteItemRecord>(colName, displayName){

            public View<String> getView(final TitleSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{TitleSiteListDataProvider.CONTENT_VIEW_PERMISSION})) {
                            return "table-data-link";
                        }
                        return "nwt-TableColumnPanel-dataCell-text";
                    }

                    public Widget getWidget() {
                        String titleId = record.getTitleSiteItem().getLocalTitleId().toString();
                        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{TitleSiteListDataProvider.CONTENT_VIEW_PERMISSION})) {
                            String sourceAnchor = TitleSiteListDataProvider.this.view.getParent().getAnchorForDetailedView();
                            HyperlinkWidget anchor = new HyperlinkWidget(titleId, String.valueOf(HREF_TITLE_ID) + titleId + "&" + sourceAnchor);
                            anchor.setStyleName("table-data-link");
                            return anchor;
                        }
                        return new LabelStringView(titleId).getWidget();
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private String getColumnCellStyle(UiColumn column) {
        String style = "nwt-TableColumnPanel-dataCell-general";
        if (column.getDataType() != null) {
            switch (column.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    style = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    style = "nwt-TableColumnPanel-dataCell-numeric";
                    break;
                }
                case DATE: 
                case TIME: {
                    style = "nwt-TableColumnPanel-dataCell-date";
                }
            }
        }
        return style;
    }

    public List<Column<?, TitleSiteItemRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<TitleSiteItemRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<TitleSiteItemRecord>> callback) {
        final int length = this.getParentPageFeature().getPageSize();
        final int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.view.showBusyIndicator();
        this.service.getLocalTitleSiteList(this.view.getSiteId(), this.view.getMasterTitleId(), this.view.isDistributionStatus(), this.view.getStatusType(), (AsyncCallback<UITitleSiteList>)new NeptuneAsyncCallback<UITitleSiteList>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleSiteListDataProvider.this.getParentPageFeature().setRecordCount(-1);
                TitleSiteListDataProvider.this.view.handleGetRecordsFailure(caught);
            }

            public void onNeptuneSuccess(UITitleSiteList titleSiteList) {
                int recCount = titleSiteList.getItemCount();
                TitleSiteListDataProvider.this.getParentPageFeature().setRecordCount(recCount);
                ArrayList<TitleSiteItemRecord> records = new ArrayList<TitleSiteItemRecord>();
                for (UITitleSiteListItem titleSiteItem : titleSiteList.getPagedItems(start, length)) {
                    records.add(new TitleSiteItemRecord(titleSiteItem));
                }
                callback.onSuccess(records);
                TitleSiteListDataProvider.this.view.handleGetRecordsSuccess(titleSiteList);
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }
}

