/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.aggregatedview;

import com.ericsson.cms.sites.ui.client.aggregatedview.AggregatedViewTab;
import com.ericsson.cms.sites.ui.client.aggregatedview.TitleSiteItemRecord;
import com.ericsson.cms.sites.ui.client.aggregatedview.TitleSiteListDataProvider;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteList;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleSiteListPanel
extends SimpleContainer {
    private UITitleSiteList titleSiteList = null;
    private AggregatedViewTab parent;
    private VerticalContainer mainContainer;
    private LabelWidget errorMsgLabel;
    private LabelWidget infoMsgLabel;
    private TitleSiteListDataProvider dataProviderTitleSiteList;
    private Table<Long, TitleSiteItemRecord> tableTitleSiteList;
    private BusyIndicator busyIndicator = new BusyIndicator();
    LabelWidget blankLabel = new LabelWidget("");
    private String specificationName;
    private int siteId;
    private long masterTitleId;
    private boolean isDistributionStatus;
    private String statusType;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-TitleListsPanel";

    public TitleSiteListPanel(AggregatedViewTab parent, String specificationName) {
        this.parent = parent;
        this.specificationName = specificationName;
        this.initWidgets();
    }

    public UITitleSiteList getTitleSiteList() {
        return this.titleSiteList;
    }

    public AggregatedViewTab getParent() {
        return this.parent;
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.infoMsgLabel = new LabelWidget();
        this.infoMsgLabel.setVisible(false);
        this.errorMsgLabel = new LabelWidget();
        this.errorMsgLabel.setVisible(false);
        this.mainContainer.add((Widget)this.infoMsgLabel);
        this.mainContainer.add((Widget)this.errorMsgLabel);
        this.initDataProvider("");
    }

    private void initDataProvider(String infoMessage) {
        this.dataProviderTitleSiteList = new TitleSiteListDataProvider(this);
        this.dataProviderTitleSiteList.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)("Failed to initialize Title Sites Data Provider. Reason: " + (caught != null ? caught.getMessage() : "")));
            }

            public void onNeptuneSuccess(Void result) {
                TitleSiteListPanel.this.initTable();
            }
        });
    }

    private void initTable() {
        this.tableTitleSiteList = new Table((DataProvider)this.dataProviderTitleSiteList);
        PageFeatureImpl pageFeature = new PageFeatureImpl();
        this.dataProviderTitleSiteList.setParentPageFeature((PageFeature)pageFeature);
        this.tableTitleSiteList.addPageFeature((PageFeature)pageFeature);
        this.mainContainer.add(this.tableTitleSiteList);
    }

    private void refreshTable() {
        if (!this.tableTitleSiteList.isInitialized()) {
            this.tableTitleSiteList.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    TitleSiteListPanel.this.tableTitleSiteList.refresh();
                }
            });
        } else {
            this.tableTitleSiteList.refresh();
        }
    }

    public void handleGetRecordsSuccess(UITitleSiteList titleSiteList) {
        this.busyIndicator.hide();
        this.titleSiteList = titleSiteList;
        this.errorMsgLabel.setVisible(false);
        if (titleSiteList.getItems().size() == 0) {
            String message = "No titles present for this status";
            this.tableTitleSiteList.setVisible(false);
            this.infoMsgLabel.setText(message);
            this.infoMsgLabel.setVisible(true);
        } else {
            this.infoMsgLabel.setVisible(false);
            this.tableTitleSiteList.setVisible(true);
        }
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    public void handleGetRecordsFailure(Throwable caught) {
        this.busyIndicator.hide();
        this.tableTitleSiteList.setVisible(false);
        this.infoMsgLabel.setVisible(false);
        this.errorMsgLabel.setText(caught.getMessage());
        this.errorMsgLabel.setVisible(false);
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    public void showView(int siteId, long masterTitleId, boolean isDistributionStatus, String statusType) {
        this.siteId = siteId;
        this.masterTitleId = masterTitleId;
        this.isDistributionStatus = isDistributionStatus;
        this.statusType = statusType;
        this.setWidget((Widget)this.blankLabel);
        this.refreshTable();
    }

    void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public long getMasterTitleId() {
        return this.masterTitleId;
    }

    public boolean isDistributionStatus() {
        return this.isDistributionStatus;
    }

    public String getStatusType() {
        return this.statusType;
    }
}

