/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.bundle;

import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;

public class SiteClientBundle {
    private ISiteClientBundle titleBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);

    public void updateSiteIcon(Image icon, UISiteTreeNode siteNode, boolean isLocalError) {
        boolean isError = isLocalError ? siteNode.isError() : siteNode.isError() | siteNode.isDescendantHasError();
        switch (siteNode.getType()) {
            case LOGICAL: {
                this.updateLogicalSiteIcon(icon, siteNode.isActive(), isError);
                break;
            }
            case DISTRIBUTION: {
                this.updateDistributionSiteIcon(icon, siteNode.isActive(), isError);
                break;
            }
            case MEDIAPATH_DISTRIBUTION: {
                this.updateMediaPathDistributionSiteIcon(icon, siteNode.isActive(), isError);
                break;
            }
            case TRACKING: {
                this.updateTrackingSiteIcon(icon, siteNode.isShared(), siteNode.isActive(), isError);
            }
        }
    }

    public void updateTrackingSiteIcon(Image icon, boolean isShared, boolean isActive, boolean isError) {
        if (isShared) {
            if (isError) {
                this.updateIcon(icon, "sharedTrackingSiteError");
            } else if (!isActive) {
                this.updateIcon(icon, "sharedTrackingSiteDisabled");
            } else {
                this.updateIcon(icon, "sharedTrackingSite");
            }
        } else if (isError) {
            this.updateIcon(icon, "trackingSiteError");
        } else if (!isActive) {
            this.updateIcon(icon, "trackingSiteDisabled");
        } else {
            this.updateIcon(icon, "trackingSite");
        }
    }

    public void updateDistributionSiteIcon(Image icon, boolean isActive, boolean isError) {
        if (isError) {
            this.updateIcon(icon, "distributionSiteError");
        } else if (!isActive) {
            this.updateIcon(icon, "distributionSiteDisabled");
        } else {
            this.updateIcon(icon, "distributionSite");
        }
    }

    public void updateMediaPathDistributionSiteIcon(Image icon, boolean isActive, boolean isError) {
        if (isError) {
            this.updateIcon(icon, "mediaPathDistributionSiteError");
        } else if (!isActive) {
            this.updateIcon(icon, "mediaPathDistributionSiteDisabled");
        } else {
            this.updateIcon(icon, "mediaPathDistributionSite");
        }
    }

    public void updateLogicalSiteIcon(Image icon, boolean isActive, boolean isError) {
        if (isError) {
            this.updateIcon(icon, "logicalSiteError");
        } else if (!isActive) {
            this.updateIcon(icon, "logicalSiteDisabled");
        } else {
            this.updateIcon(icon, "logicalSite");
        }
    }

    public void updateIcon(Image icon, String methodName) {
        ImageResource resource = (ImageResource)this.titleBundle.getResource(methodName);
        String title = this.constants.getString(methodName);
        icon.setResource(resource);
        icon.setTitle(title);
    }
}

