/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.entities;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import java.util.ArrayList;
import java.util.List;

public class SiteActivityTable
implements IsSerializable {
    private int siteId;
    private String siteName;
    private List<List<Column>> dataRows = new ArrayList<List<Column>>();

    public SiteActivityTable() {
    }

    public SiteActivityTable(int siteId, String siteName) {
        this.siteId = siteId;
        this.siteName = siteName;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public List<List<Column>> getDataRows() {
        return this.dataRows;
    }

    public void addDataRow(List<Column> dataRow) {
        this.dataRows.add(dataRow);
    }

    public static abstract class Column
    implements IsSerializable {
        public abstract Widget getWidget();

        public abstract String toString();
    }

    public static class DistTitleStatusColumn
    extends SiteTitleStatusColumn {
        private UIDistributionStatus status;

        public DistTitleStatusColumn() {
        }

        public DistTitleStatusColumn(UIDistributionStatus status) {
            this.status = status;
        }

        @Override
        public Widget getWidget() {
            ImageWidget image = new ImageWidget();
            new TitleClientBundle().updateDistributionStatusIcon((Image)image, this.status.name());
            return image;
        }

        @Override
        public String toString() {
            return this.status.toString();
        }
    }

    public static class HyperlinkColumn
    extends TextColumn {
        private String url;

        public HyperlinkColumn() {
        }

        public HyperlinkColumn(String text, String url) {
            super(text);
            this.url = url;
        }

        @Override
        public Widget getWidget() {
            HyperlinkWidget widget = new HyperlinkWidget(this.text, this.url);
            widget.addStyleName("table-data-link");
            return widget;
        }
    }

    public static abstract class SiteTitleStatusColumn
    extends Column {
    }

    public static class TextColumn
    extends Column {
        protected String text;

        public TextColumn() {
        }

        public TextColumn(Object obj) {
            this.text = String.valueOf(obj);
        }

        public TextColumn(String text) {
            this.text = text;
        }

        @Override
        public Widget getWidget() {
            LabelWidget widget = new LabelWidget(this.text);
            widget.addStyleName("table-data-text");
            return widget;
        }

        @Override
        public String toString() {
            return this.text == null ? "" : this.text;
        }
    }

    public static class TitleThumbnailColumn
    extends Column {
        private long titleId;

        public TitleThumbnailColumn() {
        }

        public TitleThumbnailColumn(long titleId) {
            this.titleId = titleId;
        }

        @Override
        public Widget getWidget() {
            TitleThumbnailWidget widget = new TitleThumbnailWidget();
            widget.setInput(Long.valueOf(this.titleId), null);
            return widget;
        }

        @Override
        public String toString() {
            return String.valueOf(this.titleId);
        }
    }

    public static class TrackTitleStatusColumn
    extends SiteTitleStatusColumn {
        private UITrackingStatus status;

        public TrackTitleStatusColumn() {
        }

        public TrackTitleStatusColumn(UITrackingStatus status) {
            this.status = status;
        }

        @Override
        public Widget getWidget() {
            ImageWidget image = new ImageWidget();
            new TitleClientBundle().updateTrackingStatusIcon((Image)image, this.status.name());
            return image;
        }

        @Override
        public String toString() {
            return this.status.toString();
        }
    }
}

