/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.mso;

import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.mso.MsoCreatePanel;
import com.ericsson.cms.sites.ui.client.mso.MsoListAnchorChangeListener;
import com.ericsson.cms.sites.ui.client.mso.model.UiMso;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewService;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MSOListPanel
extends Composite {
    private FlexTableContainer msoTable;
    private IMsoViewServiceAsync viewService;
    private SimplePanel rootPanel;
    private List<UiMso> msoList;
    private UiMso mso;
    private String headerStyle = "mso-t-header";
    private String bodyStyle = "sites.mso.t-body";
    private String listTab = "MSO List";
    private Set<CheckBox> checkBoxSet;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-TitleListsPanel";
    private boolean msoUsedinRules = false;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private ResizableContainer resizableContainer;
    private MessageArea messageArea;
    private HeaderPanel header;

    public MSOListPanel() {
        this.init();
    }

    private void init() {
        this.rootPanel = new SimplePanel();
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        this.header = new HeaderPanel("MSO Administration");
        this.buildComponents();
        this.initWidget((Widget)this.rootPanel);
        this.header.getLabel().setStyleName("mso-header-style");
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void cleanup() {
        this.messageArea.reset();
        this.mainContainer.clear();
    }

    public void create() {
        MsoCreatePanel createPanel = new MsoCreatePanel(this, false, new UiMso(), this.msoList);
        this.mainContainer.add((Widget)createPanel);
    }

    public void update(UiMso mso) {
        MsoCreatePanel updatePanel = new MsoCreatePanel(this, true, mso, this.msoList);
        this.mainContainer.add((Widget)updatePanel);
    }

    public void buildComponents() {
        this.checkBoxSet = new HashSet<CheckBox>();
        this.msoTable = new FlexTableContainer();
        this.msoTable.addStyleName("mso-list-table");
        this.msoTable.setWidth("100%");
        this.buildTableHeader(this.msoTable);
        this.mainContainer = new VerticalContainer();
        this.anchorChangeListener = new MsoListAnchorChangeListener(this);
        this.mainContainer.setSpacing(2);
        this.mainContainer.addStyleName(STYLE_NAME);
        this.setResizableContainer(new ResizableContainer((Widget)this.msoTable, this.listTab, null));
        this.getResizableContainer().addHeightOffsettingWidget((Widget)this.header);
        this.getResizableContainer().addHeightOffsettingWidget((Widget)this.messageArea);
        this.getResizableContainer().setOffsetHeight(10);
        this.getResizableContainer().getTabContainer().getTabBar().setVisible(false);
        this.addButtons();
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.messageArea);
        this.mainContainer.add((Widget)this.getResizableContainer());
        this.viewService = (IMsoViewServiceAsync)GWT.create(IMsoViewService.class);
        this.viewService.getAllMsos((AsyncCallback<List<UiMso>>)new NeptuneAsyncCallback<List<UiMso>>(){

            public void onNeptuneFailure(Throwable caught) {
                MSOListPanel.this.messageArea.setErrorMessage("Error retrieving mso records: " + caught.getMessage());
            }

            public void onNeptuneSuccess(List<UiMso> result) {
                MSOListPanel.this.setMsoList(result);
                MSOListPanel.this.buildView(result);
            }
        });
        this.rootPanel.setWidget((Widget)this.mainContainer);
    }

    public void refresh(String infoMessage) {
        this.rootPanel.setWidget(null);
        this.mainContainer.clear();
        if (this.messageArea != null) {
            this.messageArea.reset();
        }
        this.buildComponents();
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public List<UiMso> getMsoList() {
        return this.msoList;
    }

    public void setMsoList(List<UiMso> msoList) {
        this.msoList = msoList;
    }

    private void buildView(List<UiMso> result) {
        if (result != null) {
            int row = 1;
            for (UiMso mso : result) {
                this.setTableRow(this.msoTable, row, mso);
                ++row;
            }
        }
    }

    private void setTableRow(FlexTableContainer msoTable, int row, final UiMso mso) {
        CheckBox checkBox = new CheckBox();
        checkBox.setFormValue("" + mso.getKey());
        this.checkBoxSet.add(checkBox);
        msoTable.setWidget(row, 0, (Widget)checkBox);
        Anchor nameLink = new Anchor(mso.getName());
        msoTable.setWidget(row, 1, (Widget)nameLink);
        nameLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)("Sites.MSO.Edit&msoId=" + mso.getKey().toString()), (boolean)false);
                MSOListPanel.this.anchorChanged("Sites.MSO.Edit&msoId=" + mso.getKey().toString());
            }
        });
        msoTable.setWidget(row, 2, (Widget)new Label(mso.getDescription()));
        List<UISite> siteList = mso.getSiteList();
        String sites = "";
        if (siteList != null) {
            for (UISite site : siteList) {
                sites = siteList.indexOf(site) == siteList.size() - 1 ? String.valueOf(sites) + site.getName() + " " : String.valueOf(sites) + site.getName() + ", ";
            }
        }
        msoTable.setWidget(row, 3, (Widget)new Label(sites));
        msoTable.getRowFormatter().setStyleName(row, "mso-t-body");
        msoTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_CENTER);
    }

    private void buildTableHeader(FlexTableContainer msoTable) {
        final CheckBox checkAll = new CheckBox();
        checkAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean selected = checkAll.getValue();
                for (CheckBox cb : MSOListPanel.this.checkBoxSet) {
                    cb.setValue(Boolean.valueOf(selected));
                }
            }
        });
        msoTable.setWidget(0, 0, (Widget)checkAll);
        msoTable.setWidget(0, 1, (Widget)new LabelWidget("Name"));
        msoTable.setWidget(0, 2, (Widget)new LabelWidget("Description"));
        msoTable.setWidget(0, 3, (Widget)new LabelWidget("Sites"));
        msoTable.getRowFormatter().addStyleName(0, this.headerStyle);
        int i = 0;
        while (i <= 3) {
            msoTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell");
            msoTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell-header");
            Widget widget = msoTable.getWidget(0, i);
            if (widget instanceof LabelWidget) {
                widget.addStyleName("content-AssetContentTable-header-text");
            }
            ++i;
        }
        msoTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row");
        msoTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row-header");
    }

    private void addButtons() {
        ButtonWidget createButton = new ButtonWidget("Create");
        createButton.removeStyleName("gwt-Button");
        createButton.addStyleName("ebBtn");
        createButton.addStyleName("ebBtn_color_green");
        createButton.addStyleName("create_button_icon");
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"})) {
            createButton.setVisible(false);
        }
        createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)"Sites.MSO.New", (boolean)false);
                MSOListPanel.this.anchorChanged("Sites.MSO.New");
            }
        });
        ButtonWidget deleteButton = new ButtonWidget("Delete");
        deleteButton.removeStyleName("gwt-Button");
        deleteButton.addStyleName("ebBtn");
        deleteButton.addStyleName("delete_button_icon");
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"})) {
            deleteButton.setVisible(false);
        }
        deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final List idsToDelete = MSOListPanel.this.getIdsToDelete();
                if (MSOListPanel.this.messageArea != null) {
                    MSOListPanel.this.messageArea.reset();
                }
                if (idsToDelete.isEmpty()) {
                    MSOListPanel.this.messageArea.setInfoMessage("No MSO is selected to delete.");
                    MSOListPanel.this.getResizableContainer().updateSize();
                    return;
                }
                if (!idsToDelete.isEmpty()) {
                    MSOListPanel.this.viewService.getMsoPresentInRules(idsToDelete, (AsyncCallback<List<UiMso>>)new NeptuneAsyncCallback<List<UiMso>>(){

                        public void onNeptuneFailure(Throwable caught) {
                        }

                        public void onNeptuneSuccess(List<UiMso> result) {
                            if (result != null && !result.isEmpty()) {
                                if (Window.confirm((String)"MSOs you are trying to delete are used in Rules. Are you sure you want to delete selected MSOs?")) {
                                    MSOListPanel.this.deleteMSOs(idsToDelete);
                                }
                            } else if (Window.confirm((String)"Are you sure you want to delete selected MSOs?")) {
                                MSOListPanel.this.deleteMSOs(idsToDelete);
                            }
                        }
                    });
                }
            }
        });
        this.getResizableContainer().addButton(this.listTab, createButton);
        this.getResizableContainer().addButton(this.listTab, deleteButton);
    }

    private List<Integer> getIdsToDelete() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (CheckBox checkBox : this.checkBoxSet) {
            if (!checkBox.getValue().booleanValue()) continue;
            Integer id = Integer.parseInt(checkBox.getFormValue());
            ids.add(id);
        }
        return ids;
    }

    private void isUsedinRules(List<Integer> idsToDelete) {
        this.messageArea.reset();
        this.viewService.getMsoPresentInRules(idsToDelete, (AsyncCallback<List<UiMso>>)new NeptuneAsyncCallback<List<UiMso>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UiMso> result) {
                if (result != null && result.isEmpty()) {
                    MSOListPanel.this.msoUsedinRules = true;
                }
            }
        });
    }

    private void deleteMSOs(List<Integer> selectedIds) {
        this.messageArea.reset();
        this.viewService.deleteMsos(selectedIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                MSOListPanel.this.messageArea.setErrorMessage("Delete error: " + caught.getMessage());
                MSOListPanel.this.refresh(null);
            }

            public void onNeptuneSuccess(Void result) {
                MSOListPanel.this.messageArea.setInfoMessage(" MSOs have been successfully deleted");
                MSOListPanel.this.refresh(null);
            }
        });
    }

    public void anchorChanged(String anchor) {
        this.anchorChangeListener.anchorChanged(anchor);
    }

    public void setMso(UiMso mso) {
        this.mso = mso;
    }

    public UiMso getMso() {
        return this.mso;
    }

    public ResizableContainer getResizableContainer() {
        return this.resizableContainer;
    }

    public void setResizableContainer(ResizableContainer resizableContainer) {
        this.resizableContainer = resizableContainer;
    }
}

