/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.mso;

import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.mso.MSOListPanel;
import com.ericsson.cms.sites.ui.client.mso.model.UiMso;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewService;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.SimpleListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class MsoCreatePanel
extends Composite {
    private VerticalContainer mainPanel;
    private final TextBoxWidget nameTextBox = new TextBoxWidget();
    private TextAreaWidget descriptionTextArea;
    private final FormContainer formContainer;
    private final int DESCRIPTION_VISIBLE_COUNT = 5;
    private final int DESCRIPTION_CHAR_WIDTH = 40;
    private ResizableContainer resizableContainer;
    private HeaderPanel headerPanel;
    private String createTab = "Create MSO";
    private HorizontalPanel shuffleBox;
    private MessageArea messageArea;
    private IMsoViewServiceAsync viewService;
    private UiMso mso = null;
    private List<UISite> siteList = null;
    private SimpleListBoxWidget rightList;
    private SimpleListBoxWidget leftList;
    List<UiMso> msoList = null;
    private MSOListPanel msoListPanel;
    ButtonWidget saveButton;
    ButtonWidget cancelButton;

    public MsoCreatePanel(MSOListPanel msoListPanel, boolean edit, final UiMso mso, List<UiMso> msoList) {
        if (edit) {
            this.createTab = "Edit MSO";
            this.headerPanel = new HeaderPanel("MSO Details: " + mso.getName());
        } else {
            this.headerPanel = new HeaderPanel("MSO Administration");
        }
        this.headerPanel.getLabel().setStyleName("mso-header-style");
        this.formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.msoListPanel = msoListPanel;
        this.msoList = msoList;
        this.mso = mso;
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        this.viewService = (IMsoViewServiceAsync)GWT.create(IMsoViewService.class);
        this.saveButton = new ButtonWidget("Save");
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.cancelButton = new ButtonWidget("Cancel");
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.mainPanel = new VerticalContainer();
        this.mainPanel.setWidth("100%");
        this.formContainer.addRow("Name", (Widget)this.nameTextBox, true);
        this.nameTextBox.setMaxLength(255);
        if (mso != null) {
            this.nameTextBox.setValue((Object)mso.getName());
        }
        this.nameTextBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                mso.setName(MsoCreatePanel.this.nameTextBox.getText());
            }
        });
        this.descriptionTextArea = new TextAreaWidget();
        this.descriptionTextArea.getElement().setAttribute("maxlength", "250");
        this.descriptionTextArea.setCharacterWidth(40);
        this.descriptionTextArea.setVisibleLines(5);
        if (mso != null) {
            this.descriptionTextArea.setValue((Object)mso.getDescription());
        }
        this.descriptionTextArea.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                mso.setDescription(MsoCreatePanel.this.descriptionTextArea.getText());
            }
        });
        this.formContainer.addRow("Description", (Widget)this.descriptionTextArea, false);
        this.shuffleBox = this.createShuffleBox();
        this.formContainer.addRow("Sites", (Widget)this.shuffleBox, false);
        this.resizableContainer = new ResizableContainer((Widget)this.formContainer, this.createTab, null);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.messageArea);
        this.resizableContainer.addBottomWidget(this.createTab, (Widget)this.saveButton);
        this.resizableContainer.addBottomWidget(this.createTab, (Widget)this.cancelButton);
        this.resizableContainer.getTabContainer().getTabBar().setVisible(false);
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!MsoCreatePanel.this.validate()) {
                    return;
                }
                MsoCreatePanel.this.saveMso();
            }
        });
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MsoCreatePanel.this.cancel();
            }
        });
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"})) {
            this.saveButton.setVisible(false);
        }
        this.mainPanel.add((Widget)this.headerPanel);
        this.mainPanel.add((Widget)this.messageArea);
        this.mainPanel.add((Widget)this.resizableContainer);
        this.initWidget((Widget)this.mainPanel);
    }

    private void saveMso() {
        this.msoListPanel.getMessageArea().reset();
        this.messageArea.reset();
        this.attachSites(this.mso, this.rightList);
        this.viewService.saveMso(this.mso, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                History.newItem((String)"Sites.MSO", (boolean)false);
                MsoCreatePanel.this.msoListPanel.cleanup();
                MsoCreatePanel.this.msoListPanel.refresh(null);
                MsoCreatePanel.this.msoListPanel.getMessageArea().setErrorMessage("Save error. " + caught.getMessage());
            }

            public void onNeptuneSuccess(Void result) {
                History.newItem((String)"Sites.MSO", (boolean)false);
                MsoCreatePanel.this.msoListPanel.cleanup();
                MsoCreatePanel.this.msoListPanel.refresh(null);
                MsoCreatePanel.this.msoListPanel.getMessageArea().setInfoMessage("MSO has been saved successfully");
                MsoCreatePanel.this.msoListPanel.getResizableContainer().updateSize();
            }
        });
    }

    private boolean validate() {
        boolean check = true;
        if (this.mso.getName() == null || this.mso.getName().trim().isEmpty()) {
            this.messageArea.setErrorMessage("MSO name cannot be null");
            check = false;
        }
        if (this.mso.getDescription() != null && !this.mso.getDescription().isEmpty() && this.mso.getDescription().length() > 255) {
            this.messageArea.setErrorMessage("MSO Description is too long. Limit is 255 characters. ");
            check = false;
        }
        return check;
    }

    private void attachSites(UiMso mso, SimpleListBoxWidget rightList) {
        mso.setSiteList(null);
        if (rightList != null) {
            int i = 0;
            while (i < rightList.getItemCount()) {
                String siteName = rightList.getItemText(i);
                UISite uiSite = this.getUiSiteFromName(siteName);
                if (uiSite != null) {
                    mso.addUISite(uiSite);
                }
                ++i;
            }
        }
    }

    private UISite getUiSiteFromName(String siteName) {
        if (this.siteList != null) {
            for (UISite uiSite : this.siteList) {
                if (uiSite.getName() == null || !uiSite.getName().equalsIgnoreCase(siteName)) continue;
                return uiSite;
            }
        }
        return null;
    }

    public UiMso getMso() {
        return this.mso;
    }

    public void setMso(UiMso mso) {
        this.mso = mso;
    }

    private void cancel() {
        History.newItem((String)"Sites.MSO", (boolean)false);
        this.msoListPanel.cleanup();
        this.msoListPanel.refresh(null);
    }

    private HorizontalPanel createShuffleBox() {
        HorizontalPanel shufflePanel = new HorizontalPanel();
        shufflePanel.setStyleName("asset-type-shuffle");
        this.rightList = new SimpleListBoxWidget(true);
        this.rightList.setStyleName("asset-type-shuffle-list-box");
        this.leftList = new SimpleListBoxWidget(true);
        this.leftList.setStyleName("asset-type-shuffle-list-box");
        ButtonWidget moveRightButton = new ButtonWidget();
        moveRightButton.addStyleName("asset-type-shuffle-button");
        moveRightButton.setText(">");
        moveRightButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = MsoCreatePanel.this.leftList.getItemCount() - 1;
                while (index >= 0) {
                    if (MsoCreatePanel.this.leftList.isItemSelected(index)) {
                        int selectedIndex = MsoCreatePanel.this.leftList.getSelectedIndex();
                        String siteDisplayName = MsoCreatePanel.this.leftList.getItemText(selectedIndex);
                        String siteName = MsoCreatePanel.this.leftList.getValue(selectedIndex);
                        MsoCreatePanel.this.leftList.removeItem(selectedIndex);
                        MsoCreatePanel.this.rightList.addItem(siteDisplayName, siteName);
                    }
                    --index;
                }
            }
        });
        ButtonWidget moveLeftButton = new ButtonWidget();
        moveLeftButton.addStyleName("asset-type-shuffle-button");
        moveLeftButton.setText("<");
        moveLeftButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = MsoCreatePanel.this.rightList.getItemCount() - 1;
                while (index >= 0) {
                    if (MsoCreatePanel.this.rightList.isItemSelected(index)) {
                        int selectedIndex = MsoCreatePanel.this.rightList.getSelectedIndex();
                        String assetDisplayName = MsoCreatePanel.this.rightList.getItemText(selectedIndex);
                        String assetName = MsoCreatePanel.this.rightList.getValue(selectedIndex);
                        MsoCreatePanel.this.rightList.removeItem(selectedIndex);
                        MsoCreatePanel.this.leftList.addItem(assetDisplayName, assetName);
                    }
                    --index;
                }
            }
        });
        VerticalPanel leftListContainer = this.createListBoxContainer("Not Associated");
        leftListContainer.add((Widget)this.leftList);
        VerticalPanel rightListContainer = this.createListBoxContainer("Associated");
        rightListContainer.add((Widget)this.rightList);
        VerticalPanel buttonPanel = new VerticalPanel();
        buttonPanel.add((Widget)moveRightButton);
        buttonPanel.add((Widget)moveLeftButton);
        shufflePanel.add((Widget)leftListContainer);
        shufflePanel.add((Widget)buttonPanel);
        shufflePanel.add((Widget)rightListContainer);
        shufflePanel.setCellVerticalAlignment((Widget)buttonPanel, HasVerticalAlignment.ALIGN_MIDDLE);
        shufflePanel.setSpacing(5);
        this.viewService.getAllSites((AsyncCallback<List<UISite>>)new NeptuneAsyncCallback<List<UISite>>(){

            public void onNeptuneFailure(Throwable caught) {
                MsoCreatePanel.this.messageArea.setErrorMessage("Error retrieving mso records: " + caught.getMessage());
            }

            public void onNeptuneSuccess(List<UISite> result) {
                MsoCreatePanel.this.siteList = result;
                for (UISite uiSite : result) {
                    if (MsoCreatePanel.this.msoContainsSite(uiSite.getId())) {
                        MsoCreatePanel.this.rightList.addItem(uiSite.getName());
                        continue;
                    }
                    MsoCreatePanel.this.leftList.addItem(uiSite.getName());
                }
            }
        });
        return shufflePanel;
    }

    private VerticalPanel createListBoxContainer(String label) {
        VerticalPanel container = new VerticalPanel();
        container.add((Widget)new LabelWidget(label));
        return container;
    }

    private boolean msoContainsSite(Integer id) {
        boolean contains = false;
        if (this.mso.getSiteList() != null) {
            for (UISite site : this.mso.getSiteList()) {
                if (!site.getId().equals(id)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }
}

