/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.OverridesAddPanel;
import com.ericsson.cms.sites.ui.client.msooverrides.OverridesListPanel;
import com.ericsson.cms.sites.ui.client.msooverrides.ShowAddDeleteMSOsPanel;
import com.ericsson.cms.sites.ui.client.msooverrides.events.AddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.AddEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelAddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelAddEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelMSOAddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelMSOAddEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.EmptyMSONameEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.EmptyMSONameEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSOAddedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSOAddedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSODeletedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSODeletedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSONameAlreadyUsedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSONameAlreadyUsedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSORenamedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSORenamedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.RemoveOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.RemoveOverridesEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.SaveAllOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.SaveAllOverridesEventHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEvent;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEventHandler;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MSOOverridesPanel
extends Composite
implements AddEventHandler,
CancelAddEventHandler,
SaveAllOverridesEventHandler,
DeleteOverridesEventHandler,
RemoveOverridesEventHandler,
MSOAddedEventHandler,
MSODeletedEventHandler,
MSORenamedEventHandler,
MSOSelectedEventHandler,
NeptuneFailureEventHandler,
MSONameAlreadyUsedEventHandler,
EmptyMSONameEventHandler,
CancelMSOAddEventHandler {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    ShowAddDeleteMSOsPanel msosPanel;
    @UiField
    DeckPanel overridesPanel;
    @UiField
    OverridesListPanel overridesListPanel;
    @UiField
    OverridesAddPanel overridesAddPanel;
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private UISite uiSite;
    private UIMSO selectedUIMSO;
    private MessageArea messageArea;
    private int messageAreaOffsetHeight;

    public MSOOverridesPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.msosPanel.setEventBus(MSOOverridesTab.getEventBus());
        MSOOverridesTab.getEventBus().addHandler(AddEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(CancelAddEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(SaveAllOverridesEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(DeleteOverridesEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(RemoveOverridesEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(MSOAddedEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(MSODeletedEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(MSORenamedEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(MSOSelectedEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(NeptuneFailureEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(MSONameAlreadyUsedEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(EmptyMSONameEvent.TYPE, (EventHandler)this);
        MSOOverridesTab.getEventBus().addHandler(CancelMSOAddEvent.TYPE, (EventHandler)this);
        this.overridesPanel.showWidget(0);
    }

    public MSOOverridesPanel(Map<String, String> info) {
        this();
    }

    public void refresh() {
        if (this.uiSite != null) {
            this.clearErrorMessage();
            this.showBusyIndicator();
            this.uiMSOOverridesService.getMSOs(this.uiSite.getId(), (AsyncCallback<List<UIMSO>>)new NeptuneAsyncCallback<List<UIMSO>>(){

                public void onNeptuneFailure(Throwable caught) {
                    String failureMessage = MSOOverridesPanel.this.sitesMessages.errorGettingMSOs(MSOOverridesPanel.this.uiSite.getName(), caught.getLocalizedMessage());
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                    MSOOverridesPanel.this.hideBusyIndicator();
                }

                public void onNeptuneSuccess(List<UIMSO> result) {
                    MSOOverridesPanel.this.setMSOs(result);
                    if (result.size() < 1) {
                        MSOOverridesPanel.this.overridesPanel.setVisible(false);
                    } else {
                        MSOOverridesPanel.this.overridesPanel.setVisible(true);
                        MSOOverridesPanel.this.overridesAddPanel.refresh();
                        MSOOverridesPanel.this.overridesPanel.showWidget(0);
                    }
                    if (MSOOverridesPanel.this.selectedUIMSO != null) {
                        MSOOverridesPanel.this.msosPanel.setSelected(MSOOverridesPanel.this.selectedUIMSO);
                    }
                    MSOOverridesPanel.this.hideBusyIndicator();
                }
            });
        }
    }

    @Override
    public void add(AddEvent event) {
        this.clearErrorMessage();
        this.overridesAddPanel.refresh();
        this.overridesPanel.showWidget(1);
    }

    @Override
    public void cancelAdd(CancelAddEvent event) {
        this.clearErrorMessage();
        this.overridesPanel.showWidget(0);
    }

    @Override
    public void saveAllOverrides(SaveAllOverridesEvent event) {
        this.clearErrorMessage();
        this.overridesListPanel.refresh();
        this.overridesPanel.showWidget(0);
    }

    @Override
    public void deleteOverrides(DeleteOverridesEvent event) {
        this.clearErrorMessage();
        Collection<Long> overrideIds = event.getOverrideIds();
        if (overrideIds != null && overrideIds.size() > 0) {
            this.overridesListPanel.refresh();
            this.overridesPanel.showWidget(0);
        } else {
            String errMsg = this.sitesMessages.noOverridesSelected();
            this.showErrorMessage(errMsg);
        }
    }

    @Override
    public void removeOverrides(RemoveOverridesEvent event) {
        this.clearErrorMessage();
        List<OverrideRow> removedOverrideRows = event.getRemovedOverrideRows();
        if (removedOverrideRows == null || removedOverrideRows.size() < 1) {
            String errMsg = this.sitesMessages.noOverridesSelected();
            this.showErrorMessage(errMsg);
        }
    }

    @Override
    public void msoAdded(MSOAddedEvent event) {
        this.clearErrorMessage();
        this.selectedUIMSO = event.getUiMSO();
        this.refresh();
    }

    @Override
    public void msoDeleted(MSODeletedEvent event) {
        this.clearErrorMessage();
        this.selectedUIMSO = null;
        this.refresh();
    }

    @Override
    public void msoRenamed(MSORenamedEvent event) {
        this.clearErrorMessage();
        this.selectedUIMSO = event.getUiMSO();
        this.refresh();
    }

    public void msoSelected(MSOSelectedEvent event) {
        this.clearErrorMessage();
        this.overridesListPanel.setUiMSO(event.getUiMSO());
        this.overridesListPanel.refresh();
        this.overridesAddPanel.setUiMSO(event.getUiMSO());
        this.overridesAddPanel.refresh();
        this.overridesPanel.showWidget(0);
    }

    @Override
    public void neptuneFailure(NeptuneFailureEvent event) {
        this.showErrorMessage(event.getFailureMessage());
    }

    @Override
    public void msoNameAlreadyUsed(MSONameAlreadyUsedEvent event) {
        String errMsg = this.sitesMessages.msoNameAlreadyUsed(event.getMsoName());
        this.showErrorMessage(errMsg);
    }

    @Override
    public void msoNameEmpty(EmptyMSONameEvent event) {
        String errMsg = this.sitesMessages.msoNameRequired();
        this.showErrorMessage(errMsg);
    }

    @Override
    public void msoAddCanceled(CancelMSOAddEvent event) {
        this.clearErrorMessage();
    }

    public UISite getUiSite() {
        return this.uiSite;
    }

    public void setUiSite(UISite uiSite) {
        this.uiSite = uiSite;
        this.msosPanel.setUiSite(uiSite);
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    public void setMSOs(List<UIMSO> uiMSOs) {
        this.msosPanel.setMSOs(uiMSOs);
    }

    public void updateSize(int offsetWidth, int offsetHeight) {
        this.msosPanel.msosPanel.updateSize(offsetWidth, offsetHeight);
        this.overridesListPanel.updateSize(offsetWidth, offsetHeight);
        this.overridesAddPanel.updateSize(offsetWidth, offsetHeight + 25);
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    private void clearErrorMessage() {
        if (this.messageArea != null) {
            this.messageArea.reset();
            int offsetWidth = 375;
            int offsetHeight = 260;
            this.updateSize(offsetWidth, offsetHeight);
        }
    }

    private void showErrorMessage(String errMsg) {
        if (this.messageArea != null) {
            this.messageArea.setErrorMessage(errMsg);
            this.updateSizeForMessageArea();
        }
    }

    private void updateSizeForMessageArea() {
        this.messageAreaOffsetHeight = this.messageArea.getOffsetHeight();
        int overridesListPanelOffsetHeight = this.overridesListPanel.getOffsetHeight();
        int overridesListPanelOffsetWidth = this.overridesListPanel.getOffsetWidth();
        int overridesAddPanelOffsetHeight = this.overridesAddPanel.getOffsetHeight();
        int overridesAddPanelOffsetWidth = this.overridesAddPanel.getOffsetWidth();
        this.msosPanel.msosPanel.updateSize(this.msosPanel.msosPanel.getOffsetWidth(), Window.getClientHeight() - this.msosPanel.msosPanel.getOffsetHeight() + this.messageAreaOffsetHeight);
        this.overridesListPanel.updateSize(Window.getClientWidth() - overridesListPanelOffsetWidth, Window.getClientHeight() - overridesListPanelOffsetHeight + this.messageAreaOffsetHeight);
        this.overridesAddPanel.updateSize(Window.getClientWidth() - overridesAddPanelOffsetWidth, Window.getClientHeight() - overridesAddPanelOffsetHeight + this.messageAreaOffsetHeight);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, MSOOverridesPanel> {
    }
}

