/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesPanel;
import com.ericsson.cms.sites.ui.client.msooverrides.MetadataFieldWidget;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Map;

public class MSOOverridesTab
extends SimpleContainer
implements ISiteTab {
    public static final int MSO_OVERRIDES_PANEL_OFFSET_WIDTH = 375;
    public static final int MSO_OVERRIDES_PANEL_OFFSET_HEIGHT = 260;
    private UISite uiSite;
    private static UiMetadataTree metadataTree;
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesConstants sitesConstants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private MSOOverridesPanel msoOverridesPanel;
    private static HandlerManager eventBus;
    private HandlerRegistration windowRegistration = null;

    public MSOOverridesTab(Map<String, String> info) {
        eventBus = new HandlerManager((Object)this);
        this.initWidgets();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                MSOOverridesTab.this.updateSize();
            }
        });
    }

    @Override
    public String getName() {
        return "MSO Overrides";
    }

    @Override
    public String getDisplayName() {
        return this.sitesConstants.msoOverridesTabName();
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        boolean retVal = false;
        if (site != null) {
            this.setUiSite(site);
            UISiteType uiSiteType = this.uiSite.getType();
            if (UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)uiSiteType)) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && this.uiSite != null) {
            History.newItem((String)Anchors.getAnchor(this.uiSite.getId(), this.uiSite.getParentId(), this.getName()), (boolean)false);
            this.loadMetadataTree();
        }
    }

    public UISite getUiSite() {
        return this.uiSite;
    }

    public void setUiSite(UISite uiSite) {
        this.uiSite = uiSite;
        this.msoOverridesPanel.setUiSite(uiSite);
    }

    private void initWidgets() {
        VerticalContainer mainPanel = new VerticalContainer();
        mainPanel.setWidth("100%");
        this.msoOverridesPanel = new MSOOverridesPanel();
        mainPanel.add((Widget)this.msoOverridesPanel);
        this.setWidget((Widget)mainPanel);
    }

    public static HandlerManager getEventBus() {
        return eventBus;
    }

    public static void setEventBus(HandlerManager eventBus) {
        MSOOverridesTab.eventBus = eventBus;
    }

    public static UiMetadataTree getMetadataTree() {
        return metadataTree;
    }

    public static void setMetadataTree(UiMetadataTree metadataTree) {
        MSOOverridesTab.metadataTree = metadataTree;
    }

    private void loadMetadataTree() {
        this.showBusyIndicator();
        this.uiMSOOverridesService.getMetadataFieldsTree((AsyncCallback<UiMetadataTree>)new NeptuneAsyncCallback<UiMetadataTree>(){

            public void onNeptuneFailure(Throwable caught) {
                MSOOverridesTab.this.hideBusyIndicator();
                String failureMessage = MSOOverridesTab.this.sitesMessages.errorGettingMetadataTree(caught.getLocalizedMessage());
                MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
            }

            public void onNeptuneSuccess(UiMetadataTree result) {
                metadataTree = result;
                MetadataFieldWidget.setMetadataSelector(null);
                MetadataFieldWidget.setHandlerRegistration(null);
                MSOOverridesTab.this.msoOverridesPanel.refresh();
                MSOOverridesTab.this.hideBusyIndicator();
            }
        });
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        if (this.msoOverridesPanel != null) {
            this.msoOverridesPanel.setMessageArea(messageArea);
        }
    }

    void updateSize() {
        int offsetWidth = 375;
        int offsetHeight = 260;
        this.msoOverridesPanel.updateSize(offsetWidth, offsetHeight);
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                MSOOverridesTab.this.updateSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }
}

