/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.SaveAllOverridesEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.ArrayList;
import java.util.List;

public class MSOOverridesUtils {
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);

    public void saveAllOverrides(UIMSO uiMSO, List<OverrideRow> overrideRows) {
        if (uiMSO != null && overrideRows != null && overrideRows.size() > 0) {
            MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
            List<UIMSOOverride> uiMSOOverrides = msoOverridesUtils.getUIMSOOverrides(overrideRows);
            boolean areMSOOverridesValid = msoOverridesUtils.areMSOOverridesValid(uiMSOOverrides);
            if (areMSOOverridesValid) {
                int msoId = uiMSO.getMsoId();
                this.saveMSOOverrides(msoId, uiMSOOverrides);
            } else {
                String errMsg = this.sitesMessages.cannotSaveEmptyValues();
                MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(errMsg));
            }
        }
    }

    public List<UIMSOOverride> getUIMSOOverrides(List<OverrideRow> overrideRows) {
        ArrayList<UIMSOOverride> uiMSOOverrides = null;
        if (overrideRows != null) {
            uiMSOOverrides = new ArrayList<UIMSOOverride>();
            if (overrideRows.size() > 0) {
                for (OverrideRow overrideRow : overrideRows) {
                    UIMSOOverride uiMSOOverride = new UIMSOOverride();
                    uiMSOOverride.setOverrideId(overrideRow.getOverrideId());
                    uiMSOOverride.setFieldXPath(overrideRow.getMfwFieldXPath().getValue());
                    uiMSOOverride.setSearchValue(overrideRow.getTxtSearchValue().getText());
                    uiMSOOverride.setReplacementValue(overrideRow.getTxtReplacementValue().getText());
                    uiMSOOverrides.add(uiMSOOverride);
                }
            }
        }
        return uiMSOOverrides;
    }

    public void saveMSOOverrides(final int msoId, List<UIMSOOverride> uiMSOOverrides) {
        this.showBusyIndicator();
        this.uiMSOOverridesService.saveMSOOverrides(msoId, uiMSOOverrides, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                String failureMessage = MSOOverridesUtils.this.sitesMessages.errorSavingOverrides(msoId, caught.getLocalizedMessage());
                MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                MSOOverridesUtils.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(Void result) {
                MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new SaveAllOverridesEvent());
                MSOOverridesUtils.this.hideBusyIndicator();
            }
        });
    }

    public boolean areMSOOverridesValid(List<UIMSOOverride> uiMsoOverrides) {
        boolean areMSOOverridesValid = false;
        for (UIMSOOverride uiMSOOverride : uiMsoOverrides) {
            areMSOOverridesValid = this.isValid(uiMSOOverride);
            if (!areMSOOverridesValid) break;
        }
        return areMSOOverridesValid;
    }

    public boolean isValid(UIMSOOverride uiMsoOverride) {
        boolean isValid = false;
        String fieldXPath = uiMsoOverride.getFieldXPath();
        String searchValue = uiMsoOverride.getSearchValue();
        String replacementValue = uiMsoOverride.getReplacementValue();
        isValid = this.isValidFieldXPath(fieldXPath) && this.isValidSearchValue(searchValue) && this.isValidReplacementValue(replacementValue);
        return isValid;
    }

    public boolean isValidFieldXPath(String fieldXPath) {
        return fieldXPath != null && !fieldXPath.trim().isEmpty() && fieldXPath.contains("/Fields");
    }

    public boolean isValidSearchValue(String searchValue) {
        return searchValue != null && !searchValue.isEmpty();
    }

    public boolean isValidReplacementValue(String replacementValue) {
        return replacementValue != null && !replacementValue.isEmpty();
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }
}

