/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.MetadataSelector;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class MetadataFieldWidget
extends Composite {
    private static final String FULL_DISPLAY_NAME_PREFIX = "";
    String value;
    SimpleContainer container = new SimpleContainer();
    TextBoxWidget textBox;
    private static MetadataSelector metadataSelector;
    private static HandlerRegistration handlerRegistration;
    boolean editable = false;

    public MetadataFieldWidget() {
        this.container.setWidth("100%");
        this.initWidget((Widget)this.container);
        this.textBox = new TextBoxWidget();
        this.container.add((Widget)this.textBox);
        if (metadataSelector == null) {
            metadataSelector = new MetadataSelector(MSOOverridesTab.getMetadataTree(), !this.editable, null);
        }
        this.textBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (handlerRegistration != null) {
                    handlerRegistration.removeHandler();
                }
                MetadataFieldWidget.handlerRegistration = metadataSelector.addSelectionHandler(this.getSelectionHandler());
                int x = MetadataFieldWidget.this.textBox.getAbsoluteLeft();
                int y = MetadataFieldWidget.this.textBox.getAbsoluteTop();
                metadataSelector.show(x, y);
                metadataSelector.setSelectedItem(MetadataFieldWidget.this.value);
            }

            private SelectionHandler<UiMetadataTree> getSelectionHandler() {
                return new SelectionHandler<UiMetadataTree>(){

                    public void onSelection(SelectionEvent<UiMetadataTree> event) {
                        UiMetadataTree metadataNode = (UiMetadataTree)event.getSelectedItem();
                        (this).MetadataFieldWidget.this.textBox.setText(metadataNode.getFullDisplayName());
                        (this).MetadataFieldWidget.this.value = metadataNode.getFullXPath();
                    }
                };
            }
        });
    }

    public void setVisibleLength(int length) {
        this.textBox.setVisibleLength(length);
    }

    public String getText() {
        return this.textBox.getText();
    }

    public void setText(String text) {
        this.textBox.setText(text);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.resolveTextBox();
    }

    public void setEnabled(boolean enabled) {
        this.textBox.setEnabled(enabled);
    }

    private void resolveTextBox() {
        this.setText(this.resolveDisplayName());
    }

    private String resolveDisplayName() {
        String fullXPath;
        UiMetadataTree foundNode;
        String fullDisplayName = null;
        if (this.value != null && (foundNode = this.findNodeByFullXPath(fullXPath = this.value)) != null) {
            fullDisplayName = foundNode.getFullDisplayName();
        }
        return fullDisplayName;
    }

    private UiMetadataTree findNodeByFullXPath(String fullXPath) {
        UiMetadataTree foundNode = null;
        foundNode = this.findNodeByFullXPath(MSOOverridesTab.getMetadataTree(), fullXPath);
        return foundNode;
    }

    private UiMetadataTree findNodeByFullXPath(UiMetadataTree uiMetadataTree, String fullXPath) {
        UiMetadataTree foundNode = null;
        if (uiMetadataTree != null) {
            for (UiMetadataTree node : uiMetadataTree.getChildren()) {
                if (fullXPath.equals(node.getFullXPath())) {
                    foundNode = node;
                    break;
                }
                foundNode = this.findNodeByFullXPath(node, fullXPath);
                if (foundNode != null) break;
            }
        }
        return foundNode;
    }

    public void setWidth(String width) {
        this.textBox.setWidth(width);
    }

    public void setFocus(boolean focused) {
        this.textBox.setFocus(focused);
    }

    public static MetadataSelector getMetadataSelector() {
        return metadataSelector;
    }

    public static void setMetadataSelector(MetadataSelector metadataSelector) {
        MetadataFieldWidget.metadataSelector = metadataSelector;
    }

    public static HandlerRegistration getHandlerRegistration() {
        return handlerRegistration;
    }

    public static void setHandlerRegistration(HandlerRegistration handlerRegistration) {
        MetadataFieldWidget.handlerRegistration = handlerRegistration;
    }
}

