/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesUtils;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.RemoveOverridesEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OverrideRowsPanel
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    protected FlexTable overridesTable;
    protected List<OverrideRow> overrideRows;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesConstants sitesConstants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);
    private NeptuneSecurity security;

    public OverrideRowsPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.security = NeptuneApplication.getApplication().getSecurity();
    }

    public List<UIMSOOverride> getUIMSOOverrides() {
        MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
        return msoOverridesUtils.getUIMSOOverrides(this.overrideRows);
    }

    public void setUIMSOOverrides(List<UIMSOOverride> uiMSOOverrides) {
        this.overrideRows = this.generateOverrideRows(uiMSOOverrides);
        this.setOverrideRowsToTable(this.overrideRows);
    }

    public void addOverrideRow(OverrideRow overrideRow) {
        if (this.overrideRows == null) {
            this.overrideRows = new ArrayList<OverrideRow>();
        }
        this.overrideRows.add(overrideRow);
    }

    public void saveAllOverrides(UIMSO uiMSO) {
        MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
        msoOverridesUtils.saveAllOverrides(uiMSO, this.overrideRows);
    }

    public void deleteSelected() {
        Set<Long> selectedIds = this.getSelectedIds();
        this.delete(selectedIds);
    }

    public void removeSelected() {
        this.removeSelectedFromView();
    }

    public void resetFocus(boolean focused) {
        if (this.overrideRows != null && !this.overrideRows.isEmpty()) {
            OverrideRow firstOverrideRow = this.overrideRows.get(0);
            firstOverrideRow.setFocus(focused);
        }
    }

    protected List<OverrideRow> generateOverrideRows(List<UIMSOOverride> uiMSOOverrides) {
        ArrayList<OverrideRow> overrideRows = null;
        if (uiMSOOverrides != null) {
            overrideRows = new ArrayList<OverrideRow>();
            for (UIMSOOverride uiMSOOverride : uiMSOOverrides) {
                OverrideRow overrideRow = new OverrideRow();
                overrideRow.setOverrideId(uiMSOOverride.getOverrideId());
                overrideRow.getMfwFieldXPath().setValue(uiMSOOverride.getFieldXPath());
                overrideRow.getTxtSearchValue().setText(uiMSOOverride.getSearchValue());
                overrideRow.getTxtReplacementValue().setText(uiMSOOverride.getReplacementValue());
                overrideRows.add(overrideRow);
            }
        }
        return overrideRows;
    }

    protected void setOverrideRowsToTable(final List<OverrideRow> overrideRows) {
        this.overridesTable.removeAllRows();
        this.overridesTable.setWidth("100%");
        this.overridesTable.getRowFormatter().addStyleName(0, "sites-msooverridesList-header");
        int row = 0;
        CheckBoxWidget allCB = new CheckBoxWidget();
        if (this.security.isUserInRole("Sites_Modify")) {
            allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (overrideRows != null) {
                        for (OverrideRow overrideRow : overrideRows) {
                            overrideRow.getCheckBox().setValue((Boolean)event.getValue(), true);
                        }
                    }
                }
            });
        } else {
            allCB.setEnabled(false);
        }
        this.overridesTable.setWidget(row, 0, (Widget)allCB);
        this.overridesTable.setText(row, 1, this.sitesConstants.columnHeadingField());
        this.overridesTable.setText(row, 2, this.sitesConstants.columnHeadingSearchValue());
        this.overridesTable.setText(row, 3, this.sitesConstants.columnHeadingReplacementValue());
        this.overridesTable.getCellFormatter().setWidth(row, 0, "4%");
        this.overridesTable.getCellFormatter().setWidth(row, 1, "45%");
        this.overridesTable.getCellFormatter().setWidth(row, 2, "25%");
        this.overridesTable.getCellFormatter().setWidth(row, 3, "25%");
        if (overrideRows != null) {
            for (OverrideRow overrideRow : overrideRows) {
                this.addOverrideRowToTable(++row, overrideRow);
            }
        }
    }

    protected void addOverrideRowToTable(int row, OverrideRow overrideRow) {
        this.overridesTable.getRowFormatter().addStyleName(row, "sites-msooverridesList-data");
        this.overridesTable.setWidget(row, 0, (Widget)overrideRow.getCheckBox());
        this.overridesTable.setWidget(row, 1, (Widget)overrideRow.getMfwFieldXPath());
        this.overridesTable.setWidget(row, 2, (Widget)overrideRow.getTxtSearchValue());
        this.overridesTable.setWidget(row, 3, (Widget)overrideRow.getTxtReplacementValue());
        if (!this.security.isUserInRole("Sites_Modify")) {
            overrideRow.getCheckBox().setEnabled(false);
            overrideRow.getMfwFieldXPath().setEnabled(false);
            overrideRow.getTxtSearchValue().setEnabled(false);
            overrideRow.getTxtReplacementValue().setEnabled(false);
        }
        this.overridesTable.getCellFormatter().setAlignment(row, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        this.overridesTable.getCellFormatter().setAlignment(row, 1, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        this.overridesTable.getCellFormatter().setAlignment(row, 2, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        this.overridesTable.getCellFormatter().setAlignment(row, 3, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
    }

    protected void delete(final Set<Long> overrideIds) {
        this.showBusyIndicator();
        if (overrideIds != null && overrideIds.size() > 0) {
            this.uiMSOOverridesService.deleteMSOOverrides(overrideIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    OverrideRowsPanel.this.hideBusyIndicator();
                    String failureMessage = OverrideRowsPanel.this.sitesMessages.errorDeletingOverrides(caught.getLocalizedMessage());
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                }

                public void onNeptuneSuccess(Void result) {
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new DeleteOverridesEvent(overrideIds));
                    OverrideRowsPanel.this.hideBusyIndicator();
                }
            });
        }
    }

    protected void removeSelectedFromView() {
        Iterator<OverrideRow> overrideRowsIterator = this.overrideRows.iterator();
        ArrayList<OverrideRow> removedOverrideRows = new ArrayList<OverrideRow>();
        while (overrideRowsIterator.hasNext()) {
            OverrideRow overrideRow = overrideRowsIterator.next();
            boolean checked = overrideRow.getCheckBox().getValue();
            if (!checked) continue;
            removedOverrideRows.add(overrideRow);
            overrideRowsIterator.remove();
        }
        this.setOverrideRowsToTable(this.overrideRows);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                OverrideRowsPanel.this.resetFocus(true);
            }
        });
        MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new RemoveOverridesEvent(removedOverrideRows));
    }

    protected Set<Long> getSelectedIds() {
        List<OverrideRow> selectedRows = this.getSelectedRows();
        HashSet<Long> selectedIds = new HashSet<Long>(selectedRows.size());
        for (OverrideRow overrideRow : selectedRows) {
            Long overrideId = overrideRow.getOverrideId();
            if (overrideId == null) continue;
            selectedIds.add(overrideId);
        }
        return selectedIds;
    }

    protected List<OverrideRow> getSelectedRows() {
        ArrayList<OverrideRow> selectedRows = new ArrayList<OverrideRow>();
        for (OverrideRow overrideRow : this.overrideRows) {
            boolean checked = overrideRow.getCheckBox().getValue();
            if (!checked) continue;
            selectedRows.add(overrideRow);
        }
        return selectedRows;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    static interface MyUiBinder
    extends UiBinder<Widget, OverrideRowsPanel> {
    }
}

