/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRowsPanel;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelAddEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.ArrayList;

public class OverridesAddPanel
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    ScrollPanel scrollPanel;
    @UiField
    OverrideRowsPanel overrideRowsPanel;
    @UiField
    HorizontalPanel buttonsPanel;
    @UiField
    Button btnAddMore;
    @UiField
    Button btnSaveAllOverrides;
    @UiField
    Button btnDelete;
    @UiField
    Button btnCancel;
    private UIMSO uiMSO;
    private int numRows;
    private NeptuneSecurity security;

    public OverridesAddPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.btnCancel.removeStyleName("gwt-Button");
        this.btnCancel.addStyleName("ebBtn");
        if (this.security.isUserInRole("Sites_Modify")) {
            this.btnSaveAllOverrides.removeStyleName("gwt-Button");
            this.btnSaveAllOverrides.addStyleName("ebBtn");
            this.btnSaveAllOverrides.addStyleName("ebBtn_color_green");
            this.btnSaveAllOverrides.addStyleName("save_button_icon");
            this.btnAddMore.removeStyleName("gwt-Button");
            this.btnAddMore.addStyleName("ebBtn");
            this.btnAddMore.addStyleName("addgreen_button_icon");
            this.btnDelete.removeStyleName("gwt-Button");
            this.btnDelete.addStyleName("ebBtn");
            this.btnDelete.addStyleName("delete_button_icon");
        } else {
            this.btnAddMore.setVisible(false);
            this.btnSaveAllOverrides.setVisible(false);
            this.btnDelete.setVisible(false);
        }
    }

    @UiHandler(value={"btnAddMore"})
    public void onClickAddMore(ClickEvent event) {
        ++this.numRows;
        final OverrideRow blankOverrideRow = new OverrideRow();
        this.overrideRowsPanel.addOverrideRow(blankOverrideRow);
        this.overrideRowsPanel.addOverrideRowToTable(this.numRows, blankOverrideRow);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                blankOverrideRow.setFocus(true);
            }
        });
    }

    @UiHandler(value={"btnSaveAllOverrides"})
    public void onClickSaveAllOverrides(ClickEvent event) {
        this.overrideRowsPanel.saveAllOverrides(this.uiMSO);
    }

    @UiHandler(value={"btnCancel"})
    public void onClickCancel(ClickEvent event) {
        MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new CancelAddEvent());
    }

    @UiHandler(value={"btnDelete"})
    public void onClickDelete(ClickEvent event) {
        this.overrideRowsPanel.removeSelected();
    }

    public UIMSO getUiMSO() {
        return this.uiMSO;
    }

    public void setUiMSO(UIMSO uiMSO) {
        this.uiMSO = uiMSO;
    }

    public void refresh() {
        if (this.uiMSO != null) {
            this.numRows = 0;
            ArrayList<UIMSOOverride> uiMSOOverrides = new ArrayList<UIMSOOverride>();
            UIMSOOverride uiMSOOverride = new UIMSOOverride();
            uiMSOOverrides.add(uiMSOOverride);
            this.overrideRowsPanel.setUIMSOOverrides(uiMSOOverrides);
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    OverridesAddPanel.this.overrideRowsPanel.resetFocus(true);
                }
            });
            ++this.numRows;
        }
    }

    public void removeSelected() {
        this.overrideRowsPanel.removeSelected();
    }

    public void updateSize(int offsetWidth, int offsetHeight) {
        int height = Window.getClientHeight() - offsetHeight - this.buttonsPanel.getOffsetHeight();
        this.scrollPanel.setHeight(String.valueOf(height) + "px");
    }

    static interface MyUiBinder
    extends UiBinder<Widget, OverridesAddPanel> {
    }
}

