/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelMSOAddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.EmptyMSONameEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSOAddedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSODeletedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSONameAlreadyUsedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSORenamedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.MSOsPanel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.List;

public class ShowAddDeleteMSOsPanel
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    MSOsPanel msosPanel;
    @UiField
    Button btnAdd;
    @UiField
    Button btnDelete;
    @UiField
    Button btnRename;
    @UiField
    HorizontalPanel hpAddMSO;
    @UiField
    TextBox txtMSO;
    @UiField
    Button btnSave;
    @UiField
    Button btnCancel;
    private UISite uiSite;
    private boolean addingMSO;
    private boolean renamingMSO;
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private NeptuneSecurity security;

    public ShowAddDeleteMSOsPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.security = NeptuneApplication.getApplication().getSecurity();
        if (this.security.isUserInRole("Sites_Modify")) {
            this.btnAdd.removeStyleName("gwt-Button");
            this.btnAdd.addStyleName("ebBtn");
            this.btnAdd.addStyleName("addgreen_button_icon");
            this.btnRename.removeStyleName("gwt-Button");
            this.btnRename.addStyleName("ebBtn");
            this.btnDelete.removeStyleName("gwt-Button");
            this.btnDelete.addStyleName("ebBtn");
            this.btnDelete.addStyleName("delete_button_icon");
            this.btnSave.removeStyleName("gwt-Button");
            this.btnSave.addStyleName("ebBtn");
            this.btnSave.addStyleName("ebBtn_color_green");
            this.btnSave.addStyleName("save_button_icon");
            this.btnCancel.removeStyleName("gwt-Button");
            this.btnCancel.addStyleName("ebBtn");
        } else {
            this.btnAdd.setVisible(false);
            this.btnDelete.setVisible(false);
            this.btnRename.setVisible(false);
        }
    }

    public void setMSOs(List<UIMSO> uiMSOs) {
        this.msosPanel.setMSOs(uiMSOs);
    }

    @UiHandler(value={"btnAdd"})
    public void onClickAdd(ClickEvent event) {
        this.txtMSO.setText(null);
        this.showAddPanel();
        this.addingMSO = true;
        this.renamingMSO = false;
        this.txtMSO.setFocus(true);
    }

    @UiHandler(value={"btnDelete"})
    public void onClickDelete(ClickEvent event) {
        SingleSelectionModel selectionModel;
        UIMSO selectedUIMSO;
        if (!this.msosPanel.isEmpty() && (selectedUIMSO = (UIMSO)(selectionModel = (SingleSelectionModel)this.msosPanel.getSelectionModel()).getSelectedObject()) != null) {
            this.confirm(this.constants.confirmDeleteSelectedMSO(), new Command(){

                public void execute() {
                    ShowAddDeleteMSOsPanel.this.deleteSelectedMSO();
                }
            }, null);
        }
    }

    @UiHandler(value={"btnRename"})
    public void onClickRename(ClickEvent event) {
        SingleSelectionModel selectionModel = (SingleSelectionModel)this.msosPanel.getSelectionModel();
        UIMSO selectedUIMSO = (UIMSO)selectionModel.getSelectedObject();
        if (selectedUIMSO != null) {
            this.txtMSO.setText(selectedUIMSO.getMsoName());
            this.showAddPanel();
            this.addingMSO = false;
            this.renamingMSO = true;
            this.txtMSO.setFocus(true);
        }
    }

    @UiHandler(value={"btnSave"})
    public void onClickSave(ClickEvent event) {
        final int siteId = this.uiSite.getId();
        final String msoName = this.txtMSO.getText();
        if (msoName != null && !msoName.trim().isEmpty()) {
            this.showBusyIndicator();
            this.uiMSOOverridesService.isMSONameAlreadyUsed(siteId, msoName, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                public void onNeptuneFailure(Throwable caught) {
                    String failureMessage = ShowAddDeleteMSOsPanel.this.sitesMessages.errorCheckingMsoNameAlreadyUsed(caught.getLocalizedMessage());
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                    ShowAddDeleteMSOsPanel.this.hideBusyIndicator();
                }

                public void onNeptuneSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new MSONameAlreadyUsedEvent(msoName));
                    } else if (ShowAddDeleteMSOsPanel.this.addingMSO) {
                        UIMSO uiMSO = new UIMSO();
                        uiMSO.setMsoName(msoName);
                        ShowAddDeleteMSOsPanel.this.saveMSO(siteId, uiMSO);
                    } else if (ShowAddDeleteMSOsPanel.this.renamingMSO) {
                        SingleSelectionModel selectionModel = (SingleSelectionModel)ShowAddDeleteMSOsPanel.this.msosPanel.getSelectionModel();
                        UIMSO selectedUIMSO = (UIMSO)selectionModel.getSelectedObject();
                        selectedUIMSO.setMsoName(msoName);
                        ShowAddDeleteMSOsPanel.this.saveMSO(siteId, selectedUIMSO);
                    }
                    ShowAddDeleteMSOsPanel.this.hideBusyIndicator();
                }
            });
        } else {
            MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new EmptyMSONameEvent());
        }
    }

    @UiHandler(value={"btnCancel"})
    public void onClickCancel(ClickEvent event) {
        this.hideAddPanel();
        MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new CancelMSOAddEvent());
    }

    public void saveMSO(final int siteId, UIMSO uiMSO) {
        this.hideAddPanel();
        this.showBusyIndicator();
        this.uiMSOOverridesService.saveMSO(siteId, uiMSO, (AsyncCallback<UIMSO>)new NeptuneAsyncCallback<UIMSO>(){

            public void onNeptuneFailure(Throwable caught) {
                String failureMessage = ShowAddDeleteMSOsPanel.this.sitesMessages.errorSavingMSO(siteId, caught.getLocalizedMessage());
                MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                ShowAddDeleteMSOsPanel.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UIMSO result) {
                if (ShowAddDeleteMSOsPanel.this.addingMSO) {
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new MSOAddedEvent(result));
                    ShowAddDeleteMSOsPanel.this.addingMSO = false;
                } else if (ShowAddDeleteMSOsPanel.this.renamingMSO) {
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new MSORenamedEvent(result));
                    ShowAddDeleteMSOsPanel.this.renamingMSO = false;
                }
                ShowAddDeleteMSOsPanel.this.hideBusyIndicator();
            }
        });
    }

    public UISite getUiSite() {
        return this.uiSite;
    }

    public void setUiSite(UISite uiSite) {
        this.uiSite = uiSite;
    }

    public void setSelected(UIMSO uiMSO) {
        this.msosPanel.setSelected(uiMSO, true);
    }

    public HandlerManager getEventBus() {
        return this.msosPanel.getEventBus();
    }

    public void setEventBus(HandlerManager eventBus) {
        this.msosPanel.setEventBus(eventBus);
    }

    private void showAddPanel() {
        this.hpAddMSO.setVisible(true);
    }

    private void hideAddPanel() {
        this.hpAddMSO.setVisible(false);
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    private void confirm(String questionText, final Command yesCommand, final Command noCommand) {
        final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
        dialogBox.setText(questionText);
        ButtonWidget yesButton = new ButtonWidget(this.constants.buttonLabelYes());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (yesCommand != null) {
                    yesCommand.execute();
                }
            }
        });
        ButtonWidget noButton = new ButtonWidget(this.constants.buttonLabelNo());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (noCommand != null) {
                    noCommand.execute();
                }
            }
        });
        HorizontalContainer buttonPanel = new HorizontalContainer();
        buttonPanel.addStyleName("cms_button_container");
        dialogBox.setWidget((Widget)buttonPanel);
        buttonPanel.add((Widget)yesButton);
        buttonPanel.setCellHorizontalAlignment((Widget)yesButton, HasHorizontalAlignment.ALIGN_RIGHT);
        buttonPanel.add((Widget)noButton);
        buttonPanel.setCellHorizontalAlignment((Widget)noButton, HasHorizontalAlignment.ALIGN_LEFT);
        dialogBox.center();
        dialogBox.show();
    }

    private void deleteSelectedMSO() {
        SingleSelectionModel selectionModel = (SingleSelectionModel)this.msosPanel.getSelectionModel();
        final UIMSO selectedUIMSO = (UIMSO)selectionModel.getSelectedObject();
        if (selectedUIMSO != null) {
            this.showBusyIndicator();
            this.uiMSOOverridesService.deleteMSO(selectedUIMSO.getMsoId(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    String failureMessage = null;
                    failureMessage = ShowAddDeleteMSOsPanel.this.sitesMessages.errorDeletingMSO(selectedUIMSO.getMsoName(), caught.getLocalizedMessage());
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                    ShowAddDeleteMSOsPanel.this.hideBusyIndicator();
                }

                public void onNeptuneSuccess(Void result) {
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new MSODeletedEvent());
                    ShowAddDeleteMSOsPanel.this.hideBusyIndicator();
                }
            });
        }
    }

    static interface MyUiBinder
    extends UiBinder<Widget, ShowAddDeleteMSOsPanel> {
    }
}

