/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides.list;

import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesRequest;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesResponse;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MetadataFieldWidget;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.list.MetadataFieldView;
import com.ericsson.cms.sites.ui.client.msooverrides.list.PaginatedOverridesListPanel;
import com.ericsson.cms.sites.ui.client.msooverrides.list.TextBoxView;
import com.ericsson.cms.sites.ui.client.msooverrides.list.UIMSOOverrideRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PaginatedOverridesListDataProvider
implements DataProvider<Long, UIMSOOverrideRecord> {
    private static final String FIELD_COLUMN = "fieldDisplayName";
    private static final String SEARCH_VALUE_COLUMN = "searchValue";
    private static final String REPLACEMENT_VALUE_COLUMN = "replacementValue";
    private static final String STYLE_FIELD_COLUMN = "msooverridesList-field-column";
    private static final String STYLE_SEARCH_VALUE_COLUMN = "msooverridesList-searchValue-column";
    private static final String STYLE_REPLACEMENT_VALUE_COLUMN = "msooverridesList-replacementValue-column";
    private PaginatedOverridesListPanel view;
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesConstants constants = (SitesConstants)GWT.create(SitesConstants.class);
    private List<Column<?, UIMSOOverrideRecord>> columns;
    private ColumnBase<String, UIMSOOverrideRecord> fieldColumn;
    private ColumnBase<String, UIMSOOverrideRecord> searchValueColumn;
    private ColumnBase<String, UIMSOOverrideRecord> replacementValueColumn;
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<Long, UIMSOOverrideRecord> sortFeature;
    private NeptuneSecurity security;

    public PaginatedOverridesListDataProvider(final PaginatedOverridesListPanel view) {
        this.view = view;
        this.columns = new ArrayList();
        this.security = NeptuneApplication.getApplication().getSecurity();
        final boolean editable = this.security.isUserInRole("Sites_Modify");
        this.fieldColumn = new ColumnBase<String, UIMSOOverrideRecord>(FIELD_COLUMN, this.constants.columnHeadingField()){

            public View<String> getView(UIMSOOverrideRecord record) {
                MetadataFieldView metadataFieldView = new MetadataFieldView(record.getUiMSOOverride().getFieldXPath(), !editable);
                MetadataFieldWidget metadataField = metadataFieldView.getWidget();
                metadataField.setWidth("98%");
                Map<Long, OverrideRow> overrideRowsMap = view.getOverrideRowsMap();
                OverrideRow overrideRow = overrideRowsMap.get(record.getKey());
                if (overrideRow == null) {
                    overrideRow = new OverrideRow();
                    overrideRow.setOverrideId(record.getKey());
                    overrideRowsMap.put(record.getKey(), overrideRow);
                }
                overrideRow.setMfwFieldXPath(metadataField);
                return metadataFieldView;
            }
        };
        this.fieldColumn.setCellStyle(STYLE_FIELD_COLUMN);
        this.columns.add((Column<?, UIMSOOverrideRecord>)this.fieldColumn);
        this.searchValueColumn = new ColumnBase<String, UIMSOOverrideRecord>(SEARCH_VALUE_COLUMN, this.constants.columnHeadingSearchValue()){

            public View<String> getView(UIMSOOverrideRecord record) {
                TextBoxView textBoxStringView = new TextBoxView(record.getUiMSOOverride().getSearchValue(), !editable);
                TextBoxWidget txtSearchValue = textBoxStringView.getTextBoxWidget();
                txtSearchValue.setWidth("98%");
                Map<Long, OverrideRow> overrideRowsMap = view.getOverrideRowsMap();
                OverrideRow overrideRow = overrideRowsMap.get(record.getKey());
                overrideRow.setTxtSearchValue((TextBox)txtSearchValue);
                return textBoxStringView;
            }
        };
        this.searchValueColumn.setCellStyle(STYLE_SEARCH_VALUE_COLUMN);
        this.columns.add((Column<?, UIMSOOverrideRecord>)this.searchValueColumn);
        this.replacementValueColumn = new ColumnBase<String, UIMSOOverrideRecord>(REPLACEMENT_VALUE_COLUMN, this.constants.columnHeadingReplacementValue()){

            public View<String> getView(UIMSOOverrideRecord record) {
                TextBoxView textBoxStringView = new TextBoxView(record.getUiMSOOverride().getReplacementValue(), !editable);
                TextBoxWidget txtReplacementValue = textBoxStringView.getTextBoxWidget();
                txtReplacementValue.setWidth("98%");
                Map<Long, OverrideRow> overrideRowsMap = view.getOverrideRowsMap();
                OverrideRow overrideRow = overrideRowsMap.get(record.getKey());
                overrideRow.setTxtReplacementValue((TextBox)txtReplacementValue);
                return textBoxStringView;
            }
        };
        this.replacementValueColumn.setCellStyle(STYLE_REPLACEMENT_VALUE_COLUMN);
        this.columns.add((Column<?, UIMSOOverrideRecord>)this.replacementValueColumn);
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, UIMSOOverrideRecord>> getColumns() {
        return this.columns;
    }

    public void getRecords(final AsyncCallback<List<UIMSOOverrideRecord>> callback) {
        UIMSO uiMSO = this.view.getUiMSO();
        if (uiMSO != null) {
            this.view.handleGetRecordsRequest();
            int msoId = uiMSO.getMsoId();
            final UIMSOOverridesRequest uiMSOOverridesRequest = new UIMSOOverridesRequest();
            uiMSOOverridesRequest.setMsoId(msoId);
            if (this.pageFeature != null) {
                uiMSOOverridesRequest.setStartIndex((this.pageFeature.getPageNumber() - 1) * this.pageFeature.getPageSize());
                uiMSOOverridesRequest.setNumRecords(this.pageFeature.getPageSize());
            }
            if (this.sortFeature != null) {
                uiMSOOverridesRequest.setSortColumnName(this.sortFeature.getSortColumnName());
                uiMSOOverridesRequest.setAscending(this.sortFeature.isAscending());
            }
            this.uiMSOOverridesService.getMSOOverrides(uiMSOOverridesRequest, (AsyncCallback<UIMSOOverridesResponse>)new NeptuneAsyncCallback<UIMSOOverridesResponse>(){

                public void onNeptuneFailure(Throwable caught) {
                    PaginatedOverridesListDataProvider.this.pageFeature.setRecordCount(-1);
                    callback.onFailure(caught);
                    PaginatedOverridesListDataProvider.this.view.handleGetRecordsFailureResponse(caught);
                }

                public void onNeptuneSuccess(UIMSOOverridesResponse result) {
                    List records = null;
                    if (result != null) {
                        PaginatedOverridesListDataProvider.this.pageFeature.setRecordCount(result.getCount());
                        records = PaginatedOverridesListDataProvider.this.getRecords(uiMSOOverridesRequest, result.getUiMSOOverrides());
                    }
                    callback.onSuccess(records);
                    PaginatedOverridesListDataProvider.this.view.handleGetRecordsSuccessResponse(records);
                }
            });
        }
    }

    public void getRecord(Long key, AsyncCallback<UIMSOOverrideRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public ColumnBase<String, UIMSOOverrideRecord> getDefaultSortColumn() {
        return this.fieldColumn;
    }

    public SortOrder getDefaultSortOrder() {
        return SortOrder.ASCENDING;
    }

    public List<Column<?, UIMSOOverrideRecord>> getSortableColumns() {
        ArrayList sortableColumns = new ArrayList();
        sortableColumns.add((Column<?, UIMSOOverrideRecord>)this.fieldColumn);
        sortableColumns.add((Column<?, UIMSOOverrideRecord>)this.searchValueColumn);
        sortableColumns.add((Column<?, UIMSOOverrideRecord>)this.replacementValueColumn);
        return sortableColumns;
    }

    public void setSortFeature(SortFeatureImpl<Long, UIMSOOverrideRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    private List<UIMSOOverrideRecord> getRecords(UIMSOOverridesRequest uiMSOOverridesRequest, List<UIMSOOverride> uiMSOOverrides) {
        ArrayList<UIMSOOverrideRecord> records = null;
        if (uiMSOOverridesRequest != null && uiMSOOverrides != null) {
            records = new ArrayList<UIMSOOverrideRecord>();
            if (uiMSOOverrides.size() > 0) {
                for (UIMSOOverride uiMSOOverride : uiMSOOverrides) {
                    UIMSOOverrideRecord record = new UIMSOOverrideRecord(uiMSOOverride);
                    records.add(record);
                }
            }
        }
        return records;
    }
}

