/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.msooverrides.list;

import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesUtils;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.events.AddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.list.PaginatedOverridesListDataProvider;
import com.ericsson.cms.sites.ui.client.msooverrides.list.UIMSOOverrideRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PaginatedOverridesListPanel
extends Composite
implements IView {
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private PaginatedOverridesListDataProvider dataProvider;
    private UIMSO uiMSO;
    private Map<Long, OverrideRow> overrideRowsMap;
    private ScrollContainer scrollPanel;
    private VerticalContainer mainContainer;
    private Table<Long, UIMSOOverrideRecord> table;
    private HorizontalContainer buttonsContainer;
    private static final int SPACING = 2;
    private IUIMSOOverridesServiceAsync uiMSOOverridesService = (IUIMSOOverridesServiceAsync)GWT.create(IUIMSOOverridesService.class);
    private SitesConstants sitesConstants = (SitesConstants)GWT.create(SitesConstants.class);
    private SitesMessages sitesMessages = (SitesMessages)GWT.create(SitesMessages.class);
    private NeptuneSecurity security;

    public PaginatedOverridesListPanel() {
        this.overrideRowsMap = new HashMap<Long, OverrideRow>();
        this.dataProvider = new PaginatedOverridesListDataProvider(this);
        this.init();
    }

    public void reportFailure(Throwable caught) {
        Window.alert((String)caught.getLocalizedMessage());
    }

    public Widget getParentContainer() {
        return this.mainContainer;
    }

    public void cleanup() {
    }

    public void refresh(String infoMessage) {
        this.mainContainer.clear();
        this.setContainers();
        this.table.getPageFeature().setPageNumber(1);
        this.overrideRowsMap.clear();
        this.table.showListView();
        this.table.refresh();
    }

    public void show(String infoMessage) {
    }

    public List<Long> getSeletedRecordIds() {
        ArrayList<Long> selectedRecordIds = new ArrayList<Long>();
        List selectedRecords = this.table.getSelectedRecords();
        for (UIMSOOverrideRecord uiMSOOverrideRecord : selectedRecords) {
            selectedRecordIds.add(uiMSOOverrideRecord.getKey());
        }
        return selectedRecordIds;
    }

    public IActionInput getInputToExecution() {
        return null;
    }

    public void show(boolean readOnly) {
    }

    public void handleGetRecordsRequest() {
        this.showBusyIndicator();
    }

    public void handleGetRecordsSuccessResponse(List<UIMSOOverrideRecord> records) {
        this.hideBusyIndicator();
    }

    public void handleGetRecordsFailureResponse(Throwable caught) {
        this.hideBusyIndicator();
    }

    public UIMSO getUiMSO() {
        return this.uiMSO;
    }

    public void setUiMSO(UIMSO uiMSO) {
        this.uiMSO = uiMSO;
    }

    public Map<Long, OverrideRow> getOverrideRowsMap() {
        return this.overrideRowsMap;
    }

    public void setOverrideRowsMap(Map<Long, OverrideRow> overrideRowsMap) {
        this.overrideRowsMap = overrideRowsMap;
    }

    public void addOverrideRow(OverrideRow overrideRow) {
        Long overrideId = overrideRow.getOverrideId();
        this.overrideRowsMap.put(overrideId, overrideRow);
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.scrollPanel = new ScrollContainer();
        this.initWidget((Widget)this.scrollPanel);
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setWidth("100%");
        this.scrollPanel.setWidget((Widget)this.mainContainer);
        this.table = new Table((DataProvider)this.dataProvider);
        CookieStoreBasedPageFeatureImpl pageFeature = new CookieStoreBasedPageFeatureImpl("msoOverridesList");
        this.dataProvider.setPageFeature((PageFeatureImpl)pageFeature);
        this.table.addPageFeature((PageFeature)pageFeature);
        SortFeatureImpl sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), this.dataProvider.getDefaultSortOrder());
        for (Column<?, UIMSOOverrideRecord> sortableColumn : this.dataProvider.getSortableColumns()) {
            sortFeature.addSortableColumn(sortableColumn);
        }
        this.dataProvider.setSortFeature((SortFeatureImpl<Long, UIMSOOverrideRecord>)sortFeature);
        this.table.addSortFeature((SortFeature)sortFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.buttonsContainer = new HorizontalContainer();
        this.buttonsContainer.addStyleName("cms_button_container");
        Button saveAllOverridesButton = new Button(this.sitesConstants.saveOverridesButtonText());
        this.buttonsContainer.add((Widget)saveAllOverridesButton);
        saveAllOverridesButton.removeStyleName("gwt-Button");
        saveAllOverridesButton.addStyleName("ebBtn");
        saveAllOverridesButton.addStyleName("ebBtn_color_green");
        saveAllOverridesButton.addStyleName("save_button_icon");
        saveAllOverridesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ArrayList<OverrideRow> overrideRows = new ArrayList<OverrideRow>(PaginatedOverridesListPanel.this.overrideRowsMap.values());
                MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
                msoOverridesUtils.saveAllOverrides(PaginatedOverridesListPanel.this.uiMSO, overrideRows);
            }
        });
        Button addButton = new Button(this.sitesConstants.addButtonText());
        this.buttonsContainer.add((Widget)addButton);
        addButton.removeStyleName("gwt-Button");
        addButton.addStyleName("ebBtn");
        addButton.addStyleName("addgreen_button_icon");
        addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new AddEvent());
            }
        });
        Button deleteButton = new Button(this.sitesConstants.deleteButtonText());
        this.buttonsContainer.add((Widget)deleteButton);
        deleteButton.removeStyleName("gwt-Button");
        deleteButton.addStyleName("ebBtn");
        deleteButton.addStyleName("delete_button_icon");
        deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PaginatedOverridesListPanel.this.deleteSelected();
            }
        });
        this.table.registerWidgetOnActionContainer((Widget)this.buttonsContainer);
        this.security = NeptuneApplication.getApplication().getSecurity();
        if (!this.security.isUserInRole("Sites_Modify")) {
            addButton.setVisible(false);
            saveAllOverridesButton.setVisible(false);
            deleteButton.setVisible(false);
        }
    }

    protected void deleteSelected() {
        final List<Long> overrideIds = this.getSeletedRecordIds();
        if (overrideIds != null && overrideIds.size() > 0) {
            HashSet<Long> overrideIdsSet = new HashSet<Long>(overrideIds.size());
            overrideIdsSet.addAll(overrideIds);
            this.showBusyIndicator();
            this.uiMSOOverridesService.deleteMSOOverrides(overrideIdsSet, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    PaginatedOverridesListPanel.this.hideBusyIndicator();
                    String failureMessage = PaginatedOverridesListPanel.this.sitesMessages.errorDeletingOverrides(caught.getLocalizedMessage());
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new NeptuneFailureEvent(failureMessage));
                }

                public void onNeptuneSuccess(Void result) {
                    MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new DeleteOverridesEvent(overrideIds));
                    PaginatedOverridesListPanel.this.hideBusyIndicator();
                }
            });
        } else {
            MSOOverridesTab.getEventBus().fireEvent((GwtEvent)new DeleteOverridesEvent(overrideIds));
        }
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void updateSize(int offsetWidth, int offsetHeight) {
        int height = Window.getClientHeight() - offsetHeight;
        this.scrollPanel.setHeight(String.valueOf(height) + "px");
    }
}

