/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.portlet;

import com.ericsson.cms.sites.ui.client.portlet.distribution.DistributionPortletData;
import com.ericsson.cms.sites.ui.client.portlet.distribution.DistributionPortletRecord;
import com.ericsson.cms.sites.ui.client.portlet.distribution.IDistributionPortletService;
import com.ericsson.cms.sites.ui.client.portlet.distribution.IDistributionPortletServiceAsync;
import com.ericsson.cms.sites.ui.client.portlet.distribution.PortletConstants;
import com.ericsson.cms.sites.ui.client.portlet.distribution.TitleMetadata;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.List;
import java.util.Map;

public class DistributionPortlet
extends Portlet {
    private NeptuneSecurity security;
    private FlexTableContainer table;
    private SimplePanel empty;
    private IDistributionPortletServiceAsync portletService;
    private SpecificationServiceAsync tableService;
    private Timer refreshTimer;
    private PortletConstants constants;
    private TitleClientBundle titleBundle;
    private static final String TABLE_NAME = "title.portlet.Metadata";
    private String DISTRIBUTION_PORTLET_REFRESH_KEY = "site.portlets.distribution.refreshTime";
    private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";
    private int DEFAULT_REFRESH = 60;
    private int refreshPeriod;
    private UiTable uiTable;

    public DistributionPortlet(NeptuneSecurity security, Map<String, String> info) {
        super("DISTRIBUTION");
        this.security = security;
        this.refreshPeriod = this.getRefreshPeriod(info);
        this.portletService = (IDistributionPortletServiceAsync)GWT.create(IDistributionPortletService.class);
        this.tableService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.titleBundle = new TitleClientBundle();
        this.setTitle(this.constants.portletHeader());
        this.setDisplayName(this.constants.portletHeader());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.table.addStyleDependentName("portletDistTable");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.portletNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                DistributionPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.initializeTable();
        this.portletService.getData((AsyncCallback<DistributionPortletData>)new NeptuneAsyncCallback<DistributionPortletData>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(DistributionPortletData data) {
                if (data.getCount() > 0) {
                    DistributionPortlet.this.clearTableData();
                    DistributionPortlet.this.prepareTableHeader(data);
                    DistributionPortlet.this.populateTableData(data);
                    DistributionPortlet.this.table.setVisible(true);
                    DistributionPortlet.this.empty.setVisible(false);
                } else {
                    DistributionPortlet.this.table.setVisible(false);
                    DistributionPortlet.this.empty.setVisible(true);
                }
                DistributionPortlet.this.update();
            }
        });
    }

    private void initializeTable() {
        this.tableService.getTable(TABLE_NAME, (AsyncCallback)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(UiTable uiTable) {
                DistributionPortlet.this.setTable(uiTable);
            }
        });
    }

    private void setTable(UiTable table) {
        this.uiTable = table;
    }

    private void prepareTableHeader(DistributionPortletData data) {
        if (data.getCount() == 0) {
            return;
        }
        this.table.setWidget(0, 0, (Widget)new LabelWidget(this.constants.status()));
        this.table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
        this.table.getCellFormatter().setStyleName(0, 1, "portlet-tableHeader-hidden");
        List columns = this.uiTable.getColumns();
        if (columns == null) {
            return;
        }
        int colIndex = 1;
        int i = 0;
        while (i < columns.size()) {
            UiColumn col = (UiColumn)columns.get(i);
            String colHeader = col.getDisplayName();
            this.table.setWidget(0, colIndex, (Widget)new LabelWidget(colHeader));
            this.table.getCellFormatter().addStyleName(0, ++colIndex, "portlet-tableHeader-hidden");
            ++colIndex;
            ++i;
        }
    }

    private void clearTableData() {
        this.table.removeAllRows();
    }

    private void populateTableData(DistributionPortletData data) {
        List<DistributionPortletRecord> records = data.getRecords();
        if (records == null) {
            return;
        }
        int dataRow = 1;
        int i = 0;
        while (i < records.size()) {
            int colIndex = 0;
            DistributionPortletRecord record = records.get(i);
            List<TitleMetadata> metadata = record.getMetadata();
            this.table.setWidget(dataRow, colIndex, this.buildStatusWidget(record.getAggregatedStatusName(), record.getTitleId()));
            this.table.getCellFormatter().setStyleName(dataRow, colIndex, "portlet-table-icons");
            this.populateOfferIcons(dataRow, ++colIndex, record.isOffer());
            this.populateTitleMetadata(dataRow, ++colIndex, metadata, record.getTitleId());
            ++dataRow;
            ++i;
        }
    }

    private void populateOfferIcons(int row, int col, Boolean isOffer) {
        if (isOffer.booleanValue()) {
            this.table.setWidget(row, col, this.getOfferImage("offerIcon"));
        }
        this.table.getCellFormatter().setStyleName(row, col, "portlet-table-icons");
    }

    private void populateTitleMetadata(int row, int col, List<TitleMetadata> metadata, long titleId) {
        if (metadata == null) {
            return;
        }
        int i = 0;
        while (i < metadata.size()) {
            int colIndex = col + i;
            if (colIndex == 2 && this.security.isUserInRole(CONTENT_VIEW_PERMISSION)) {
                this.table.setWidget(row, colIndex, (Widget)new HyperlinkWidget(metadata.get(i).getValue(), "Content.Search.Id=" + titleId + "&Tab=Sites"));
            } else {
                this.table.setWidget(row, colIndex, (Widget)new LabelWidget(metadata.get(i).getValue()));
            }
            this.table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
            ++i;
        }
    }

    private Widget buildStatusWidget(String status, long titleId) {
        return this.getImage(status);
    }

    private ImageWidget getImage(String status) {
        ImageWidget image = new ImageWidget();
        this.titleBundle.updateDistributionStatusIcon((Image)image, status);
        return image;
    }

    private Widget getOfferImage(String offerIcon) {
        ImageWidget image = new ImageWidget();
        this.titleBundle.updateIcon((Image)image, offerIcon);
        return image;
    }

    private int getRefreshPeriod(Map<String, String> info) {
        String refreshPeriod = info.get(this.DISTRIBUTION_PORTLET_REFRESH_KEY);
        try {
            int refresh = Integer.parseInt(refreshPeriod.trim());
            if (refresh < this.DEFAULT_REFRESH) {
                refresh = this.DEFAULT_REFRESH;
            }
            return refresh * 1000;
        }
        catch (Exception exception) {
            return this.DEFAULT_REFRESH * 1000;
        }
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            DistributionPortlet.this.refreshTimer.scheduleRepeating(DistributionPortlet.this.refreshPeriod);
            DistributionPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            DistributionPortlet.this.refreshTimer.cancel();
        }
    }
}

