/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.tabs.schedules;

import com.ericsson.cms.sites.ui.client.entities.SchedulesCalendarData;
import com.ericsson.cms.sites.ui.client.entities.UISchedule;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class CalendarWidget
extends Composite {
    private SitePartnerConstants constants = (SitePartnerConstants)GWT.create(SitePartnerConstants.class);
    private FlexTableContainer table = new FlexTableContainer();

    public CalendarWidget() {
        this.initWidget((Widget)this.table);
    }

    public void show(SchedulesCalendarData data) {
        this.clear();
        HTMLTable.RowFormatter rf = this.table.getRowFormatter();
        rf.addStyleName(0, "sites-schedules-calHead");
        this.table.setWidget(0, 0, (Widget)new LabelWidget(this.constants.sun()));
        this.table.setWidget(0, 1, (Widget)new LabelWidget(this.constants.mon()));
        this.table.setWidget(0, 2, (Widget)new LabelWidget(this.constants.tue()));
        this.table.setWidget(0, 3, (Widget)new LabelWidget(this.constants.wed()));
        this.table.setWidget(0, 4, (Widget)new LabelWidget(this.constants.thu()));
        this.table.setWidget(0, 5, (Widget)new LabelWidget(this.constants.fri()));
        this.table.setWidget(0, 6, (Widget)new LabelWidget(this.constants.sat()));
        int rowIndex = 1;
        int colIndex = 0;
        int date = 1;
        rf.addStyleName(rowIndex, "sites-schedules-calBody");
        while (true) {
            int day = colIndex + 1;
            if (date != 1 || day >= data.getBeginningDay()) {
                this.table.setWidget(rowIndex, colIndex, (Widget)new DateCell(date, data.getSchedules().get(date)));
                if (date == data.getNumDays()) {
                    while (colIndex++ < 6) {
                        this.table.setWidget(rowIndex, colIndex, null);
                    }
                    break;
                }
                ++date;
            }
            if (colIndex == 6) {
                rf.addStyleName(++rowIndex, "sites-schedules-calBody");
                colIndex = 0;
                continue;
            }
            ++colIndex;
        }
    }

    public void clear() {
        this.table.removeAllRows();
    }

    private class DateCell
    extends Composite {
        private ISiteClientBundle clientBundle = (ISiteClientBundle)GWT.create(ISiteClientBundle.class);

        public DateCell(int date, final UISchedule schedule) {
            VerticalContainer panel = new VerticalContainer();
            panel.setSize("50px", "50px");
            panel.add((Widget)new LabelWidget(Integer.toString(date)));
            if (schedule != null) {
                ImageWidget widget = new ImageWidget();
                widget.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        History.newItem((String)("PMM.Schedule?scheduleId=" + schedule.getId()));
                    }
                });
                if (schedule.isError()) {
                    widget.setResource(this.clientBundle.scheduleError());
                } else {
                    widget.setResource(this.clientBundle.schedule());
                }
                widget.addStyleName("sites-schedules-scheduleLink");
                widget.setAltText("View Schedule");
                panel.add((Widget)widget);
            }
            this.initWidget((Widget)panel);
        }
    }
}

