/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.client.tabs.schedules;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.IUISitePartnerService;
import com.ericsson.cms.sites.ui.client.IUISitePartnerServiceAsync;
import com.ericsson.cms.sites.ui.client.SitesTabContainer;
import com.ericsson.cms.sites.ui.client.entities.ScheduleTabInitData;
import com.ericsson.cms.sites.ui.client.entities.SchedulesCalendarData;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerConstants;
import com.ericsson.cms.sites.ui.client.tabs.schedules.CalendarWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Map;

public class SchedulesTab
extends Composite
implements ISiteTab {
    private static final String STYLE_CREATE_DISTRIBUTION_SCHEDULE = "create_distribution_schedule";
    private VerticalContainer mainPanel;
    private MessageArea messageArea;
    private FormContainer formContainer;
    private ListBoxWidget<Integer> monthValueWidget = new ListBoxWidget();
    private ListBoxWidget<Integer> yearValueWidget = new ListBoxWidget();
    private ButtonWidget searchButton;
    private ButtonWidget createButton;
    private CalendarWidget cal = new CalendarWidget();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private IUISitePartnerServiceAsync service = (IUISitePartnerServiceAsync)GWT.create(IUISitePartnerService.class);
    private SitePartnerConstants constants = (SitePartnerConstants)GWT.create(SitePartnerConstants.class);
    private UISite site;
    private long contextId;
    private NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();

    public SchedulesTab() {
        this.buildUI();
        this.initWidget((Widget)this.mainPanel);
    }

    private void buildUI() {
        this.mainPanel = new VerticalContainer();
        this.formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.fillMonths();
        HorizontalContainer hc = new HorizontalContainer();
        hc.add((Widget)new LabelWidget(this.constants.fieldLabelMonth()));
        hc.add(this.monthValueWidget);
        hc.add((Widget)new LabelWidget(this.constants.fieldLabelYear()));
        hc.add(this.yearValueWidget);
        hc.setSpacing(5);
        this.formContainer.addRow("", (Widget)hc);
        this.searchButton = new ButtonWidget(this.constants.buttonLabelSearch(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulesTab.this.search();
            }
        });
        hc.add((Widget)this.searchButton);
        this.searchButton.removeStyleName("gwt-Button");
        this.searchButton.addStyleName("ebBtn");
        this.searchButton.addStyleName("ebBtn_color_darkBlue");
        this.searchButton.addStyleName("search_button_icon");
        this.createButton = new ButtonWidget(this.constants.buttonLabelCreate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SchedulesTab.this.create();
            }
        });
        this.createButton.removeStyleName("gwt-Button");
        this.createButton.addStyleName("ebBtn");
        this.createButton.addStyleName("ebBtn_color_green");
        this.createButton.addStyleName("create_button_icon");
        this.createButton.addStyleName(STYLE_CREATE_DISTRIBUTION_SCHEDULE);
        this.mainPanel.add((Widget)this.formContainer);
        LabelWidget spacer = new LabelWidget("Distribution Schedule");
        spacer.setStyleName("distribution_header_style");
        this.mainPanel.add((Widget)spacer);
        this.mainPanel.add((Widget)this.cal);
        this.mainPanel.add((Widget)this.createButton);
    }

    @Override
    public String getDisplayName() {
        return this.constants.schedulesTabName();
    }

    @Override
    public String getName() {
        return "Schedules";
    }

    @Override
    public void setCRUDNotifier(SitesTabContainer.SiteCRUDNotifier crudNotifier) {
    }

    @Override
    public boolean setSite(UISite site, Map<String, String> params) {
        this.site = site;
        if (site == null) {
            return false;
        }
        boolean createButtonVisible = site.isActive() && this.security.isUserInRole("Schedules_Create") && this.security.isUserInRole("Scheduler_Create") && this.security.isUserInRole("Sites_Modify");
        this.createButton.setVisible(createButtonVisible);
        return site.getType() != UISiteType.TRACKING;
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected || this.site == null) {
            return;
        }
        History.newItem((String)Anchors.getAnchor(this.site.getId(), this.site.getParentId(), this.getName()), (boolean)false);
        this.showError(null);
        this.showInfo(null);
        this.busyIndicator.center();
        this.service.getScheduleTabInitData(this.site.getId(), (AsyncCallback<ScheduleTabInitData>)new NeptuneAsyncCallback<ScheduleTabInitData>(){

            public void onNeptuneFailure(Throwable caught) {
                SchedulesTab.this.showError("Failed to initialize. Reason: " + (caught != null ? caught.getLocalizedMessage() : ""));
                SchedulesTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(ScheduleTabInitData result) {
                SchedulesTab.this.busyIndicator.hide();
                SchedulesTab.this.monthValueWidget.setSelectedItem((Object)result.getDate().getMonth());
                SchedulesTab.this.setYears(result.getDate().getYear());
                SchedulesTab.this.contextId = result.getContextId();
                SchedulesTab.this.search();
            }
        });
    }

    private void fillMonths() {
        this.monthValueWidget.addItem(this.constants.jan(), (Object)0);
        this.monthValueWidget.addItem(this.constants.feb(), (Object)1);
        this.monthValueWidget.addItem(this.constants.mar(), (Object)2);
        this.monthValueWidget.addItem(this.constants.apr(), (Object)3);
        this.monthValueWidget.addItem(this.constants.may(), (Object)4);
        this.monthValueWidget.addItem(this.constants.jun(), (Object)5);
        this.monthValueWidget.addItem(this.constants.jul(), (Object)6);
        this.monthValueWidget.addItem(this.constants.aug(), (Object)7);
        this.monthValueWidget.addItem(this.constants.sep(), (Object)8);
        this.monthValueWidget.addItem(this.constants.oct(), (Object)9);
        this.monthValueWidget.addItem(this.constants.nov(), (Object)10);
        this.monthValueWidget.addItem(this.constants.dec(), (Object)11);
    }

    private void setYears(int cy) {
        this.yearValueWidget.clear();
        int i = cy + 1;
        while (i >= cy - 5) {
            this.yearValueWidget.addItem(Integer.toString(i), (Object)i);
            --i;
        }
        this.yearValueWidget.setSelectedItem((Object)cy);
    }

    private void create() {
        History.newItem((String)("PMM.Schedule.Create?contextId=" + this.contextId));
    }

    private void search() {
        this.busyIndicator.center();
        this.service.getSchedulesCalendar(this.site.getId(), (Integer)this.monthValueWidget.getSelectedItem(), (Integer)this.yearValueWidget.getSelectedItem(), (AsyncCallback<SchedulesCalendarData>)new NeptuneAsyncCallback<SchedulesCalendarData>(){

            public void onNeptuneFailure(Throwable caught) {
                SchedulesTab.this.cal.clear();
                SchedulesTab.this.busyIndicator.hide();
                SchedulesTab.this.showError("Unable to get schedules information. Reason: " + caught != null ? caught.getLocalizedMessage() : null);
            }

            public void onNeptuneSuccess(SchedulesCalendarData result) {
                SchedulesTab.this.cal.show(result);
                SchedulesTab.this.busyIndicator.hide();
            }
        });
    }

    private void showError(String message) {
        this.messageArea.setErrorMessage(message);
    }

    private void showInfo(String message) {
        this.messageArea.setInfoMessage(message);
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }
}

