/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExportSiteTitlesServlet
extends HttpServlet {
    private static final long serialVersionUID = -2034250459320880679L;
    private static final Logger logger = Logger.getLogger(ExportSiteTitlesServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw;
        String filePath = req.getParameter("filePath");
        if (filePath == null || filePath.isEmpty()) {
            try {
                resp.sendError(500, "Filepath is null or empty.");
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            return;
        }
        String fileName = this.getFileNameFromFilePath(filePath);
        String fileNameToBrowser = this.getFileNameToBrowser(fileName);
        resp.setContentType("text/csv; charset=UTF-8");
        resp.addHeader("Content-Disposition", "attachment; filename=" + fileNameToBrowser);
        try {
            pw = resp.getWriter();
        }
        catch (IOException e) {
            logger.error((Object)e);
            return;
        }
        try {
            File file = new File(filePath);
            if (file.exists() && file.canRead()) {
                String str;
                pw.print("\ufeff");
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
                while ((str = in.readLine()) != null) {
                    pw.println(str);
                }
                in.close();
                try {
                    file.delete();
                }
                catch (Exception e) {
                    logger.error((Object)("Error deleting file : " + filePath + " : " + e), (Throwable)e);
                }
            } else {
                String msg = "Cannot find or cannot read file : " + filePath;
                logger.warn((Object)msg);
            }
            pw.close();
        }
        catch (Exception e) {
            logger.error((Object)("Exception occured streaming file to response stream : " + e), (Throwable)e);
            try {
                resp.sendError(500, e.toString());
            }
            catch (IOException iOException) {
                logger.error((Object)("Exception occured sending error message to response stream : " + e), (Throwable)e);
            }
            return;
        }
    }

    private String getFileNameFromFilePath(String filePath) {
        String fileName = null;
        if (filePath != null && !filePath.isEmpty()) {
            int lastIndexOfFileSeparator = filePath.lastIndexOf(File.separator);
            fileName = filePath.substring(lastIndexOfFileSeparator + 1);
        }
        return fileName;
    }

    private String getFileNameToBrowser(String fileName) {
        String fileNameToBrowser = fileName;
        fileNameToBrowser = fileName.replaceAll("\\s", "_");
        return fileNameToBrowser;
    }
}

