/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.sites.ui.client.entities.SiteActivityTable;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTables;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.server.UISiteService;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExportSitesActivityServlet
extends HttpServlet {
    private static final long serialVersionUID = 8335562994731486722L;
    private static final Logger logger = Logger.getLogger(ExportSitesActivityServlet.class);
    private static final String NULL = "null";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        UITrackingStatus trackStatus;
        UIDistributionStatus distStatus;
        UISiteType siteType;
        resp.setContentType("application/vnd.ms-excel");
        resp.addHeader("Content-Disposition", "attachment; filename=sites-activity.csv");
        String siteTypeStr = req.getParameter("siteType");
        String distSiteIdStr = req.getParameter("distSiteId");
        String trackSiteIdStr = req.getParameter("trackSiteId");
        String distStatusStr = req.getParameter("distStatus");
        String trackStatusStr = req.getParameter("trackStatus");
        String fromDateStr = req.getParameter("fromDate");
        String toDateStr = req.getParameter("toDate");
        Integer distSiteId = null;
        Integer trackSiteId = null;
        try {
            siteType = UISiteType.valueOf(siteTypeStr);
            if (siteType != UISiteType.DISTRIBUTION && siteType != UISiteType.TRACKING) {
                throw new RuntimeException("Unsupported site type.");
            }
            if (!distSiteIdStr.equals(NULL)) {
                distSiteId = Integer.parseInt(distSiteIdStr);
            }
            if (!trackSiteIdStr.equals(NULL)) {
                trackSiteId = Integer.parseInt(trackSiteIdStr);
            }
            distStatus = UIDistributionStatus.valueOf((String)distStatusStr);
            trackStatus = UITrackingStatus.valueOf((String)trackStatusStr);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid request parameters.", (Throwable)e);
            try {
                resp.sendError(500, "Invalid request parameters.");
            }
            catch (IOException ioe) {
                logger.error((Object)"Exception while sending HTTP-500 error.", (Throwable)ioe);
            }
            return;
        }
        SiteActivityTables tables = siteType == UISiteType.DISTRIBUTION ? new UISiteService().getDistSiteActivity(distSiteId, distStatus, fromDateStr, toDateStr, trackSiteId) : new UISiteService().getTrackSiteActivity(trackSiteId, trackStatus, fromDateStr, toDateStr, distSiteId);
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream()));
                out.write("Site Id,Site Name,");
                this.encodeAndWrite(tables.getHeaderRow(), out);
                out.write("\r\n");
                for (SiteActivityTable table : tables.getTables()) {
                    for (List<SiteActivityTable.Column> dataRow : table.getDataRows()) {
                        out.write(String.valueOf(table.getSiteId()));
                        out.write(",");
                        this.encodeAndWrite(table.getSiteName(), out);
                        out.write(",");
                        this.encodeAndWrite(dataRow, out);
                        out.write("\r\n");
                    }
                }
                out.flush();
            }
            catch (IOException e) {
                logger.error((Object)"Exception while writing to the output stream.", (Throwable)e);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)"Exception while closing the output stream", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Exception while closing the output stream", (Throwable)e);
            }
        }
    }

    private void encodeAndWrite(List<?> list, BufferedWriter out) throws IOException {
        boolean firstIteration = true;
        for (Object o : list) {
            if (firstIteration) {
                firstIteration = false;
            } else {
                out.write(44);
            }
            this.encodeAndWrite(o.toString(), out);
        }
    }

    public void encodeAndWrite(String s, BufferedWriter out) throws IOException {
        boolean requiresWrapping = false;
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == ',' || c == '\"') {
                requiresWrapping = true;
            }
            if (c == '\r' || c == '\n') {
                sb.append(' ');
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (requiresWrapping) {
            out.write(34);
        }
        out.write(sb.toString());
        if (requiresWrapping) {
            out.write(34);
        }
    }
}

