/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.mso.model.UiMso;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class MsoViewServiceImpl
implements IMsoViewService,
NeptuneRemoteService {
    private final ISiteManager siteManager = this.getSiteManager();
    private final IMSOManager msoManager = this.getMsoManager();
    private final IRuleManager ruleManager = this.getRuleManager();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;

    public String getRelativePath() {
        return "service/sites/IMSOViewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UISite> getAllMediaDistibutionSites() throws NeptuneException {
        return null;
    }

    @Override
    @Transactional
    public List<UiMso> getAllMsos() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = MsoViewServiceImpl.class.getDeclaredMethod("getAllMsos", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)MsoViewServiceImpl.getAllMsos_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<UiMso> convertToUIMso(List<MSO> msoList) {
        ArrayList<UiMso> uiMsoList = new ArrayList<UiMso>();
        for (MSO mso : msoList) {
            UiMso uiMso = new UiMso();
            uiMso.setKey(mso.getId());
            uiMso.setName(mso.getMsoName());
            uiMso.setDescription(mso.getMsoDescription());
            uiMso.setSiteList(this.getSiteList(mso.getMediaPathSiteSet()));
            uiMsoList.add(uiMso);
        }
        return uiMsoList;
    }

    private List<UISite> getSiteList(Set<MediapathDistributionSite> mediaPathSiteSet) {
        ArrayList<UISite> uiSiteList = new ArrayList<UISite>();
        if (mediaPathSiteSet != null) {
            for (MediapathDistributionSite site : mediaPathSiteSet) {
                UISite uiSite = new UISite();
                uiSite.setId(site.getId());
                uiSite.setName(site.getName());
                uiSiteList.add(uiSite);
            }
        }
        return uiSiteList;
    }

    @Override
    public void deleteMso(UiMso mso) {
    }

    @Override
    public void saveMso(UiMso uiMso) throws NeptuneException {
        if (uiMso != null) {
            ArrayList<Integer> siteIds = null;
            MSO mso = this.convertToMSO(uiMso);
            List<UISite> uiSiteList = uiMso.getSiteList();
            if (uiSiteList != null) {
                siteIds = new ArrayList<Integer>();
                for (UISite uiSite : uiSiteList) {
                    siteIds.add(uiSite.getId());
                }
            }
            try {
                this.msoManager.saveMSO(mso, siteIds);
            }
            catch (Exception e) {
                throw new NeptuneException(e.getMessage());
            }
        }
    }

    private MSO convertToMSO(UiMso uiMso) {
        MSO mso = new MSO();
        mso.setId(uiMso.getKey());
        mso.setMsoName(uiMso.getName());
        mso.setMsoDescription(uiMso.getDescription());
        return mso;
    }

    private UiMso convertToUiMso(MSO mso) {
        UiMso uiMso = new UiMso();
        uiMso.setKey(mso.getId());
        uiMso.setName(mso.getMsoName());
        uiMso.setDescription(mso.getMsoDescription());
        uiMso.setSiteList(this.getSiteList(mso.getMediaPathSiteSet()));
        return uiMso;
    }

    private Set<MediapathDistributionSite> getSites(List<UISite> uiSiteList) {
        HashSet<MediapathDistributionSite> siteList = new HashSet<MediapathDistributionSite>();
        if (uiSiteList != null) {
            for (UISite uiSite : uiSiteList) {
                MediapathDistributionSite site = new MediapathDistributionSite();
                site.setId(uiSite.getId());
                site.setName(uiSite.getName());
                siteList.add(site);
            }
        }
        return siteList;
    }

    private IMSOManager getMsoManager() {
        IMSOManager msoManager = (IMSOManager)ServiceLocator.getService((String)"MSOManager", IMSOManager.class);
        return msoManager;
    }

    private ISiteManager getSiteManager() {
        ISiteManager siteManager = (ISiteManager)ServiceLocator.getService((String)"SiteManager", ISiteManager.class);
        return siteManager;
    }

    private IRuleManager getRuleManager() {
        IRuleManager ruleManager = (IRuleManager)ServiceLocator.getService((String)"RuleManagerImpl", IRuleManager.class);
        return ruleManager;
    }

    @Override
    @Transactional
    public void deleteMsos(List<Integer> selectedIds) throws NeptuneException {
        List<Integer> list = selectedIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = MsoViewServiceImpl.class.getDeclaredMethod("deleteMsos", List.class).getAnnotation(Transactional.class);
        }
        MsoViewServiceImpl.deleteMsos_aroundBody3$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UiMso getMsoById(Integer uiMsoId) throws NeptuneException {
        Integer n = uiMsoId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = MsoViewServiceImpl.class.getDeclaredMethod("getMsoById", Integer.class).getAnnotation(Transactional.class);
        }
        return (UiMso)MsoViewServiceImpl.getMsoById_aroundBody5$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public List<UISite> getAllSites() throws NeptuneException {
        List<UISite> uiSiteList = this.convertToUiSites(this.siteManager.getAllDistributionSites());
        Collections.sort(uiSiteList);
        return uiSiteList;
    }

    private List<UISite> convertToUiSites(List<DistributionSite> allDistributionSites) {
        ArrayList<UISite> uiSiteList = new ArrayList<UISite>();
        if (allDistributionSites != null) {
            for (DistributionSite distributionSite : allDistributionSites) {
                if (!(distributionSite instanceof MediapathDistributionSite)) continue;
                UISite uiSite = new UISite();
                uiSite.setId(distributionSite.getId());
                uiSite.setName(distributionSite.getName());
                uiSiteList.add(uiSite);
            }
        }
        return uiSiteList;
    }

    @Override
    public List<UiMso> getMsoPresentInRules(List<Integer> msoIds) throws NeptuneException {
        ArrayList<UiMso> msosInRules = new ArrayList<UiMso>();
        for (Integer msoId : msoIds) {
            Collection ruleSet = this.ruleManager.getRuleSetsAssociatedMsos(msoId);
            if (ruleSet == null || ruleSet.isEmpty()) continue;
            UiMso ruleMso = new UiMso();
            ruleMso.setKey(msoId);
            msosInRules.add(ruleMso);
        }
        return msosInRules;
    }

    private static final /* synthetic */ List getAllMsos_aroundBody0(MsoViewServiceImpl ajc$this) {
        ArrayList<UiMso> uiMsoList = new ArrayList<UiMso>();
        List msoList = ajc$this.msoManager.getAllMSOs();
        if (msoList != null) {
            for (MSO mso : msoList) {
                UiMso uiMso = new UiMso();
                uiMso.setKey(mso.getId());
                uiMso.setName(mso.getMsoName());
                uiMso.setDescription(mso.getMsoDescription());
                uiMso.setSiteList(ajc$this.getSiteList(mso.getMediaPathSiteSet()));
                uiMsoList.add(uiMso);
            }
        }
        return uiMsoList;
    }

    private static final /* synthetic */ Object getAllMsos_aroundBody1$advice(MsoViewServiceImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MsoViewServiceImpl.getAllMsos_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = MsoViewServiceImpl.getAllMsos_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteMsos_aroundBody2(MsoViewServiceImpl ajc$this, List selectedIds) {
        for (Integer id : selectedIds) {
            MSO mso = new MSO();
            mso.setId(id);
            try {
                ajc$this.ruleManager.deleteMsoReference(mso.getId());
                ajc$this.msoManager.deleteMSO(mso);
            }
            catch (Exception e) {
                throw new NeptuneException(e.getMessage());
            }
        }
    }

    private static final /* synthetic */ Object deleteMsos_aroundBody3$advice(MsoViewServiceImpl ajc$this, List selectedIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            MsoViewServiceImpl.deleteMsos_aroundBody2(ajc$this, selectedIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            MsoViewServiceImpl.deleteMsos_aroundBody2(ajc$this, selectedIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiMso getMsoById_aroundBody4(MsoViewServiceImpl ajc$this, Integer uiMsoId) {
        UiMso convertedMso = null;
        if (uiMsoId != null) {
            try {
                MSO mso = ajc$this.msoManager.getMSOById(uiMsoId.intValue());
                convertedMso = ajc$this.convertToUiMso(mso);
            }
            catch (Exception e) {
                throw new NeptuneException(e.getMessage());
            }
        }
        return convertedMso;
    }

    private static final /* synthetic */ Object getMsoById_aroundBody5$advice(MsoViewServiceImpl ajc$this, Integer uiMsoId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MsoViewServiceImpl.getMsoById_aroundBody4(ajc$this, uiMsoId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiMso object = MsoViewServiceImpl.getMsoById_aroundBody4(ajc$this, uiMsoId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

