/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.ui.client.aggregatedview.IUIAgggregatedViewService;
import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCount;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCountItem;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteList;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteListItem;
import com.tandbergtv.cms.portal.ui.title.server.specification.TitleMetadataHelper;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class UIAgggregatedViewService
implements IUIAgggregatedViewService,
NeptuneRemoteService {
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private static final IPartnerUserManager parnterService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    @Override
    @Transactional
    public UIStatusCount getPagedStatusCount(int siteId, int startIndex, int pageSize, boolean isAscending) throws NeptuneException {
        int n = siteId;
        int n2 = startIndex;
        int n3 = pageSize;
        boolean bl = isAscending;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UIAgggregatedViewService.class.getDeclaredMethod("getPagedStatusCount", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (UIStatusCount)UIAgggregatedViewService.getPagedStatusCount_aroundBody1$advice(this, n, n2, n3, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UITitleSiteList getLocalTitleSiteList(int siteId, long masterTitleId, boolean isDistributionStatus, String statusType) throws NeptuneException {
        int n = siteId;
        long l = masterTitleId;
        boolean bl = isDistributionStatus;
        String string = statusType;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UIAgggregatedViewService.class.getDeclaredMethod("getLocalTitleSiteList", Integer.TYPE, Long.TYPE, Boolean.TYPE, String.class).getAnnotation(Transactional.class);
        }
        return (UITitleSiteList)UIAgggregatedViewService.getLocalTitleSiteList_aroundBody3$advice(this, n, l, bl, string, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<Long> getPartnerIds(List<Partner> partners) {
        ArrayList<Long> partnerIds = new ArrayList<Long>();
        for (Partner p : partners) {
            if (p.getType().equals((Object)PartnerType.SELF)) {
                partnerIds = new ArrayList();
                break;
            }
            partnerIds.add(p.getId());
        }
        return partnerIds;
    }

    public String getRelativePath() {
        return "service/sites/IUIAgggregatedViewService";
    }

    public Class<? extends UIAgggregatedViewService> getServiceImplementation() {
        return this.getClass();
    }

    private void setDistributionStatusCountForMasterTitle(Map<Long, UIStatusCountItem> itemLookup, Long masterTitleId, DistributionStatus ds, int count) {
        UIStatusCountItem item = itemLookup.get(masterTitleId);
        if (item == null) {
            item = new UIStatusCountItem();
            item.setTitleId(masterTitleId);
            item.setMetadata(this.getTitleMetadata(masterTitleId, UIStatusCountItem.METADATA_TABLE_NAME));
            itemLookup.put(masterTitleId, item);
        }
        this.setDistributionStatusCount(ds, item, count);
    }

    private void setTrackingStatusCountForMasterTitle(Map<Long, UIStatusCountItem> itemLookup, Long masterTitleId, TrackingStatus ts, int count) {
        UIStatusCountItem item = itemLookup.get(masterTitleId);
        if (item == null) {
            item = new UIStatusCountItem();
            item.setTitleId(masterTitleId);
            item.setMetadata(this.getTitleMetadata(masterTitleId, UIStatusCountItem.METADATA_TABLE_NAME));
            itemLookup.put(masterTitleId, item);
        }
        this.setTrackingStatusCount(ts, item, count);
    }

    private void setDistributionStatusCount(DistributionStatus ds, UIStatusCountItem item, int count) {
        switch (ds) {
            case TARGETED: {
                item.setDistStatusCount(DistributionStatus.TARGETED.name(), count);
                break;
            }
            case READY_FOR_DISTRIBUTION: {
                item.setDistStatusCount(DistributionStatus.READY_FOR_DISTRIBUTION.name(), count);
                break;
            }
            case IN_PROGRESS: {
                item.setDistStatusCount(DistributionStatus.IN_PROGRESS.name(), count);
                break;
            }
            case DISTRIBUTED: {
                item.setDistStatusCount(DistributionStatus.DISTRIBUTED.name(), count);
                break;
            }
            case FAILED: {
                item.setDistStatusCount(DistributionStatus.FAILED.name(), count);
            }
        }
    }

    private void setTrackingStatusCount(TrackingStatus ts, UIStatusCountItem item, int count) {
        switch (ts) {
            case TARGETED: {
                item.setTrackStatusCount(TrackingStatus.TARGETED.name(), count);
                break;
            }
            case DEPLOYMENT_IN_PROGRESS: {
                item.setTrackStatusCount(TrackingStatus.DEPLOYMENT_IN_PROGRESS.name(), count);
                break;
            }
            case DEPLOYMENT_FAILED: {
                item.setTrackStatusCount(TrackingStatus.DEPLOYMENT_FAILED.name(), count);
                break;
            }
            case DEPLOYED: {
                item.setTrackStatusCount(TrackingStatus.DEPLOYED.name(), count);
                break;
            }
            case NOT_DEPLOYED: {
                item.setTrackStatusCount(TrackingStatus.NOT_DEPLOYED.name(), count);
            }
        }
    }

    private void setLocalTitleDistributionSites(long masterTitleId, DistributionStatus status, List<DistributionSiteTitle> distSiteTitles, List<UITitleSiteListItem> itemList) {
        for (DistributionSiteTitle distSiteTitle : distSiteTitles) {
            if (masterTitleId != distSiteTitle.getTitle().getOriginalId() || status != distSiteTitle.getStatus()) continue;
            UITitleSiteListItem item = new UITitleSiteListItem();
            Long titleId = distSiteTitle.getTitle().getId();
            item.setLocalTitleId(titleId);
            item.setSiteName(distSiteTitle.getDistributionSite().getName());
            item.setMetadata(this.getTitleMetadata(titleId, UITitleSiteListItem.METADATA_TABLE_NAME));
            itemList.add(item);
        }
    }

    private void setLocalTitleTrackingSites(long masterTitleId, TrackingStatus status, List<TrackingSiteTitle> trackSiteTitles, List<UITitleSiteListItem> itemList) {
        for (TrackingSiteTitle trackSiteTitle : trackSiteTitles) {
            if (masterTitleId != trackSiteTitle.getTitle().getOriginalId() || status != trackSiteTitle.getStatus()) continue;
            UITitleSiteListItem item = new UITitleSiteListItem();
            Long titleId = trackSiteTitle.getTitle().getId();
            item.setLocalTitleId(titleId);
            item.setSiteName(trackSiteTitle.getTrackingSite().getName());
            item.setMetadata(this.getTitleMetadata(titleId, UITitleSiteListItem.METADATA_TABLE_NAME));
            itemList.add(item);
        }
    }

    private DistributionStatus getDistributionStatus(String type) {
        if (type.equalsIgnoreCase(DistributionStatus.TARGETED.name())) {
            return DistributionStatus.TARGETED;
        }
        if (type.equalsIgnoreCase(DistributionStatus.READY_FOR_DISTRIBUTION.name())) {
            return DistributionStatus.READY_FOR_DISTRIBUTION;
        }
        if (type.equalsIgnoreCase(DistributionStatus.IN_PROGRESS.name())) {
            return DistributionStatus.IN_PROGRESS;
        }
        if (type.equalsIgnoreCase(DistributionStatus.DISTRIBUTED.name())) {
            return DistributionStatus.DISTRIBUTED;
        }
        if (type.equalsIgnoreCase(DistributionStatus.FAILED.name())) {
            return DistributionStatus.FAILED;
        }
        return null;
    }

    private TrackingStatus getTrackingStatus(String type) {
        if (type.equalsIgnoreCase(TrackingStatus.TARGETED.name())) {
            return TrackingStatus.TARGETED;
        }
        if (type.equalsIgnoreCase(TrackingStatus.DEPLOYMENT_IN_PROGRESS.name())) {
            return TrackingStatus.DEPLOYMENT_IN_PROGRESS;
        }
        if (type.equalsIgnoreCase(TrackingStatus.DEPLOYMENT_FAILED.name())) {
            return TrackingStatus.DEPLOYMENT_FAILED;
        }
        if (type.equalsIgnoreCase(TrackingStatus.DEPLOYED.name())) {
            return TrackingStatus.DEPLOYED;
        }
        if (type.equalsIgnoreCase(TrackingStatus.NOT_DEPLOYED.name())) {
            return TrackingStatus.NOT_DEPLOYED;
        }
        return null;
    }

    private List<TitleMetadata> getTitleMetadata(long titleID, String tableName) {
        ArrayList<TitleMetadata> metadata = new ArrayList<TitleMetadata>();
        TitleMetadataHelper metadataHelper = new TitleMetadataHelper();
        List fields = metadataHelper.getMetadataByTitleID(titleID, tableName);
        int i = 0;
        while (i < fields.size()) {
            Field f = (Field)fields.get(i);
            String ttvXPath = f.getTtvXPath();
            String value = f.getValue();
            String assetType = "";
            if (f.getParentAsset() != null) {
                assetType = f.getParentAsset().getPath();
            }
            metadata.add(new TitleMetadata(ttvXPath, value, assetType));
            ++i;
        }
        return metadata;
    }

    private static final /* synthetic */ UIStatusCount getPagedStatusCount_aroundBody0(UIAgggregatedViewService ajc$this, int siteId, int startIndex, int pageSize, boolean isAscending) {
        Long count;
        Long masterTitleId;
        long endId;
        long startId;
        int size;
        List masterTitleIds;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        UIStatusCount statusCount = new UIStatusCount(siteId);
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.isEmpty()) {
            return statusCount;
        }
        List<Long> partnerIds = ajc$this.getPartnerIds(partners);
        Site site = ajc$this.siteManager.getSite(siteId);
        TreeMap<Long, UIStatusCountItem> itemLookup = new TreeMap<Long, UIStatusCountItem>();
        List aggDistStatusCounts = null;
        List aggTrackStatusCounts = null;
        int totalTitleCount = 0;
        if (site.getType() == SiteType.LOGICAL) {
            totalTitleCount = ajc$this.siteManager.getMasterTitleCountOfLogicalSite(siteId, partnerIds);
            if (totalTitleCount > 0 && (masterTitleIds = ajc$this.siteManager.getMasterTitleIdsOfLogicalSite(siteId, startIndex, pageSize, isAscending, partnerIds)) != null && masterTitleIds.size() > 0) {
                size = masterTitleIds.size();
                if (isAscending) {
                    startId = (Long)masterTitleIds.get(0);
                    endId = (Long)masterTitleIds.get(size - 1);
                } else {
                    endId = (Long)masterTitleIds.get(0);
                    startId = (Long)masterTitleIds.get(size - 1);
                }
                aggDistStatusCounts = ajc$this.siteManager.getAggDistStatusCountsOfLogicalSite(siteId, isAscending, startId, endId, partnerIds);
                aggTrackStatusCounts = ajc$this.siteManager.getAggTrackStatusCountsOfLogicalSite(siteId, isAscending, startId, endId, partnerIds);
            }
        } else if (site.getType() == SiteType.DISTRIBUTION && (totalTitleCount = ajc$this.siteManager.getMasterTitleCountOfDistributionSite(siteId, partnerIds)) > 0 && (masterTitleIds = ajc$this.siteManager.getMasterTitleIdsOfDistributionSite(siteId, startIndex, pageSize, isAscending, partnerIds)) != null && masterTitleIds.size() > 0) {
            size = masterTitleIds.size();
            if (isAscending) {
                startId = (Long)masterTitleIds.get(0);
                endId = (Long)masterTitleIds.get(size - 1);
            } else {
                endId = (Long)masterTitleIds.get(0);
                startId = (Long)masterTitleIds.get(size - 1);
            }
            aggDistStatusCounts = ajc$this.siteManager.getAggDistStatusCountsOfDistributionSite(siteId, isAscending, startId, endId, partnerIds);
            aggTrackStatusCounts = ajc$this.siteManager.getAggTrackStatusCountsOfDistributionSite(siteId, isAscending, startId, endId, partnerIds);
        }
        statusCount.setTotalCount(totalTitleCount);
        if (totalTitleCount == 0) {
            return statusCount;
        }
        for (List aggDistStatusCount : aggDistStatusCounts) {
            masterTitleId = (Long)aggDistStatusCount.get(0);
            DistributionStatus ds = (DistributionStatus)aggDistStatusCount.get(1);
            count = (Long)aggDistStatusCount.get(2);
            if (count == null) {
                count = 0L;
            }
            ajc$this.setDistributionStatusCountForMasterTitle(itemLookup, masterTitleId, ds, count.intValue());
        }
        for (List aggTrackStatusCount : aggTrackStatusCounts) {
            masterTitleId = (Long)aggTrackStatusCount.get(0);
            TrackingStatus ts = (TrackingStatus)aggTrackStatusCount.get(1);
            count = (Long)aggTrackStatusCount.get(2);
            if (count == null) {
                count = 0L;
            }
            ajc$this.setTrackingStatusCountForMasterTitle(itemLookup, masterTitleId, ts, count.intValue());
        }
        statusCount.setItems(new ArrayList<UIStatusCountItem>(itemLookup.values()));
        return statusCount;
    }

    private static final /* synthetic */ Object getPagedStatusCount_aroundBody1$advice(UIAgggregatedViewService ajc$this, int siteId, int startIndex, int pageSize, boolean isAscending, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UIAgggregatedViewService.getPagedStatusCount_aroundBody0(ajc$this, siteId, startIndex, pageSize, isAscending);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UIStatusCount object = UIAgggregatedViewService.getPagedStatusCount_aroundBody0(ajc$this, siteId, startIndex, pageSize, isAscending);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UITitleSiteList getLocalTitleSiteList_aroundBody2(UIAgggregatedViewService ajc$this, int siteId, long masterTitleId, boolean isDistributionStatus, String statusType) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        UITitleSiteList titleSiteList = new UITitleSiteList(siteId);
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.isEmpty()) {
            return titleSiteList;
        }
        List<Long> partnerIds = ajc$this.getPartnerIds(partners);
        Site site = ajc$this.siteManager.getSite(siteId);
        List<DistributionSiteTitle> distSiteTitles = new ArrayList();
        if (site.getType() == SiteType.LOGICAL) {
            distSiteTitles = ajc$this.siteManager.getDistributionSiteTitlesOfLogicalSite(siteId, partnerIds);
        } else if (site.getType() == SiteType.DISTRIBUTION) {
            distSiteTitles = ajc$this.siteManager.getDistributionSiteTitles(siteId, partnerIds);
        } else {
            return titleSiteList;
        }
        ArrayList<UITitleSiteListItem> items = new ArrayList<UITitleSiteListItem>();
        if (isDistributionStatus) {
            DistributionStatus status = ajc$this.getDistributionStatus(statusType);
            ajc$this.setLocalTitleDistributionSites(masterTitleId, status, distSiteTitles, items);
        } else {
            TrackingStatus status = ajc$this.getTrackingStatus(statusType);
            for (DistributionSiteTitle distSiteTitle : distSiteTitles) {
                List trackSiteTitles = ajc$this.siteManager.getTrackingSiteTitles(distSiteTitle.getTitle().getId().longValue());
                ajc$this.setLocalTitleTrackingSites(masterTitleId, status, trackSiteTitles, items);
            }
        }
        titleSiteList.setItems(items);
        return titleSiteList;
    }

    private static final /* synthetic */ Object getLocalTitleSiteList_aroundBody3$advice(UIAgggregatedViewService ajc$this, int siteId, long masterTitleId, boolean isDistributionStatus, String statusType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UIAgggregatedViewService.getLocalTitleSiteList_aroundBody2(ajc$this, siteId, masterTitleId, isDistributionStatus, statusType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UITitleSiteList object = UIAgggregatedViewService.getLocalTitleSiteList_aroundBody2(ajc$this, siteId, masterTitleId, isDistributionStatus, statusType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

