/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverride;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesRequest;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesResponse;
import com.ericsson.cms.sites.core.mediapath.IMSOOverridesManager;
import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesRequest;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesResponse;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.server.util.MetadataTreeConverter;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.cms.portal.ui.title.server.msooverrides.DisplayNameLookup;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class UIMSOOverridesService
implements IUIMSOOverridesService,
NeptuneRemoteService {
    private static final String FIELD_DISPLAY_NAME_COLUMN = "fieldDisplayName";
    private IMSOOverridesManager msoOverridesManager = (IMSOOverridesManager)InjectionUtil.injectInstance((String)"cms/MSOOverridesManager/local", IMSOOverridesManager.class);
    private ISpecificationManager specMgr = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    static final Comparator<UIMSOOverride> FIELD_NAME_COMPARATOR = new Comparator<UIMSOOverride>(){

        @Override
        public int compare(UIMSOOverride ovrd1, UIMSOOverride ovrd2) {
            return ovrd2.getFieldName().compareTo(ovrd1.getFieldName());
        }
    };

    public String getRelativePath() {
        return "service/sites/IUIMSOOverridesService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UIMSO> getMSOs(int siteId) {
        ArrayList<UIMSO> uiMSOs = new ArrayList();
        List msos = this.msoOverridesManager.getMSOs(siteId);
        uiMSOs = this.convertMSOs(msos);
        return uiMSOs;
    }

    @Override
    public UIMSO saveMSO(int siteId, UIMSO uiMSO) throws NeptuneException {
        UIMSO savedUIMSO = null;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        if (uiMSO != null) {
            MSO mso = this.convertUIMSO(uiMSO);
            MSO savedMSO = this.msoOverridesManager.saveMSO(siteId, mso);
            savedUIMSO = this.convertMSO(savedMSO);
        }
        return savedUIMSO;
    }

    @Override
    public Boolean isMSONameAlreadyUsed(int siteId, String msoName) throws NeptuneException {
        boolean isMSONameAlreadyUsed = false;
        isMSONameAlreadyUsed = this.msoOverridesManager.isMSONameAlreadyUsed(siteId, msoName);
        return isMSONameAlreadyUsed;
    }

    @Override
    public void deleteMSO(int msoId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        try {
            this.msoOverridesManager.deleteMSO(msoId);
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public UIMSOOverridesResponse getMSOOverrides(UIMSOOverridesRequest uiMSOOverridesRequest) throws NeptuneException {
        UIMSOOverridesResponse uiMSOOverridesResponse = null;
        if (uiMSOOverridesRequest != null) {
            MSOOverridesRequest msoOverridesRequest = this.convert(uiMSOOverridesRequest);
            MSOOverridesResponse msoOverridesResponse = this.msoOverridesManager.getMSOOverrides(msoOverridesRequest);
            uiMSOOverridesResponse = this.convert(msoOverridesResponse);
            String sortColumnName = uiMSOOverridesRequest.getSortColumnName();
            boolean isAscending = uiMSOOverridesRequest.isAscending();
            if (FIELD_DISPLAY_NAME_COLUMN.equals(sortColumnName)) {
                int numMSOOverrides;
                int fromIndex;
                int toIndex;
                List<UIMSOOverride> uiMSOOverrides = uiMSOOverridesResponse.getUiMSOOverrides();
                Comparator<UIMSOOverride> comparatorUIMSOOverride = FIELD_NAME_COMPARATOR;
                Collections.sort(uiMSOOverrides, comparatorUIMSOOverride);
                if (isAscending) {
                    Collections.reverse(uiMSOOverrides);
                }
                if ((toIndex = (fromIndex = msoOverridesRequest.getStartIndex()) + msoOverridesRequest.getNumRecords()) > (numMSOOverrides = uiMSOOverrides.size())) {
                    toIndex = numMSOOverrides;
                }
                ArrayList<UIMSOOverride> paginatedUIMSOOverrides = new ArrayList<UIMSOOverride>(uiMSOOverrides.subList(fromIndex, toIndex));
                uiMSOOverridesResponse.setUiMSOOverrides(paginatedUIMSOOverrides);
            }
        }
        return uiMSOOverridesResponse;
    }

    @Override
    public void saveMSOOverrides(int msoId, List<UIMSOOverride> uiMSOOverrides) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        if (uiMSOOverrides != null && uiMSOOverrides.size() > 0) {
            ArrayList<MSOOverride> msoOverrides = new ArrayList<MSOOverride>();
            for (UIMSOOverride uiMSOOverride : uiMSOOverrides) {
                MSOOverride msoOverride = this.convertUIMSOOverride(uiMSOOverride);
                msoOverrides.add(msoOverride);
            }
            this.msoOverridesManager.saveMSOOverrides(msoId, msoOverrides);
        }
    }

    @Override
    public void deleteMSOOverrides(Set<Long> overrideIds) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        this.msoOverridesManager.deleteMSOOverrides(overrideIds);
    }

    @Override
    public UiMetadataTree getMetadataFieldsTree() throws NeptuneException {
        UiMetadataTree uiMetadataTree = null;
        UISpecification uiSpecification = this.specMgr.getUISpecification(UISpecification.Type.PACKAGE);
        Set msoOverridableFields = this.msoOverridesManager.getMSOOverridableFields();
        MetadataTreeConverter metadataTreeConverter = new MetadataTreeConverter();
        uiMetadataTree = metadataTreeConverter.convert(uiSpecification, msoOverridableFields);
        return uiMetadataTree;
    }

    private List<UIMSO> convertMSOs(List<MSO> msos) {
        ArrayList<UIMSO> uiMsos = new ArrayList<UIMSO>();
        for (MSO mso : msos) {
            UIMSO uiMSO = this.convertMSO(mso);
            uiMsos.add(uiMSO);
        }
        return uiMsos;
    }

    private UIMSO convertMSO(MSO mso) {
        UIMSO uiMSO = null;
        if (mso != null) {
            uiMSO = new UIMSO();
            uiMSO.setMsoId(mso.getId());
            uiMSO.setMsoName(mso.getMsoName());
        }
        return uiMSO;
    }

    private UIMSOOverride convertMSOOverride(MSOOverride msoOverride) {
        UIMSOOverride uiMSOOverride = null;
        if (msoOverride != null) {
            uiMSOOverride = new UIMSOOverride();
            uiMSOOverride.setOverrideId(msoOverride.getId());
            uiMSOOverride.setFieldXPath(msoOverride.getFieldXPath());
            uiMSOOverride.setSearchValue(msoOverride.getSearchValue());
            uiMSOOverride.setReplacementValue(msoOverride.getReplacementValue());
            uiMSOOverride.setFieldName(DisplayNameLookup.getFieldDisplayName((String)msoOverride.getFieldXPath()));
        }
        return uiMSOOverride;
    }

    private MSO convertUIMSO(UIMSO uiMSO) {
        MSO mso = null;
        if (uiMSO != null) {
            mso = new MSO();
            mso.setId(uiMSO.getMsoId());
            mso.setMsoName(uiMSO.getMsoName());
        }
        return mso;
    }

    private MSOOverride convertUIMSOOverride(UIMSOOverride uiMSOOverride) {
        MSOOverride msoOverride = null;
        if (uiMSOOverride != null) {
            msoOverride = new MSOOverride();
            msoOverride.setId(uiMSOOverride.getOverrideId());
            msoOverride.setFieldXPath(uiMSOOverride.getFieldXPath());
            msoOverride.setReplacementValue(uiMSOOverride.getReplacementValue());
            msoOverride.setSearchValue(uiMSOOverride.getSearchValue());
        }
        return msoOverride;
    }

    private MSOOverridesRequest convert(UIMSOOverridesRequest uiMSOOverridesRequest) {
        MSOOverridesRequest msoOverridesRequest = null;
        if (uiMSOOverridesRequest != null) {
            msoOverridesRequest = new MSOOverridesRequest();
            msoOverridesRequest.setMsoId(uiMSOOverridesRequest.getMsoId());
            msoOverridesRequest.setStartIndex(uiMSOOverridesRequest.getStartIndex());
            msoOverridesRequest.setNumRecords(uiMSOOverridesRequest.getNumRecords());
            msoOverridesRequest.setSortColumnName(uiMSOOverridesRequest.getSortColumnName());
            msoOverridesRequest.setAscending(uiMSOOverridesRequest.isAscending());
        }
        return msoOverridesRequest;
    }

    private UIMSOOverridesResponse convert(MSOOverridesResponse msoOverridesResponse) {
        UIMSOOverridesResponse uiMSOOverridesResponse = null;
        if (msoOverridesResponse != null) {
            uiMSOOverridesResponse = new UIMSOOverridesResponse();
            uiMSOOverridesResponse.setCount(msoOverridesResponse.getCount());
            List msoOverrides = msoOverridesResponse.getMSOOverrides();
            if (msoOverrides != null) {
                ArrayList<UIMSOOverride> uiMSOOverrides = new ArrayList<UIMSOOverride>();
                for (MSOOverride msoOverride : msoOverrides) {
                    UIMSOOverride uiMSOOverride = this.convertMSOOverride(msoOverride);
                    uiMSOOverrides.add(uiMSOOverride);
                }
                uiMSOOverridesResponse.setUiMSOOverrides(uiMSOOverrides);
            }
        }
        return uiMSOOverridesResponse;
    }
}

