/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.sites.core.CISPersistenceException;
import com.ericsson.cms.sites.core.ICISPersistenceManager;
import com.ericsson.cms.sites.core.entities.CISNotificationData;
import com.ericsson.cms.sites.core.entities.CISNotificationType;
import com.ericsson.cms.sites.ui.client.IUISiteCISService;
import com.ericsson.cms.sites.ui.client.entities.UICISMode;
import com.ericsson.cms.sites.ui.client.entities.UICISNotification;
import com.ericsson.cms.sites.ui.client.entities.UICISNotificationType;
import com.ericsson.cms.sites.ui.client.entities.UISiteCIS;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class UISiteCISService
implements IUISiteCISService,
NeptuneRemoteService {
    private static final String CL_3_0 = "CL3_0";
    private static final String CL_3_0_I02 = "CL3_0_I02";
    private static final String DST_METADATA_PLUGIN_MAP = "dstMetadataPluginMap";
    private Map<String, String> dstMetadataPluginMap;
    private static final String SAMPLE_QUERY_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Query xmlns=\"http://www.scte.org/schemas/130-8/2011/gis\" xmlns:ns2=\"http://www.scte.org/schemas/130-2/2008a/core\" xmlns:ns3=\"http://www.scte.org/schemas/130-4/2011/cis\" expandOutput=\"true\" resultSetSizeOnly=\"true\" queryId=\"query_id\"><ServiceDataModel>CLVOD_3.0/SCTE/V1</ServiceDataModel><BasicQueryFilter><BasicFilterElement name=\"/Fields/ProviderInfo/Identifier/Id\" value=\"\" valueIsRegex=\"false\"/></BasicQueryFilter></Query>";
    private IClusterService hzcs;
    private HazelcastInstance haz;
    ICISPersistenceManager siteCISManager = (ICISPersistenceManager)InjectionUtil.injectInstance((String)"/cms/CISPersistenceManager/local", ICISPersistenceManager.class);

    @Override
    public List<UICISNotification> getSiteCIS(int siteId) throws NeptuneException {
        ArrayList<UICISNotification> uiCISNotificationList = new ArrayList<UICISNotification>();
        try {
            List cisNotifications = this.siteCISManager.get(Integer.valueOf(siteId));
            for (CISNotificationData cisNotification : cisNotifications) {
                String cmsIdentity = cisNotification.getCmsIdentity();
                String cmsSystemId = cisNotification.getCmsSystemId();
                UICISNotification uiCisNotification = new UICISNotification(cisNotification.getIdentity(), cmsIdentity, cmsSystemId, cisNotification.getMessageId(), cisNotification.getCallOutURLs(), cisNotification.getQuery(), UICISNotificationType.valueOf(cisNotification.getNotificationType().name()));
                uiCISNotificationList.add(uiCisNotification);
            }
        }
        catch (CISPersistenceException | UnsupportedEncodingException e) {
            throw new NeptuneException("Cannot get Site CIS. Error: " + e.getMessage());
        }
        return uiCISNotificationList;
    }

    @Override
    public void deleteNotificationItems(List<UICISNotification> selectedIds) throws NeptuneException {
        for (UICISNotification notificaton : selectedIds) {
            try {
                this.siteCISManager.delete(notificaton.getIdentify(), notificaton.getMessageId());
            }
            catch (CISPersistenceException cISPersistenceException) {
                throw new NeptuneException("Cannot delete Site CIS with Identity " + notificaton.getIdentify() + "and Message UID " + notificaton.getMessageId());
            }
        }
    }

    @Override
    public Set<String> validate(UISiteCIS cis) {
        HashSet<String> errors = new HashSet<String>();
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        this.haz = this.hzcs.getInstance();
        this.dstMetadataPluginMap = this.haz.getMap(DST_METADATA_PLUGIN_MAP);
        if (cis.getCisMode() != null) {
            if (cis.getCisMode().name().equals(UICISMode.STDADI30.name()) && this.dstMetadataPluginMap.get(CL_3_0) == null) {
                errors.add("errorRequiredPluginNotExist");
            }
            if (cis.getCisMode().name().equals(UICISMode.BLACKARROWADI30.name()) && this.dstMetadataPluginMap.get(CL_3_0_I02) == null) {
                errors.add("errorRequiredPluginNotExist");
            }
        }
        return errors;
    }

    @Override
    public void createNotificationItem(Integer siteId, UICISNotification notificaton) throws NeptuneException {
        try {
            CISNotificationData cisNotification = new CISNotificationData();
            cisNotification.setSiteId(siteId);
            cisNotification.setIdentity(notificaton.getIdentify());
            cisNotification.setMessageId(UUID.randomUUID().toString());
            cisNotification.setNotificationType(CISNotificationType.valueOf((String)notificaton.getType().name()));
            cisNotification.setCallOutURLs(notificaton.getUrls());
            cisNotification.setQuery(SAMPLE_QUERY_XML);
            cisNotification.setCmsSystemId(notificaton.getCmsSystemId());
            cisNotification.setCmsIdentity(notificaton.getCmsIdentity());
            this.siteCISManager.save(cisNotification);
        }
        catch (CISPersistenceException | UnsupportedEncodingException throwable) {
            throw new NeptuneException("Cannot save Site CIS with Identity " + notificaton.getIdentify());
        }
    }

    public String getRelativePath() {
        return "service/sites/IUISiteCISService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

