/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.entities.PitchSchedule;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.ui.client.IUISitePartnerService;
import com.ericsson.cms.sites.ui.client.entities.Date;
import com.ericsson.cms.sites.ui.client.entities.ScheduleTabInitData;
import com.ericsson.cms.sites.ui.client.entities.SchedulesCalendarData;
import com.ericsson.cms.sites.ui.client.entities.UISchedule;
import com.ericsson.cms.sites.ui.client.entities.UISitePartner;
import com.ericsson.cms.sites.ui.server.util.SitePartnerUtils;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UISitePartnerService
implements IUISitePartnerService,
NeptuneRemoteService {
    private ISitePartnerManager service = (ISitePartnerManager)InjectionUtil.injectInstance((String)"cms/SitePartnerManager/local", ISitePartnerManager.class);

    public String getRelativePath() {
        return "service/sites/IUISitePartnerService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UISitePartner getSitePartner(int id) throws NeptuneException {
        return SitePartnerUtils.convert(this.service.get(id));
    }

    @Override
    public Set<String> validate(UISitePartner uisp) {
        HashSet<String> errors = new HashSet<String>();
        if (uisp != null) {
            SitePartner sp;
            if (!this.isBlank(uisp.getProviderId()) && (sp = this.service.getByProviderId(uisp.getProviderId())) != null && sp.getContextId() != uisp.getContextId()) {
                errors.add("errorDuplicateProviderId");
            }
            if (!this.isBlank(uisp.getLookupKey()) && (sp = this.service.getByLookupKey(uisp.getLookupKey())) != null && sp.getContextId() != uisp.getContextId()) {
                errors.add("errorDuplicateLookupKey");
            }
        }
        return errors;
    }

    @Override
    public void update(UISitePartner partner) throws NeptuneException {
        this.service.update(SitePartnerUtils.convert(partner));
    }

    @Override
    public ScheduleTabInitData getScheduleTabInitData(int siteId) throws NeptuneException {
        ScheduleTabInitData data = new ScheduleTabInitData();
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        date.setDate(cal.get(5));
        date.setMonth(cal.get(2));
        date.setYear(cal.get(1));
        data.setDate(date);
        data.setContextId(this.service.get(siteId).getContextId());
        return data;
    }

    @Override
    public SchedulesCalendarData getSchedulesCalendar(int siteId, int month, int year) throws NeptuneException {
        SchedulesCalendarData data = new SchedulesCalendarData();
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1);
        data.setBeginningDay(cal.get(7));
        data.setNumDays(cal.getActualMaximum(5));
        List schedules = this.service.getSchedulesForSite(siteId, month, year);
        for (PitchSchedule s : schedules) {
            cal.setTime(s.getPitchDate());
            int date = cal.get(5);
            data.add(date, new UISchedule(s.getId(), s.isError()));
        }
        return data;
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

