/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduling.ui.client.data.UIJob;
import com.ericsson.cms.scheduling.ui.client.data.UiMetadataTree;
import com.ericsson.cms.scheduling.ui.server.MetadataTreeConvertor;
import com.ericsson.cms.scheduling.ui.server.ScheduleConvertor;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.ActionOnFailureOption;
import com.ericsson.cms.sites.core.entities.CISMode;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.DistributionStatusDetail;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteActivity;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.dependency.ISitesDepCacheService;
import com.ericsson.cms.sites.distribution.ISitesActivityService;
import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.ericsson.cms.sites.distribution.TemplateVariable;
import com.ericsson.cms.sites.distribution.TemplateVariableDataType;
import com.ericsson.cms.sites.export.ExportPlugin;
import com.ericsson.cms.sites.export.ISiteExportManager;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPlugin;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPluginManager;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.TargetedTitleQuickSearchException;
import com.ericsson.cms.sites.ui.client.UiRuleSetsAssocWJobExpception;
import com.ericsson.cms.sites.ui.client.UiRuleSetsNotAssocWSiteExpception;
import com.ericsson.cms.sites.ui.client.UiSortColumnType;
import com.ericsson.cms.sites.ui.client.UiTargetedTitlesRequest;
import com.ericsson.cms.sites.ui.client.entities.DistributeTitlesResponse;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTable;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTables;
import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UIActionOnFailureOption;
import com.ericsson.cms.sites.ui.client.entities.UICISMode;
import com.ericsson.cms.sites.ui.client.entities.UIDistributionOption;
import com.ericsson.cms.sites.ui.client.entities.UIExportPluginInfo;
import com.ericsson.cms.sites.ui.client.entities.UIResourceGroup;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISitePartner;
import com.ericsson.cms.sites.ui.client.entities.UISiteTitleStatusData;
import com.ericsson.cms.sites.ui.client.entities.UISiteTitleStatusRecord;
import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.entities.UIStatusPluginType;
import com.ericsson.cms.sites.ui.client.entities.UITemplateInfo;
import com.ericsson.cms.sites.ui.client.entities.UITemplateVariable;
import com.ericsson.cms.sites.ui.client.entities.UITemplateVariableDataType;
import com.ericsson.cms.sites.ui.server.util.SitePartnerUtils;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.server.title.TitleSearchServiceImpl;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.RuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.service.category.RuleSetsNotAssocWSiteExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.ResourceGroups;
import com.tandbergtv.workflow.api.Templates;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.TemplateListResponse;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class UISiteService
implements IUISiteService,
NeptuneRemoteService {
    private static final String SITES_ACTIVITY_TABLE_NAME = "sitesActivityColumns";
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private ISitesActivityService sitesActivityService = (ISitesActivityService)InjectionUtil.injectInstance((String)"cms/SitesActivityService/local", ISitesActivityService.class);
    private ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"cms/SitePartnerManager/local", ISitePartnerManager.class);
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private IStatusPluginManager statusPluginManager = (IStatusPluginManager)InjectionUtil.injectInstance((String)"cms/StatusPluginManager/local", IStatusPluginManager.class);
    private ISiteExportManager exportManager = (ISiteExportManager)InjectionUtil.injectInstance((String)"cms/SiteExportManager/local", ISiteExportManager.class);
    private static final IPartnerUserManager parnterService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    private IWOScheduler woScheduler = (IWOScheduler)InjectionUtil.injectInstance((String)"cms/WOScheduler/local", IWOScheduler.class);
    private ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat sitesActivitySearchDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static String TITLE_DELETE_PERMISSION = "AssetManagement_Delete";
    private static String RUN_TEMPLATE_PERMISSION = "WorkOrderManagement_Create";
    private static String WORKORDER_VIEW_PERMISSION = "WorkOrderManagement_View";
    private static String RESOURCE_VIEW_PERMISSION = "ResourceManagement_View";
    private static final Logger logger = Logger.getLogger(UISiteService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;

    public String getRelativePath() {
        return "service/sites/IUISiteService";
    }

    public Class<? extends UISiteService> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public List<UISiteTreeNode> getSiteTree() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UISiteService.class.getDeclaredMethod("getSiteTree", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)UISiteService.getSiteTree_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UISite> getAllSites() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UISiteService.class.getDeclaredMethod("getAllSites", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)UISiteService.getAllSites_aroundBody3$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UISite> getAllDistributionSites() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = UISiteService.class.getDeclaredMethod("getAllDistributionSites", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)UISiteService.getAllDistributionSites_aroundBody5$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UISite> getAllTrackingSites(Integer parentDistSiteId) throws NeptuneException {
        Integer n = parentDistSiteId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = UISiteService.class.getDeclaredMethod("getAllTrackingSites", Integer.class).getAnnotation(Transactional.class);
        }
        return (List)UISiteService.getAllTrackingSites_aroundBody7$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UISite> getShareableTrackingSites(int distributionSiteId) throws NeptuneException {
        int n = distributionSiteId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = UISiteService.class.getDeclaredMethod("getShareableTrackingSites", Integer.TYPE).getAnnotation(Transactional.class);
        }
        return (List)UISiteService.getShareableTrackingSites_aroundBody9$advice(this, n, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public UISite getNew() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View", "Sites_Create"});
        UISite uiSite = new UISite();
        this.fillAllLists(uiSite);
        return uiSite;
    }

    @Override
    @Transactional
    public UISite get(int siteId, Integer parentSiteId) throws NeptuneException {
        int n = siteId;
        Integer n2 = parentSiteId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = UISiteService.class.getDeclaredMethod("get", Integer.TYPE, Integer.class).getAnnotation(Transactional.class);
        }
        return (UISite)UISiteService.get_aroundBody11$advice(this, n, n2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UISite save(UISite uiSite) throws NeptuneException {
        UISite uISite = uiSite;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = UISiteService.class.getDeclaredMethod("save", UISite.class).getAnnotation(Transactional.class);
        }
        return (UISite)UISiteService.save_aroundBody13$advice(this, uISite, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public void delete(int siteId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Delete"});
        try {
            Site site = this.siteManager.getSite(siteId);
            this.siteManager.delete(siteId);
            if (site.getType() == SiteType.DISTRIBUTION || site.getType() == SiteType.LOGICAL) {
                this.sitesDepSvc.NotifyCluster();
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof SiteManagementException) {
                throw new NeptuneException(e.getCause().getLocalizedMessage());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public void activate(int siteId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        try {
            this.siteManager.activate(siteId);
            this.notifyCluster(siteId);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof SiteManagementException) {
                throw new NeptuneException(e.getCause().getLocalizedMessage());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public void inactivate(int siteId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        try {
            this.siteManager.inactivate(siteId);
            this.notifyCluster(siteId);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof SiteManagementException) {
                throw new NeptuneException(e.getCause().getLocalizedMessage());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private void notifyCluster(int siteId) {
        Site site = this.siteManager.getSite(siteId);
        if (site.getType() == SiteType.DISTRIBUTION || site.getType() == SiteType.LOGICAL) {
            this.sitesDepSvc.NotifyCluster();
        }
    }

    @Override
    public String export(int siteId, List<UIDistributionStatus> uiStatuses) throws NeptuneException {
        try {
            return this.exportManager.exportTitles(siteId, this.convertToDistributionStatusList(uiStatuses));
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof SiteManagementException) {
                throw new NeptuneException(e.getCause().getLocalizedMessage());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public void associateTrackingSites(Set<Integer> trackingSiteIds, int distributionSiteId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        this.siteManager.associateTrackingSites(trackingSiteIds, distributionSiteId);
    }

    @Override
    public void dissociateTrackingSite(int trackingSiteId, int distributionSiteId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        this.siteManager.dissociateTrackingSite(trackingSiteId, distributionSiteId);
    }

    private List<String> getAllMetadataFormats() {
        ArrayList<String> list = new ArrayList<String>();
        Collection specs = this.specManager.getSpecsWithFromTTVTranslator();
        if (specs != null) {
            for (Specification spec : specs) {
                list.add(spec.getName());
            }
        }
        return list;
    }

    private List<String> getAllFileLookupKeys() throws NeptuneException {
        return this.specManager.getAllLookupKeys();
    }

    @Override
    public List<UIRuleListItem> getRuleSetsBySiteAndPackage(int siteId, Packages packageType) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        ArrayList<UIRuleListItem> result = new ArrayList<UIRuleListItem>();
        List ruleSets = this.getRuleManager().getRuleSetBySitePackage(Integer.valueOf(siteId), packageType.toString());
        if (ruleSets != null) {
            for (TreRuleSet ruleSet : ruleSets) {
                int id = ruleSet.getRuleSetId();
                String name = ruleSet.getRuleName();
                boolean enabled = ruleSet.getEnabled();
                String updateDate = this.dateFormatter.format(ruleSet.getUpdateDate());
                String uuid = ruleSet.getUuid() != null ? ruleSet.getUuid().toString() : "";
                result.add(new UIRuleListItem(id, name, enabled, null, updateDate, uuid));
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void dissociateRuleSets(int siteId, List<Integer> ruleSetIds) throws NeptuneException {
        block8: {
            block9: {
                NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
                if (ruleSetIds == null) {
                    throw new NeptuneException("ruleSetIds cannot be null");
                }
                try {
                    this.dissociateHelper(siteId, ruleSetIds);
                    break block8;
                }
                catch (RuntimeException re) {
                    if (!(re.getCause().getCause() instanceof RuleSetsNotAssocWSiteExpception)) break block9;
                    e = (RuleSetsNotAssocWSiteExpception)re.getCause().getCause();
                    sb = new StringBuffer();
                    iterator = e.getRuleSets().iterator();
                    ** while (iterator.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    id = (Integer)iterator.next();
                    sb.append(id);
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                    continue;
                }
lbl20:
                // 1 sources

                throw new UiRuleSetsNotAssocWSiteExpception(sb.toString());
            }
            if (re.getCause().getCause() instanceof RuleSetsAssocWJobExpception) {
                e = (RuleSetsAssocWJobExpception)re.getCause().getCause();
                issues = new ArrayList<UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc>();
                for (RuleSetsAssocWJobExpception.RuleSetJobsAssoc issue : e.getIssues()) {
                    sb = new StringBuilder();
                    for (String jobName : issue.getJobNames()) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(jobName);
                    }
                    issues.add(new UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc(String.valueOf(issue.getRuleSetId()), sb.toString()));
                }
                throw new UiRuleSetsAssocWJobExpception(issues);
            }
            throw re;
        }
    }

    @Transactional
    private void dissociateHelper(int siteId, List<Integer> ruleSetIds) {
        int n = siteId;
        List<Integer> list = ruleSetIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = UISiteService.class.getDeclaredMethod("dissociateHelper", Integer.TYPE, List.class).getAnnotation(Transactional.class);
        }
        UISiteService.dissociateHelper_aroundBody15$advice(this, n, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private Collection<UIResourceGroup> getUIGroups(Collection<ResourceGroup> rgs) {
        ArrayList<UIResourceGroup> uiGroups = new ArrayList<UIResourceGroup>();
        if (rgs != null) {
            for (ResourceGroup group : rgs) {
                UIResourceGroup uiGroup = new UIResourceGroup();
                uiGroup.setGroupId(Long.valueOf(group.getId()));
                uiGroup.setGroupName(group.getName());
                uiGroups.add(uiGroup);
            }
        }
        return uiGroups;
    }

    @Override
    public Map<Long, String> getResourcesInGroup(String resourceGroupName) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View", RESOURCE_VIEW_PERMISSION});
        HashMap<Long, String> result = new HashMap<Long, String>();
        try {
            for (Resource resource : this.getResourcesList(resourceGroupName)) {
                result.put(Long.valueOf(resource.getId()), resource.getName());
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to get resources for group: " + resourceGroupName), (Throwable)e);
        }
        return result;
    }

    private List<UITemplateInfo> getAllTemplatesInfo() {
        ArrayList<UITemplateInfo> uiTemplatesInfo = new ArrayList<UITemplateInfo>();
        Set templatesInfo = this.siteManager.getDistributionTemplatesInfo();
        if (templatesInfo != null) {
            for (TemplateInfo templateInfo : templatesInfo) {
                UITemplateInfo uiTemplateInfo = new UITemplateInfo();
                uiTemplateInfo.setTemplateName(templateInfo.getTemplateName());
                uiTemplateInfo.setTemplateId(templateInfo.getTemplateId());
                Map requiredVariables = templateInfo.getRequiredVariables();
                if (requiredVariables != null) {
                    for (Map.Entry requiredVariable : requiredVariables.entrySet()) {
                        String variableName = (String)requiredVariable.getKey();
                        TemplateVariable templateVariable = (TemplateVariable)requiredVariable.getValue();
                        String mappedName = templateVariable.getMappedName();
                        TemplateVariableDataType templateVariableDataType = templateVariable.getDataType();
                        UITemplateVariable uiTemplateVariable = new UITemplateVariable();
                        uiTemplateVariable.setMappedName(mappedName);
                        if (templateVariableDataType != null) {
                            uiTemplateVariable.setDataType(UITemplateVariableDataType.valueOf(templateVariableDataType.toString()));
                        }
                        uiTemplateInfo.addRequiredVariable(variableName, uiTemplateVariable);
                    }
                }
                uiTemplatesInfo.add(uiTemplateInfo);
            }
        }
        return uiTemplatesInfo;
    }

    private List<UIExportPluginInfo> getAllExportPluginsInfo() {
        ArrayList<UIExportPluginInfo> pluginsInfo = new ArrayList<UIExportPluginInfo>();
        Set plugins = this.exportManager.getAllPlugins();
        if (plugins != null) {
            for (ExportPlugin plugin : plugins) {
                pluginsInfo.add(new UIExportPluginInfo(plugin.getName(), plugin.getParamNames()));
            }
        }
        return pluginsInfo;
    }

    @Override
    public List<UIStatusPlugin> getStatusPlugins(UIStatusPluginType uiStatusPluginType) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        ArrayList<UIStatusPlugin> uiStatusPlugins = new ArrayList<UIStatusPlugin>();
        UIStatusPlugin blankUiStatusPlugin = this.getBlankUiStatusPlugin(uiStatusPluginType);
        uiStatusPlugins.add(blankUiStatusPlugin);
        StatusPluginType statusPluginType = StatusPluginType.valueOf((String)uiStatusPluginType.name());
        Collection statusPlugins = this.statusPluginManager.getPlugins(statusPluginType);
        for (IStatusPlugin statusPlugin : statusPlugins) {
            uiStatusPlugins.addAll(this.convertToUIStatusPlugins(statusPlugin));
        }
        return uiStatusPlugins;
    }

    @Override
    public UIStatusPlugin getAssociatedPluginForSite(int siteId, UIStatusPluginType uiStatusPluginType) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        UIStatusPlugin uiStatusPlugin = null;
        StatusPluginType statusPluginType = StatusPluginType.valueOf((String)uiStatusPluginType.name());
        IStatusPlugin statusPlugin = this.statusPluginManager.getAssociatedPluginForSite(Integer.valueOf(siteId), statusPluginType);
        if (statusPlugin != null) {
            uiStatusPlugin = this.convertToUIStatusPlugin(statusPlugin);
        }
        if (uiStatusPlugin == null) {
            uiStatusPlugin = this.getBlankUiStatusPlugin(uiStatusPluginType);
        }
        return uiStatusPlugin;
    }

    @Override
    public UIStatusPlugin getBlankUiStatusPlugin(UIStatusPluginType statusPluginType) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        UIStatusPlugin uiStatusPlugin = this.getBlankUiStatusPlugin();
        uiStatusPlugin.setPluginType(statusPluginType);
        return uiStatusPlugin;
    }

    @Override
    public void updateStatusForAllPlugins(int siteId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify"});
        this.statusPluginManager.updateStatusForAllPlugins(Integer.valueOf(siteId));
    }

    @Override
    @Transactional
    public UISiteTitleStatusData getSiteTitleStatusData(UiTargetedTitlesRequest uiTargetedTitlesRequest) throws NeptuneException {
        UiTargetedTitlesRequest uiTargetedTitlesRequest2 = uiTargetedTitlesRequest;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = UISiteService.class.getDeclaredMethod("getSiteTitleStatusData", UiTargetedTitlesRequest.class).getAnnotation(Transactional.class);
        }
        return (UISiteTitleStatusData)UISiteService.getSiteTitleStatusData_aroundBody17$advice(this, uiTargetedTitlesRequest2, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<Long> filterParnterIds(Collection<Partner> partners) {
        ArrayList<Long> partnerIds = new ArrayList<Long>();
        for (Partner p : partners) {
            if (p.getType().equals((Object)PartnerType.SELF)) {
                return new ArrayList<Long>();
            }
            partnerIds.add(p.getId());
        }
        return partnerIds;
    }

    @Override
    public List<String> getTemplateNames() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View", WORKORDER_VIEW_PERMISSION});
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        List templateNames = service.getTemplateNamesByCategory("LocalContentProcessing");
        return templateNames;
    }

    @Override
    public void deleteLocalTitles(int siteId, List<Long> localTitleIds) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Modify", TITLE_DELETE_PERMISSION});
        try {
            for (Long localTitleId : localTitleIds) {
                Site site = this.siteManager.getSite(siteId);
                SiteType siteType = site.getType();
                if (SiteType.DISTRIBUTION.equals((Object)siteType)) {
                    this.siteManager.deleteTitle(localTitleId.longValue());
                    continue;
                }
                if (!SiteType.TRACKING.equals((Object)siteType)) continue;
                this.siteManager.deleteTrackingSiteTitle(localTitleId.longValue(), siteId);
            }
        }
        catch (Exception e) {
            throw new NeptuneException(e.getMessage());
        }
    }

    @Override
    public DistributeTitlesResponse distributeImmediately(int siteId, List<Long> localTitleIds) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Distribute"});
        DistributeTitlesResponse response = new DistributeTitlesResponse();
        ArrayList<Long> verifiedLocalTitleIds = new ArrayList<Long>();
        ArrayList<Long> failedTitleIds = new ArrayList<Long>();
        try {
            for (Long localTitleId : localTitleIds) {
                DistributionSiteTitle dst = this.siteManager.getDistributionSiteTitle(localTitleId.longValue());
                if (dst.getStatus() == DistributionStatus.TARGETED || dst.getStatus() == DistributionStatus.IN_PROGRESS) {
                    failedTitleIds.add(localTitleId);
                    continue;
                }
                verifiedLocalTitleIds.add(localTitleId);
            }
            if (!verifiedLocalTitleIds.isEmpty()) {
                this.siteManager.distributeImmediately(siteId, verifiedLocalTitleIds);
                response.setDistributeTitleIds(verifiedLocalTitleIds);
            }
            if (!failedTitleIds.isEmpty()) {
                response.setFailedIds(failedTitleIds);
                response.setErrorMsg("Cannot distribute titles in " + DistributionStatus.TARGETED + " or " + DistributionStatus.IN_PROGRESS);
            }
        }
        catch (Exception e) {
            throw new NeptuneException(e.getMessage());
        }
        return response;
    }

    @Override
    public void runTemplate(int siteId, List<Long> localTitleIds, String templateName) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{RUN_TEMPLATE_PERMISSION});
        for (Long localTitleId : localTitleIds) {
            WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"SM0109");
            WPCLCommand command = new WPCLCommand("create");
            command.addParameter("_template", templateName);
            message.setCommand(command);
            message.getPayload().putValue("titleId", String.valueOf(localTitleId));
            SoapRouter router = new SoapRouter();
            try {
                router.send(new WPCLConverter().convert(message));
            }
            catch (Exception e) {
                throw new NeptuneException(e.getMessage());
            }
        }
    }

    @Override
    public boolean isSiteNameAlreadyUsed(String siteName) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        return this.siteManager.isSiteNameAlreadyUsed(siteName);
    }

    @Override
    public boolean isExternalSiteIdAlreadyUsed(String externalSiteId, UISiteType uiSiteType) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        SiteType siteType = null;
        siteType = UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)uiSiteType) ? SiteType.DISTRIBUTION : SiteType.valueOf((String)uiSiteType.toString());
        return this.siteManager.isExternalSiteIdAlreadyUsed(externalSiteId, siteType);
    }

    @Override
    public boolean hasReachedMaxLicensedDistributionSites() {
        return this.siteManager.hasReachedMaxLicensedDistributionSites();
    }

    @Override
    public boolean hasReachedMaxLicensedTrackingSites() {
        return this.siteManager.hasReachedMaxLicensedTrackingSites();
    }

    private void associate(Site site, UIStatusPlugin uiStatusPlugin, boolean startMonitoring) throws NeptuneException {
        if (site != null && uiStatusPlugin != null) {
            int siteId = site.getId();
            String pluginId = uiStatusPlugin.getId();
            if (pluginId != null) {
                UIStatusPluginType uiStatusPluginType = uiStatusPlugin.getPluginType();
                StatusPluginType statusPluginType = StatusPluginType.valueOf((String)uiStatusPlugin.getPluginType().name());
                UIStatusPlugin currentlyAssociatedPlugin = this.getAssociatedPluginForSite(siteId, uiStatusPluginType);
                if (!uiStatusPlugin.equals(currentlyAssociatedPlugin)) {
                    this.statusPluginManager.startMasterAssociate(pluginId, statusPluginType, siteId, startMonitoring);
                }
            }
        }
    }

    private UIStatusPlugin getBlankUiStatusPlugin() {
        UIStatusPlugin uiStatusPlugin = new UIStatusPlugin();
        uiStatusPlugin.setId("");
        uiStatusPlugin.setLoaded(false);
        uiStatusPlugin.setPluginType(UIStatusPluginType.UNKNOWN);
        uiStatusPlugin.setConfiguration(new HashMap<String, String>());
        return uiStatusPlugin;
    }

    private UISiteTreeNode convertToUISiteTreeNode(Site parentSite, Site site, Set<Integer> errorDistSites, Set<String> errorTrackingSites) {
        UISiteTreeNode siteNode = new UISiteTreeNode();
        siteNode.setId(site.getId());
        siteNode.setName(site.getName());
        siteNode.setType(UISiteType.valueOf(site.getType().name()));
        siteNode.setActive(site.isActive());
        siteNode.setShared(site.getSiteParents().size() > 1);
        if (site.isActive()) {
            this.setErrorProperty(siteNode, parentSite, site, errorDistSites, errorTrackingSites);
        }
        if (site.getSiteChildren() != null) {
            for (Site childSite : site.getSiteChildren()) {
                siteNode.addChild(this.convertToUISiteTreeNode(site, childSite, errorDistSites, errorTrackingSites));
            }
        }
        return siteNode;
    }

    private void setErrorProperty(UISiteTreeNode siteNode, Site parentSite, Site site, Set<Integer> errorDistSites, Set<String> errorTrackingSites) {
        switch (site.getType()) {
            case LOGICAL: {
                siteNode.setError(false);
                break;
            }
            case DISTRIBUTION: {
                siteNode.setError(errorDistSites.contains(site.getId()));
                break;
            }
            case TRACKING: {
                siteNode.setError(errorTrackingSites.contains(parentSite.getId() + "_" + site.getId()));
            }
        }
    }

    private UISite convertToUISite(Site site) {
        UISite uiSite = new UISite();
        SiteType siteType = site.getType();
        uiSite.setId(site.getId());
        uiSite.setName(site.getName());
        uiSite.setType(UISiteType.valueOf(siteType.name()));
        uiSite.setActive(site.isActive());
        uiSite.setExternalId(site.getExternalId());
        uiSite.setDescription(site.getDescription());
        uiSite.setHasChildren(site.getSiteChildren() != null && !site.getSiteChildren().isEmpty());
        switch (site.getType()) {
            case LOGICAL: {
                break;
            }
            case DISTRIBUTION: {
                DistributionSite distSite = (DistributionSite)site;
                uiSite.setFileLookupKeys(distSite.getFileLookupKeys());
                uiSite.setMetadataFormat(distSite.getMetadataFormat());
                if (distSite.getDistributionOption() != null && distSite.getDistributionOption().name() != null) {
                    uiSite.setDistributionOption(UIDistributionOption.valueOf(distSite.getDistributionOption().name()));
                }
                if (UIDistributionOption.TIMED.equals((Object)uiSite.getDistributionOption())) {
                    Job timerJob = distSite.getTimerJob();
                    ScheduleConvertor scheduleConvertor = new ScheduleConvertor();
                    UIJob uiTimerJob = scheduleConvertor.convertJob(timerJob);
                    uiSite.setTimerJob(uiTimerJob);
                }
                uiSite.setDistTemplateName(distSite.getDistTemplateName());
                uiSite.setAssociatedGroupName(distSite.getAssociatedGroupName());
                uiSite.setDistConfParams(this.getACopy(distSite.getDistConfParams()));
                uiSite.setExportPluginName(distSite.getExportPluginName());
                uiSite.setExportConfParams(this.getACopy(distSite.getExportConfParams()));
                uiSite.setAssociatedResourceId(distSite.getAssociatedResourceId());
                uiSite.setAlertDelayPeriod(distSite.getAlertDelayPeriod());
                uiSite.setDependsOnSites(distSite.getDependsOnSites());
                if (distSite instanceof MediapathDistributionSite) {
                    uiSite.setType(UISiteType.MEDIAPATH_DISTRIBUTION);
                }
                if (distSite.getActionOnFailure() != null) {
                    uiSite.setActionOnFailure(UIActionOnFailureOption.valueOf(distSite.getActionOnFailure().name()));
                    uiSite.setRetryAttempt(distSite.getRetryAttempt());
                    uiSite.setRetryWaitTime(distSite.getRetryWaitTime());
                }
                if (distSite.getCisMode() == null) break;
                uiSite.setCisMode(UICISMode.valueOf(distSite.getCisMode().name()));
                break;
            }
            case TRACKING: {
                TrackingSite trackingSite = (TrackingSite)site;
                uiSite.setShared(trackingSite.getParents().size() > 1);
                uiSite.setAlertDelayPeriod(trackingSite.getAlertDelayPeriod());
            }
        }
        return uiSite;
    }

    private UISitePartner convertToUISitePartner(SitePartner sitePartner) {
        UISitePartner uiSitePartner = null;
        if (sitePartner != null) {
            uiSitePartner = SitePartnerUtils.convert(sitePartner);
        }
        return uiSitePartner;
    }

    private Map<String, String> getACopy(Map<String, String> map) {
        return map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
    }

    private Site convertToSite(UISite uiSite) {
        LogicalSite site = null;
        switch (uiSite.getType()) {
            case LOGICAL: {
                site = new LogicalSite();
                break;
            }
            case MEDIAPATH_DISTRIBUTION: {
                MediapathDistributionSite mediaPathDistSite = new MediapathDistributionSite();
                site = mediaPathDistSite;
                this.populateDistributionSite((DistributionSite)mediaPathDistSite, uiSite);
                break;
            }
            case DISTRIBUTION: {
                DistributionSite distSite = new DistributionSite();
                site = distSite;
                this.populateDistributionSite(distSite, uiSite);
                break;
            }
            case TRACKING: {
                TrackingSite trackingSite = new TrackingSite();
                site = trackingSite;
                trackingSite.setAlertDelayPeriod(uiSite.getAlertDelayPeriod());
            }
        }
        site.setId(uiSite.getId());
        site.setName(uiSite.getName());
        site.setExternalId(uiSite.getExternalId());
        site.setDescription(uiSite.getDescription());
        return site;
    }

    private SitePartner convertToSitePartner(UISitePartner uiSitePartner) {
        SitePartner sitePartner = null;
        if (uiSitePartner != null) {
            sitePartner = SitePartnerUtils.convert(uiSitePartner);
        }
        return sitePartner;
    }

    private void populateDistributionSite(DistributionSite distSite, UISite uiSite) {
        if (distSite != null && uiSite != null) {
            distSite.setMetadataFormat(uiSite.getMetadataFormat());
            distSite.setFileLookupKeys(uiSite.getFileLookupKeys());
            distSite.setDistributionOption(DistributionOption.valueOf((String)uiSite.getDistributionOption().name()));
            if (UIDistributionOption.TIMED.equals((Object)uiSite.getDistributionOption())) {
                UIJob uiTimerJob = uiSite.getTimerJob();
                ScheduleConvertor scheduleConvertor = new ScheduleConvertor();
                Job timerJob = scheduleConvertor.convertUIJob(uiTimerJob);
                distSite.setTimerJob(timerJob);
            }
            distSite.setDistTemplateName(uiSite.getDistTemplateName());
            distSite.setAssociatedGroupName(uiSite.getAssociatedGroupName());
            distSite.setDistConfParams(uiSite.getDistConfParams());
            distSite.setExportPluginName(uiSite.getExportPluginName());
            distSite.setExportConfParams(uiSite.getExportConfParams());
            distSite.setAssociatedResourceId(uiSite.getAssociatedResourceId());
            distSite.setAlertDelayPeriod(uiSite.getAlertDelayPeriod());
            distSite.setDependsOnSites(uiSite.getDependsOnSites());
            if (uiSite.getActionOnFailure() != null) {
                distSite.setActionOnFailure(ActionOnFailureOption.valueOf((String)uiSite.getActionOnFailure().name()));
                distSite.setRetryAttempt(uiSite.getRetryAttempt());
                distSite.setRetryWaitTime(uiSite.getRetryWaitTime());
            }
            if (uiSite.getCisMode() != null) {
                distSite.setCisMode(CISMode.valueOf((String)uiSite.getCisMode().name()));
            }
        }
    }

    private List<DistributionStatus> convertToDistributionStatusList(List<UIDistributionStatus> uiStatuses) {
        if (uiStatuses == null) {
            return null;
        }
        ArrayList<DistributionStatus> statuses = new ArrayList<DistributionStatus>();
        for (UIDistributionStatus uiStatus : uiStatuses) {
            statuses.add(DistributionStatus.valueOf((String)uiStatus.name()));
        }
        return statuses;
    }

    private List<UIStatusPlugin> convertToUIStatusPlugins(IStatusPlugin statusPlugin) {
        Map multiConfiguration;
        ArrayList<UIStatusPlugin> uiStatusPlugins = new ArrayList<UIStatusPlugin>();
        if (statusPlugin != null && (multiConfiguration = statusPlugin.getMultiConfiguration()) != null && !multiConfiguration.isEmpty()) {
            for (String configId : multiConfiguration.keySet()) {
                String pluginId;
                Map properties = (Map)multiConfiguration.get(configId);
                UIStatusPlugin uiStatusPlugin = new UIStatusPlugin();
                String uiStatusPluginID = pluginId = this.getPluginId(statusPlugin.getId());
                uiStatusPluginID = String.valueOf(uiStatusPluginID) + "#";
                uiStatusPluginID = String.valueOf(uiStatusPluginID) + configId;
                uiStatusPlugin.setId(uiStatusPluginID);
                uiStatusPlugin.setName(statusPlugin.getName());
                uiStatusPlugin.setLoaded(statusPlugin.isLoaded());
                UIStatusPluginType uiStatusPluginType = null;
                StatusPluginType statusPluginType = statusPlugin.getPluginType();
                try {
                    uiStatusPluginType = UIStatusPluginType.valueOf(statusPluginType.name());
                }
                catch (Exception exception) {
                    uiStatusPluginType = UIStatusPluginType.UNKNOWN;
                }
                uiStatusPlugin.setPluginType(uiStatusPluginType);
                uiStatusPlugin.setConfiguration(properties);
                uiStatusPlugin.setMultiConfiguration(statusPlugin.getMultiConfiguration());
                uiStatusPlugins.add(uiStatusPlugin);
            }
        }
        return uiStatusPlugins;
    }

    private UIStatusPlugin convertToUIStatusPlugin(IStatusPlugin statusPlugin) {
        UIStatusPlugin uiStatusPlugin = new UIStatusPlugin();
        if (statusPlugin != null) {
            String configId;
            Map props;
            String uiStatusPluginID = statusPlugin.getId();
            uiStatusPlugin.setId(uiStatusPluginID);
            uiStatusPlugin.setName(statusPlugin.getName());
            uiStatusPlugin.setLoaded(statusPlugin.isLoaded());
            UIStatusPluginType uiStatusPluginType = null;
            StatusPluginType statusPluginType = statusPlugin.getPluginType();
            try {
                uiStatusPluginType = UIStatusPluginType.valueOf(statusPluginType.name());
            }
            catch (Exception exception) {
                uiStatusPluginType = UIStatusPluginType.UNKNOWN;
            }
            uiStatusPlugin.setPluginType(uiStatusPluginType);
            Map multiConfiguration = statusPlugin.getMultiConfiguration();
            uiStatusPlugin.setMultiConfiguration(multiConfiguration);
            Map configuration = statusPlugin.getConfiguration();
            if (multiConfiguration != null && !multiConfiguration.isEmpty() && (props = (Map)multiConfiguration.get(configId = this.getConfigId(uiStatusPluginID))) != null) {
                configuration = props;
            }
            uiStatusPlugin.setConfiguration(configuration);
        }
        return uiStatusPlugin;
    }

    protected String getPluginId(String id) {
        String pluginId = null;
        if (id != null) {
            pluginId = id;
            if (id.contains("#")) {
                String[] idArray = id.split("#");
                pluginId = idArray[0];
            }
        }
        return pluginId;
    }

    protected String getConfigId(String id) {
        String configId = null;
        if (id != null && id.contains("#")) {
            String[] idArray = id.split("#");
            configId = idArray.length > 1 ? idArray[1] : "";
        }
        return configId;
    }

    private void fillAllLists(UISite site) throws NeptuneException {
        site.setAllMetadataFormats(this.getAllMetadataFormats());
        site.setAllFileLookupKeys(this.getAllFileLookupKeys());
        site.setAllDistributionSites(this.getAllDistributionSites());
        site.setAllTemplatesInfo(this.getAllTemplatesInfo());
        site.setAllExportPluginsInfo(this.getAllExportPluginsInfo());
    }

    @Override
    public Map<String, List<String>> getDependencyInfo(Integer siteId) {
        List dependentSites = this.sitesDepSvc.getImmediateDependentSites(siteId);
        List dependsOnSites = this.sitesDepSvc.getImmediateDependOnSites(siteId);
        HashMap<String, List<String>> dependencyInfo = new HashMap<String, List<String>>();
        dependencyInfo.put("dependentSites", this.siteManager.getSiteNamesBySiteIds(dependentSites));
        dependencyInfo.put("dependsOnSites", this.siteManager.getSiteNamesBySiteIds(dependsOnSites));
        return dependencyInfo;
    }

    private void setDependsOnSites(UISite site) {
        site.setDependsOnSites(this.siteManager.getDependsOnSites(site.getId()));
    }

    private List<Integer> getNonSelectableSites(Integer siteId) {
        List<Integer> disableSites = new ArrayList<Integer>();
        if (siteId != null && (disableSites = this.sitesDepSvc.getNonUsableSitesForDependOn(siteId)) == null) {
            return new ArrayList<Integer>();
        }
        return disableSites;
    }

    private void setNonSelectableSites(UISite site) {
        site.setNonSelectableSites(this.getNonSelectableSites(site.getId()));
    }

    private IRuleManager getRuleManager() {
        return (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    }

    @Override
    @Transactional
    public UiMetadataTree getSiteTimerMetadataTree() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = UISiteService.class.getDeclaredMethod("getSiteTimerMetadataTree", new Class[0]).getAnnotation(Transactional.class);
        }
        return (UiMetadataTree)UISiteService.getSiteTimerMetadataTree_aroundBody19$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional(readOnly=true)
    public SiteActivityTables getDistSiteActivity(Integer distSiteId, UIDistributionStatus status, String fromDateStr, String toDateStr, Integer trackSiteId) {
        Integer n = distSiteId;
        UIDistributionStatus uIDistributionStatus = status;
        String string = fromDateStr;
        String string2 = toDateStr;
        Integer n2 = trackSiteId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = UISiteService.class.getDeclaredMethod("getDistSiteActivity", Integer.class, UIDistributionStatus.class, String.class, String.class, Integer.class).getAnnotation(Transactional.class);
        }
        return (SiteActivityTables)UISiteService.getDistSiteActivity_aroundBody21$advice(this, n, uIDistributionStatus, string, string2, n2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional(readOnly=true)
    public SiteActivityTables getTrackSiteActivity(Integer trackSiteId, UITrackingStatus status, String fromDateStr, String toDateStr, Integer distSiteId) {
        Integer n = trackSiteId;
        UITrackingStatus uITrackingStatus = status;
        String string = fromDateStr;
        String string2 = toDateStr;
        Integer n2 = distSiteId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = UISiteService.class.getDeclaredMethod("getTrackSiteActivity", Integer.class, UITrackingStatus.class, String.class, String.class, Integer.class).getAnnotation(Transactional.class);
        }
        return (SiteActivityTables)UISiteService.getTrackSiteActivity_aroundBody23$advice(this, n, uITrackingStatus, string, string2, n2, transactionEnforcer, (Transactional)annotation, null);
    }

    private void addHeaderColumns(Table specTable, SiteActivityTables uiTables) {
        for (Column col : specTable.getColumns()) {
            uiTables.addHeaderColumn(col.getColumnName());
        }
    }

    private List<SearchColumn> getTitleColumns(Table specTable) {
        ArrayList<SearchColumn> searchColumns = new ArrayList<SearchColumn>();
        for (Column col : specTable.getColumns()) {
            if (col.getColumnAttribute("TitleSection") == null) continue;
            String sectionName = col.getColumnAttribute("TitleSection");
            String fieldName = col.getParameter();
            searchColumns.add(new SearchColumn(sectionName, fieldName, FieldType.ASSET, "string", false));
        }
        return searchColumns;
    }

    private SortingInfo getSortingInfo(Table specTable) {
        String sortColumn;
        SortOrder sortOrder = SortOrder.ASCENDING;
        if (specTable.getDefaultSortingOrder() != null && specTable.getDefaultSortingOrder().equalsIgnoreCase("DESCENDING")) {
            sortOrder = SortOrder.DESCENDING;
        }
        if ((sortColumn = specTable.getDefaultSortingColumn()).equals("id")) {
            sortColumn = "titleid";
        } else if (sortColumn.equals("distributionStatusUpdatedTime")) {
            sortColumn = "status_updated_time";
        }
        SortingInfo si = new SortingInfo(sortColumn, sortOrder, null, FieldType.PMM_TITLE);
        return si;
    }

    private void translateModel(List<SiteActivity> activities, SiteActivityTables uiTables, Table specTable, UISiteType uiSiteType) {
        int lastSiteId = -1;
        SiteActivityTable uiTable = null;
        for (SiteActivity activity : activities) {
            if (lastSiteId != activity.getSiteId()) {
                lastSiteId = activity.getSiteId();
                uiTable = new SiteActivityTable(activity.getSiteId(), activity.getSiteName());
                uiTables.addTable(uiTable);
            }
            ArrayList<SiteActivityTable.Column> dataRow = new ArrayList<SiteActivityTable.Column>(specTable.getColumns().size());
            Iterator activityMetadataIter = activity.getTitleMetadata().iterator();
            for (Column col : specTable.getColumns()) {
                if (col.getColumnAttribute("TitleSection") != null) {
                    dataRow.add(new SiteActivityTable.TextColumn((String)activityMetadataIter.next()));
                    continue;
                }
                if (col.getMethodName().equals("siteId")) {
                    dataRow.add(new SiteActivityTable.HyperlinkColumn(String.valueOf(activity.getSiteId()), "Sites.View?id=" + activity.getSiteId()));
                    continue;
                }
                if (col.getMethodName().equals("siteName")) {
                    dataRow.add(new SiteActivityTable.HyperlinkColumn(activity.getSiteName(), "Sites.View?id=" + activity.getSiteId()));
                    continue;
                }
                if (col.getMethodName().equals("id")) {
                    dataRow.add(new SiteActivityTable.HyperlinkColumn(String.valueOf(activity.getTitleId()), "Content.Search.Id=" + activity.getTitleId()));
                    continue;
                }
                if (col.getMethodName().equals("thumbnail")) {
                    dataRow.add(new SiteActivityTable.TitleThumbnailColumn(activity.getTitleId()));
                    continue;
                }
                if (col.getMethodName().equals("status")) {
                    if (uiSiteType == UISiteType.DISTRIBUTION) {
                        DistributionStatus distStatus = DistributionStatus.values()[activity.getStatus()];
                        UIDistributionStatus uiDistStatus = UIDistributionStatus.valueOf((String)distStatus.name());
                        dataRow.add(new SiteActivityTable.DistTitleStatusColumn(uiDistStatus));
                        continue;
                    }
                    if (uiSiteType == UISiteType.TRACKING) {
                        TrackingStatus trackStatus = TrackingStatus.values()[activity.getStatus()];
                        UITrackingStatus uiTrackStatus = UITrackingStatus.valueOf((String)trackStatus.name());
                        dataRow.add(new SiteActivityTable.TrackTitleStatusColumn(uiTrackStatus));
                        continue;
                    }
                    throw new IllegalArgumentException("uiSiteType can be only distribution or tracking");
                }
                if (col.getMethodName().equals("distributionStatusUpdatedTime")) {
                    dataRow.add(new SiteActivityTable.TextColumn(this.dateFormatter.format(activity.getStatusUpdatedTime())));
                    continue;
                }
                dataRow.add(new SiteActivityTable.TextColumn("Unsupported column"));
            }
            uiTable.addDataRow(dataRow);
        }
    }

    @Override
    public Collection<UIResourceGroup> getAllGroupsByTemplateId(String id) throws NeptuneException {
        ArrayList<ResourceGroup> groups = new ArrayList();
        try {
            Template template = this.getTemplate(id);
            groups = template.getGroups();
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get resource groups", (Throwable)e);
        }
        Collection<UIResourceGroup> uiGroups = this.getUIGroups(groups);
        return uiGroups;
    }

    private Template getTemplate(String id) throws IOException {
        Templates request = this.requestTemplates();
        request.query().id(id);
        TemplateListResponse response = request.execute();
        if (response.getItems().isEmpty()) {
            return null;
        }
        return (Template)response.getItems().get(0);
    }

    private Templates requestTemplates() {
        return new API.Builder().build().templates();
    }

    private List<Resource> getResourcesList(String groupName) throws IOException {
        ResourceGroups request = this.requestGroups();
        request.query().name(groupName).resources().count(100);
        return ((ResourceGroup)request.execute().getItems().get(0)).getResources();
    }

    private ResourceGroups requestGroups() {
        return new API.Builder().build().resourceGroups();
    }

    private static final /* synthetic */ List getSiteTree_aroundBody0(UISiteService ajc$this) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        HashSet<Integer> errorDistSites = new HashSet();
        HashSet<String> errorTrackingSites = new HashSet();
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (!partners.isEmpty()) {
            List<Long> partnerIds = ajc$this.filterParnterIds(partners);
            errorDistSites = ajc$this.siteManager.getActiveDistributionSitesInError(partnerIds);
            errorTrackingSites = ajc$this.siteManager.getActiveTrackingSitesInError(partnerIds);
        }
        ArrayList<UISiteTreeNode> tree = new ArrayList<UISiteTreeNode>();
        List topLevelSites = ajc$this.siteManager.getTopLevelSites();
        if (topLevelSites != null) {
            for (Site site : topLevelSites) {
                tree.add(ajc$this.convertToUISiteTreeNode(null, site, errorDistSites, errorTrackingSites));
            }
        }
        return tree;
    }

    private static final /* synthetic */ Object getSiteTree_aroundBody1$advice(UISiteService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getSiteTree_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UISiteService.getSiteTree_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllSites_aroundBody2(UISiteService ajc$this) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        ArrayList<UISite> uiSites = new ArrayList<UISite>(100);
        List sites = ajc$this.siteManager.getAllSites();
        if (sites != null) {
            for (Site site : sites) {
                UISite uiSite = new UISite();
                uiSite.setId(site.getId());
                uiSite.setType(UISiteType.valueOf(site.getType().name()));
                uiSite.setName(site.getName());
                uiSites.add(uiSite);
            }
        }
        return uiSites;
    }

    private static final /* synthetic */ Object getAllSites_aroundBody3$advice(UISiteService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getAllSites_aroundBody2(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UISiteService.getAllSites_aroundBody2(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllDistributionSites_aroundBody4(UISiteService ajc$this) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        ArrayList<UISite> uiSites = new ArrayList<UISite>(100);
        List sites = ajc$this.siteManager.getAllDistributionSites();
        if (sites != null) {
            for (DistributionSite site : sites) {
                UISite uiSite = new UISite();
                uiSite.setId(site.getId());
                uiSite.setType(UISiteType.DISTRIBUTION);
                uiSite.setName(site.getName());
                uiSites.add(uiSite);
            }
        }
        Collections.sort(uiSites);
        return uiSites;
    }

    private static final /* synthetic */ Object getAllDistributionSites_aroundBody5$advice(UISiteService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getAllDistributionSites_aroundBody4(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UISiteService.getAllDistributionSites_aroundBody4(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllTrackingSites_aroundBody6(UISiteService ajc$this, Integer parentDistSiteId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        ArrayList<UISite> uiSites = new ArrayList<UISite>(100);
        List sites = ajc$this.siteManager.getAllTrackingSites(parentDistSiteId);
        if (sites != null) {
            for (TrackingSite site : sites) {
                UISite uiSite = new UISite();
                uiSite.setId(site.getId());
                uiSite.setType(UISiteType.TRACKING);
                uiSite.setName(site.getName());
                uiSites.add(uiSite);
            }
        }
        return uiSites;
    }

    private static final /* synthetic */ Object getAllTrackingSites_aroundBody7$advice(UISiteService ajc$this, Integer parentDistSiteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getAllTrackingSites_aroundBody6(ajc$this, parentDistSiteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UISiteService.getAllTrackingSites_aroundBody6(ajc$this, parentDistSiteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getShareableTrackingSites_aroundBody8(UISiteService ajc$this, int distributionSiteId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        ArrayList<UISite> uiTrackingSites = new ArrayList<UISite>();
        List trackingSites = ajc$this.siteManager.getShareableTrackingSites(distributionSiteId);
        if (trackingSites != null) {
            for (TrackingSite ts : trackingSites) {
                uiTrackingSites.add(ajc$this.convertToUISite((Site)ts));
            }
        }
        return uiTrackingSites;
    }

    private static final /* synthetic */ Object getShareableTrackingSites_aroundBody9$advice(UISiteService ajc$this, int distributionSiteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getShareableTrackingSites_aroundBody8(ajc$this, distributionSiteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UISiteService.getShareableTrackingSites_aroundBody8(ajc$this, distributionSiteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UISite get_aroundBody10(UISiteService ajc$this, int siteId, Integer parentSiteId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        Site site = ajc$this.siteManager.getSite(siteId);
        if (site == null) {
            throw new NeptuneException("No site found for id: " + siteId);
        }
        SiteType siteType = site.getType();
        if (SiteType.DISTRIBUTION.equals((Object)siteType)) {
            DistributionSite distSite = (DistributionSite)site;
            Job timerJob = ajc$this.siteManager.getTimerJob(distSite);
            distSite.setTimerJob(timerJob);
        }
        SitePartner sitePartner = null;
        if (!SiteType.TRACKING.equals((Object)siteType)) {
            sitePartner = ajc$this.sitePartnerManager.get(siteId);
        }
        if (parentSiteId != null) {
            boolean parentFound = false;
            if (site.getSiteParents() != null) {
                for (Site parent : site.getSiteParents()) {
                    if (!parent.getId().equals(parentSiteId)) continue;
                    parentFound = true;
                    break;
                }
            }
            if (!parentFound) {
                throw new NeptuneException("No site found for id: " + siteId + " and parentId: " + parentSiteId);
            }
        }
        UISite uiSite = ajc$this.convertToUISite(site);
        UISitePartner uiSitePartner = ajc$this.convertToUISitePartner(sitePartner);
        uiSite.setSitePartner(uiSitePartner);
        uiSite.setParentId(parentSiteId);
        if (uiSite.getType() == UISiteType.DISTRIBUTION || uiSite.getType() == UISiteType.MEDIAPATH_DISTRIBUTION) {
            ajc$this.fillAllLists(uiSite);
            ajc$this.setDependsOnSites(uiSite);
            ajc$this.setNonSelectableSites(uiSite);
        }
        return uiSite;
    }

    private static final /* synthetic */ Object get_aroundBody11$advice(UISiteService ajc$this, int siteId, Integer parentSiteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.get_aroundBody10(ajc$this, siteId, parentSiteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UISite object = UISiteService.get_aroundBody10(ajc$this, siteId, parentSiteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UISite save_aroundBody12(UISiteService ajc$this, UISite uiSite) {
        if (uiSite.getId() == null || uiSite.getId() <= 0) {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View", "Sites_Create"});
        } else {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View", "Sites_Modify"});
        }
        try {
            Site site = ajc$this.convertToSite(uiSite);
            SitePartner sitePartner = ajc$this.convertToSitePartner(uiSite.getSitePartner());
            Site savedSite = null;
            SitePartner savedSitePartner = null;
            if (site.getId() == null) {
                switch (uiSite.getType()) {
                    case LOGICAL: {
                        savedSite = ajc$this.siteManager.createLogicalSite((LogicalSite)site, sitePartner);
                        break;
                    }
                    case DISTRIBUTION: 
                    case MEDIAPATH_DISTRIBUTION: {
                        savedSite = ajc$this.siteManager.createDistributionSite((DistributionSite)site, uiSite.getParentId(), sitePartner);
                        break;
                    }
                    case TRACKING: {
                        savedSite = ajc$this.siteManager.createTrackingSite((TrackingSite)site, uiSite.getParentId());
                    }
                }
            } else {
                savedSite = ajc$this.siteManager.updateSiteProperties(site);
                savedSitePartner = ajc$this.siteManager.updateSitePartnerProperties(site, sitePartner);
            }
            if (SiteType.DISTRIBUTION.equals((Object)savedSite.getType())) {
                DistributionSite distSite = (DistributionSite)savedSite;
                Job timerJob = ajc$this.siteManager.getTimerJob(distSite);
                distSite.setTimerJob(timerJob);
            }
            UIStatusPlugin distUiStatusPlugin = uiSite.getDistUiStatusPlugin();
            UIStatusPlugin deplUiStatusPlugin = uiSite.getDeplUiStatusPlugin();
            boolean startMonitoring = false;
            if (savedSite.isActive()) {
                startMonitoring = true;
            }
            if (distUiStatusPlugin != null && (UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)uiSite.getType()) || UISiteType.DISTRIBUTION.equals((Object)uiSite.getType()))) {
                ajc$this.associate(savedSite, distUiStatusPlugin, startMonitoring);
            }
            if (deplUiStatusPlugin != null && (UISiteType.DISTRIBUTION.equals((Object)uiSite.getType()) || UISiteType.MEDIAPATH_DISTRIBUTION.equals((Object)uiSite.getType()) || UISiteType.TRACKING.equals((Object)uiSite.getType()))) {
                ajc$this.associate(savedSite, deplUiStatusPlugin, startMonitoring);
            }
            UISite savedUISite = ajc$this.convertToUISite(savedSite);
            savedUISite.setParentId(uiSite.getParentId());
            if (savedUISite.getType() == UISiteType.DISTRIBUTION || savedUISite.getType() == UISiteType.MEDIAPATH_DISTRIBUTION) {
                ajc$this.fillAllLists(savedUISite);
                ajc$this.setDependsOnSites(uiSite);
                ajc$this.setNonSelectableSites(uiSite);
            }
            UISitePartner uiSitePartner = ajc$this.convertToUISitePartner(savedSitePartner);
            savedUISite.setSitePartner(uiSitePartner);
            ajc$this.notifyCluster(savedUISite.getId());
            return savedUISite;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof SiteManagementException) {
                throw new NeptuneException(e.getCause().getLocalizedMessage());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object save_aroundBody13$advice(UISiteService ajc$this, UISite uiSite, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.save_aroundBody12(ajc$this, uiSite);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UISite object = UISiteService.save_aroundBody12(ajc$this, uiSite);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void dissociateHelper_aroundBody14(UISiteService ajc$this, int siteId, List ruleSetIds) {
        ajc$this.getRuleManager().disassociateRuleSetsSite(ruleSetIds, Integer.valueOf(siteId));
    }

    private static final /* synthetic */ Object dissociateHelper_aroundBody15$advice(UISiteService ajc$this, int siteId, List ruleSetIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            UISiteService.dissociateHelper_aroundBody14(ajc$this, siteId, ruleSetIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UISiteService.dissociateHelper_aroundBody14(ajc$this, siteId, ruleSetIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UISiteTitleStatusData getSiteTitleStatusData_aroundBody16(UISiteService ajc$this, UiTargetedTitlesRequest uiTargetedTitlesRequest) {
        TitleSearchResult searchResults;
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.isEmpty()) {
            return new UISiteTitleStatusData();
        }
        List<Long> partnerIds = ajc$this.filterParnterIds(partners);
        UISiteTitleStatusData uiSiteTitleStatusData = new UISiteTitleStatusData();
        int siteId = uiTargetedTitlesRequest.getSiteId();
        int startIndex = uiTargetedTitlesRequest.getStartIndex();
        int maxRecordCount = uiTargetedTitlesRequest.getMaxRecordCount();
        String sortColumnName = uiTargetedTitlesRequest.getSortColumnName();
        UiSortColumnType sortColumnType = uiTargetedTitlesRequest.getSortColumnType();
        String sortAssetType = uiTargetedTitlesRequest.getSortColumnAssetType();
        String sortOrder = uiTargetedTitlesRequest.getSortOrder();
        ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        siteIds.add(siteId);
        UISiteType uiSiteType = uiTargetedTitlesRequest.getSiteType();
        SiteType siteType = uiSiteType == UISiteType.MEDIAPATH_DISTRIBUTION ? SiteType.DISTRIBUTION : SiteType.valueOf((String)uiTargetedTitlesRequest.getSiteType().name());
        com.tandbergtv.cms.title.search.entities.SiteType tSiteType = null;
        if (SiteType.DISTRIBUTION == siteType) {
            tSiteType = com.tandbergtv.cms.title.search.entities.SiteType.DISTRIBUTION_SITE;
        } else if (SiteType.TRACKING == siteType) {
            tSiteType = com.tandbergtv.cms.title.search.entities.SiteType.TRACKING_SITE;
        }
        PagingInfo pagingInfo = new PagingInfo(startIndex, maxRecordCount);
        SortOrder sortingOrder = SortOrder.valueOf((String)sortOrder);
        FieldType fieldType = FieldType.ASSET;
        if (UiSortColumnType.TITLE == sortColumnType) {
            fieldType = FieldType.PMM_TITLE;
        } else if (UiSortColumnType.METADATA == sortColumnType) {
            fieldType = FieldType.ASSET;
        } else if (UiSortColumnType.SITE == sortColumnType) {
            fieldType = FieldType.SITE;
        }
        SortingInfo sortInfo = new SortingInfo(sortColumnName, sortingOrder, sortAssetType, fieldType);
        List searchCols = TitleSearchServiceImpl.convertSeachColumns(uiTargetedTitlesRequest.getColumns(), (int)siteId);
        String srchTxt = uiTargetedTitlesRequest.getSrchTxt();
        SearchColumn distStatusDetCol = new SearchColumn(null, "distributionStatusDetail", FieldType.PMM_TITLE, "integer", false);
        searchCols.add(distStatusDetCol);
        Integer siteTitleStatus = null;
        if (siteType.equals((Object)SiteType.DISTRIBUTION) && !uiTargetedTitlesRequest.getSiteTitleStatus().isEmpty()) {
            siteTitleStatus = DistributionStatus.valueOf((String)uiTargetedTitlesRequest.getSiteTitleStatus()).ordinal();
        } else if (siteType.equals((Object)SiteType.TRACKING) && !uiTargetedTitlesRequest.getSiteTitleStatus().isEmpty()) {
            siteTitleStatus = TrackingStatus.valueOf((String)uiTargetedTitlesRequest.getSiteTitleStatus()).ordinal();
        }
        try {
            searchResults = searchService.getTargetedTitlesQuickSearch(srchTxt, partnerIds, pagingInfo, sortInfo, searchCols, tSiteType, Integer.valueOf(siteId), siteTitleStatus);
        }
        catch (Exception ex) {
            throw new TargetedTitleQuickSearchException(ex.getMessage());
        }
        for (TitleSearchResult.SearchRow row : searchResults.getRows()) {
            UISiteTitleStatusRecord uiSiteTitleStatusRecord = new UISiteTitleStatusRecord();
            uiSiteTitleStatusRecord.setDistributionTitle(SiteType.DISTRIBUTION.equals((Object)siteType));
            uiSiteTitleStatusRecord.setTitleId(row.getId());
            String status = "";
            int statusDetail = DistributionStatusDetail.NONE.ordinal();
            ArrayList<TitleMetadata> metaData = new ArrayList<TitleMetadata>();
            int i = 0;
            while (i < searchCols.size()) {
                SearchColumn col = (SearchColumn)searchCols.get(i);
                String fieldValue = row.getFirstValueAsString(i);
                String fieldName = col.getFieldName();
                String assetType = col.getSectionType();
                if (fieldName.contains("updatedTime")) {
                    fieldName = "statusUpdateTime";
                }
                if (col.getFieldType().equals((Object)FieldType.SITE) && fieldName.equals("status")) {
                    status = fieldValue;
                } else if (col.getFieldType().equals((Object)FieldType.ASSET) || col.getFieldType().equals((Object)FieldType.SITE)) {
                    metaData.add(new TitleMetadata(fieldName, fieldValue, assetType));
                } else if (col.getFieldType().equals((Object)FieldType.PMM_TITLE) && fieldName.equals("distributionStatusDetail") && fieldValue != null && !fieldValue.isEmpty()) {
                    statusDetail = Integer.parseInt(fieldValue);
                }
                ++i;
            }
            uiSiteTitleStatusRecord.setMetadata(metaData);
            uiSiteTitleStatusRecord.setStatus(status);
            uiSiteTitleStatusRecord.setStatusDetail(statusDetail);
            uiSiteTitleStatusData.addUISiteTitleStatusRecord(uiSiteTitleStatusRecord);
        }
        uiSiteTitleStatusData.setTotalCount((int)searchResults.getCount());
        return uiSiteTitleStatusData;
    }

    private static final /* synthetic */ Object getSiteTitleStatusData_aroundBody17$advice(UISiteService ajc$this, UiTargetedTitlesRequest uiTargetedTitlesRequest, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getSiteTitleStatusData_aroundBody16(ajc$this, uiTargetedTitlesRequest);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UISiteTitleStatusData object = UISiteService.getSiteTitleStatusData_aroundBody16(ajc$this, uiTargetedTitlesRequest);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiMetadataTree getSiteTimerMetadataTree_aroundBody18(UISiteService ajc$this) {
        UiMetadataTree uiMetadataTree = null;
        List filterParameters = ajc$this.woScheduler.getParametersForFilter("Sites");
        MetadataTreeConvertor metadataTreeConvertor = new MetadataTreeConvertor();
        uiMetadataTree = metadataTreeConvertor.convertMetadataTree(filterParameters);
        return uiMetadataTree;
    }

    private static final /* synthetic */ Object getSiteTimerMetadataTree_aroundBody19$advice(UISiteService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getSiteTimerMetadataTree_aroundBody18(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiMetadataTree object = UISiteService.getSiteTimerMetadataTree_aroundBody18(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SiteActivityTables getDistSiteActivity_aroundBody20(UISiteService ajc$this, Integer distSiteId, UIDistributionStatus status, String fromDateStr, String toDateStr, Integer trackSiteId) {
        List<Object> activities;
        Date toDate;
        Date fromDate;
        try {
            fromDate = ajc$this.sitesActivitySearchDateFormatter.parse(fromDateStr);
            toDate = ajc$this.sitesActivitySearchDateFormatter.parse(toDateStr);
            toDate = new Date(toDate.getTime() + 86399999L);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse search date range", e);
        }
        SiteActivityTables uiTables = new SiteActivityTables();
        Table specTable = ajc$this.specManager.getTableConfiguration(SITES_ACTIVITY_TABLE_NAME);
        ajc$this.addHeaderColumns(specTable, uiTables);
        List<SearchColumn> searchColumns = ajc$this.getTitleColumns(specTable);
        SortingInfo si = ajc$this.getSortingInfo(specTable);
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.isEmpty()) {
            activities = new ArrayList<SiteActivity>(0);
        } else {
            List<Long> partnerIds = ajc$this.filterParnterIds(partners);
            activities = ajc$this.sitesActivityService.getDistributionSiteActivity(distSiteId, DistributionStatus.valueOf((String)status.name()), fromDate, toDate, trackSiteId, partnerIds, searchColumns, si);
        }
        ajc$this.translateModel(activities, uiTables, specTable, UISiteType.DISTRIBUTION);
        return uiTables;
    }

    private static final /* synthetic */ Object getDistSiteActivity_aroundBody21$advice(UISiteService ajc$this, Integer distSiteId, UIDistributionStatus status, String fromDateStr, String toDateStr, Integer trackSiteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getDistSiteActivity_aroundBody20(ajc$this, distSiteId, status, fromDateStr, toDateStr, trackSiteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SiteActivityTables object = UISiteService.getDistSiteActivity_aroundBody20(ajc$this, distSiteId, status, fromDateStr, toDateStr, trackSiteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SiteActivityTables getTrackSiteActivity_aroundBody22(UISiteService ajc$this, Integer trackSiteId, UITrackingStatus status, String fromDateStr, String toDateStr, Integer distSiteId) {
        List<Object> activities;
        Date toDate;
        Date fromDate;
        try {
            fromDate = ajc$this.sitesActivitySearchDateFormatter.parse(fromDateStr);
            toDate = ajc$this.sitesActivitySearchDateFormatter.parse(toDateStr);
            toDate = new Date(toDate.getTime() + 86399999L);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse search date range", e);
        }
        SiteActivityTables uiTables = new SiteActivityTables();
        Table specTable = ajc$this.specManager.getTableConfiguration(SITES_ACTIVITY_TABLE_NAME);
        ajc$this.addHeaderColumns(specTable, uiTables);
        List<SearchColumn> searchColumns = ajc$this.getTitleColumns(specTable);
        SortingInfo si = ajc$this.getSortingInfo(specTable);
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.isEmpty()) {
            activities = new ArrayList<SiteActivity>(0);
        } else {
            List<Long> partnerIds = ajc$this.filterParnterIds(partners);
            activities = ajc$this.sitesActivityService.getTrackingSiteActivity(trackSiteId, TrackingStatus.valueOf((String)status.name()), fromDate, toDate, distSiteId, partnerIds, searchColumns, si);
        }
        ajc$this.translateModel(activities, uiTables, specTable, UISiteType.TRACKING);
        return uiTables;
    }

    private static final /* synthetic */ Object getTrackSiteActivity_aroundBody23$advice(UISiteService ajc$this, Integer trackSiteId, UITrackingStatus status, String fromDateStr, String toDateStr, Integer distSiteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UISiteService.getTrackSiteActivity_aroundBody22(ajc$this, trackSiteId, status, fromDateStr, toDateStr, distSiteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SiteActivityTables object = UISiteService.getTrackSiteActivity_aroundBody22(ajc$this, trackSiteId, status, fromDateStr, toDateStr, distSiteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

