/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server.portlet.distribution;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.ui.client.portlet.distribution.DistributionPortletData;
import com.ericsson.cms.sites.ui.client.portlet.distribution.DistributionPortletRecord;
import com.ericsson.cms.sites.ui.client.portlet.distribution.IDistributionPortletService;
import com.ericsson.cms.sites.ui.client.portlet.distribution.TitleMetadata;
import com.ericsson.cms.sites.ui.server.util.UIPropertyReader;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class DistributionPortletServiceImpl
implements IDistributionPortletService,
NeptuneRemoteService {
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private static final IPartnerUserManager parnterService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
    private static final String MAX_TITLE_COUNT_PROP = "site.portlets.distribution.total";
    private static int DEFAULT_MAX_TITLE_COUNT = 10;
    private static final String TABLE_NAME = "title.portlet.Metadata";
    private static /* synthetic */ Annotation ajc$anno$0;

    public String getRelativePath() {
        return "service/cms/sites/portlet/IDistributionPortletService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public DistributionPortletData getData() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = DistributionPortletServiceImpl.class.getDeclaredMethod("getData", new Class[0]).getAnnotation(Transactional.class);
        }
        return (DistributionPortletData)DistributionPortletServiceImpl.getData_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private int getMaxTitleCount() {
        UIPropertyReader reader = new UIPropertyReader();
        String countStr = reader.getInfo().get(MAX_TITLE_COUNT_PROP);
        try {
            int count = Integer.parseInt(countStr.trim());
            return count;
        }
        catch (Exception exception) {
            return DEFAULT_MAX_TITLE_COUNT;
        }
    }

    private List<SearchColumn> getColumns() {
        ArrayList<SearchColumn> results = new ArrayList<SearchColumn>();
        results.add(new SearchColumn("", "distributionStatus", FieldType.PMM_TITLE, "string", false));
        results.addAll(this.getTableColumns());
        return results;
    }

    private List<SearchColumn> getTableColumns() {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        Table table = this.specManager.getTableConfiguration(TABLE_NAME);
        List cols = table.getColumns();
        for (Column c : cols) {
            String xpath = c.getParameter();
            String assetType = c.getTitleSection();
            String dataType = "string";
            boolean isMetaData = c.getSortingProperty().equals("metadata");
            FieldType fieldType = FieldType.PMM_TITLE;
            if (isMetaData) {
                dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
                fieldType = FieldType.ASSET;
            }
            result.add(new SearchColumn(assetType, xpath, fieldType, dataType, false));
        }
        return result;
    }

    private SortingInfo getSortInfo() {
        return new SortingInfo("lastModifiedTime", SortOrder.DESCENDING, null, FieldType.PMM_TITLE);
    }

    private ExpValue getTitleIdsCriteria(List<Long> titleIds) {
        ArrayList<String> titleIdsStr = new ArrayList<String>();
        for (Long id : titleIds) {
            titleIdsStr.add(String.valueOf(id));
        }
        PredicateRightValue condition = new PredicateRightValue("id", "", FieldType.PMM_TITLE, titleIdsStr, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        return new ExpValue((Predicate)condition);
    }

    private static final /* synthetic */ DistributionPortletData getData_aroundBody0(DistributionPortletServiceImpl ajc$this) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"Sites_View"});
        DistributionPortletData data = new DistributionPortletData();
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        ArrayList<Long> partnerIds = new ArrayList<Long>();
        List partners = parnterService.getPartnersByUserName(userName);
        if (partners.isEmpty()) {
            return new DistributionPortletData();
        }
        for (Partner p : partners) {
            if (p.getType().equals((Object)PartnerType.SELF)) {
                partnerIds = new ArrayList();
                break;
            }
            partnerIds.add(p.getId());
        }
        List titleIds = ajc$this.siteManager.getRecentDistributionActivity(0, ajc$this.getMaxTitleCount(), false, partnerIds);
        List<SearchColumn> searchColumns = ajc$this.getColumns();
        PagingInfo pagingInfo = new PagingInfo(0, ajc$this.getMaxTitleCount());
        TitleFilter filter = new TitleFilter((ExpNode)ajc$this.getTitleIdsCriteria(titleIds));
        filter.setPageInfo(pagingInfo);
        filter.setCriteriaMode(CriteriaMode.MASTER);
        filter.setSortInfo(ajc$this.getSortInfo());
        TitleSearchResult searchResults = ajc$this.searchService.getSearchResults(filter, partnerIds, searchColumns);
        for (Long titleId : titleIds) {
            TitleSearchResult.SearchRow row = searchResults.getRow(titleId.longValue());
            if (row == null) continue;
            Boolean isOffer = false;
            try {
                isOffer = ajc$this.titleManager.isOffer(titleId);
            }
            catch (TitleValidationException e) {
                e.printStackTrace();
            }
            String aggregatedDistributionStatus = row.getFirstValueAsString(0);
            ArrayList<TitleMetadata> titleMetaData = new ArrayList<TitleMetadata>();
            int i = 1;
            while (i < row.getFields().size()) {
                String value = row.getFirstValueAsString(i);
                String assetType = searchColumns.get(i).getSectionType();
                String xpath = searchColumns.get(i).getFieldName();
                titleMetaData.add(new TitleMetadata(xpath, value, assetType));
                ++i;
            }
            DistributionPortletRecord dpd = new DistributionPortletRecord(titleId, titleMetaData, aggregatedDistributionStatus, isOffer);
            data.addRecord(dpd);
        }
        return data;
    }

    private static final /* synthetic */ Object getData_aroundBody1$advice(DistributionPortletServiceImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DistributionPortletServiceImpl.getData_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DistributionPortletData object = DistributionPortletServiceImpl.getData_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

