/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server.util;

import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.HashSet;
import java.util.Set;

public class MetadataTreeConverter {
    private static final String ECMF_XPATH_PREFIX = "/ECMFSpec/";
    private SearchSchemaHelper searchSchemaHelper = new SearchSchemaHelper();

    public UiMetadataTree convert(UISpecification uiSpecification, Set<String> msoOverridableFields) {
        UiMetadataTree uiMetadataTree = null;
        msoOverridableFields = this.prefixWithECMF(msoOverridableFields);
        if (uiSpecification != null) {
            uiMetadataTree = this.convertTitleConf(null, uiSpecification.getRootTitleConf(), msoOverridableFields);
        }
        return uiMetadataTree;
    }

    private Set<String> prefixWithECMF(Set<String> xPaths) {
        HashSet<String> prefixedXPaths = new HashSet<String>(xPaths.size());
        if (xPaths != null) {
            for (String xPath : xPaths) {
                xPath = ECMF_XPATH_PREFIX + xPath;
                prefixedXPaths.add(xPath);
            }
        }
        return prefixedXPaths;
    }

    private UiMetadataTree convertTitleConf(UiMetadataTree parentUiMetadataTree, TitleConf titleConf, Set<String> msoOverridableFields) {
        UiMetadataTree uiMetadataTree = null;
        if (titleConf != null) {
            uiMetadataTree = new UiMetadataTree();
            uiMetadataTree.setName(titleConf.getName());
            uiMetadataTree.setDisplayName(titleConf.getAlias());
            String xPath = titleConf.getPath();
            uiMetadataTree.setxPath(xPath);
            String fullXPath = this.searchSchemaHelper.prepareSelectXpath(xPath, "").replace("[1]", "");
            if (parentUiMetadataTree != null) {
                uiMetadataTree.setFullName(String.valueOf(parentUiMetadataTree.getFullName()) + "." + titleConf.getName());
                uiMetadataTree.setFullDisplayName(String.valueOf(parentUiMetadataTree.getFullDisplayName()) + "." + titleConf.getAlias());
            } else {
                uiMetadataTree.setFullName(titleConf.getName());
                uiMetadataTree.setFullDisplayName(titleConf.getAlias());
            }
            uiMetadataTree.setFullXPath(fullXPath);
            for (Variable variable : titleConf.getMetadata()) {
                UiMetadataTree variableUiMetadataTree;
                if ("CustomFields".equals(variable.getName()) || (variableUiMetadataTree = this.convertVariable(uiMetadataTree, variable, msoOverridableFields)) == null) continue;
                uiMetadataTree.getChildren().add(variableUiMetadataTree);
            }
            for (CustomFieldGroup customFieldGroup : titleConf.getTitleConfMetadata().customFields.getGroups()) {
                if (customFieldGroup.fields == null || customFieldGroup.fields.isEmpty()) continue;
                String cfgNodeName = "CustomFields";
                String cfgNodeDisplayName = customFieldGroup.displayName;
                String cfgNodeXPath = "/Fields/CustomFields";
                String cfgNodeFullName = String.valueOf(uiMetadataTree.getFullName()) + "." + cfgNodeName;
                String cfgNodeFullDisplayName = String.valueOf(uiMetadataTree.getFullDisplayName()) + "." + cfgNodeDisplayName;
                String cfgNodeFullXPath = uiMetadataTree.getFullXPath();
                UiMetadataTree cfGroupUiMetadataTree = new UiMetadataTree();
                cfGroupUiMetadataTree.setName(cfgNodeName);
                cfGroupUiMetadataTree.setDisplayName(cfgNodeDisplayName);
                cfGroupUiMetadataTree.setxPath(cfgNodeXPath);
                cfGroupUiMetadataTree.setFullName(cfgNodeFullName);
                cfGroupUiMetadataTree.setFullDisplayName(cfgNodeFullDisplayName);
                cfGroupUiMetadataTree.setFullXPath(cfgNodeFullXPath);
                for (CustomField cf : customFieldGroup.fields) {
                    UiMetadataTree cfUiMetadataTree = this.convertCustomField(cfGroupUiMetadataTree, cf, msoOverridableFields);
                    if (cfUiMetadataTree == null) continue;
                    cfGroupUiMetadataTree.getChildren().add(cfUiMetadataTree);
                }
                if (cfGroupUiMetadataTree.getChildren().size() <= 0) continue;
                uiMetadataTree.getChildren().add(cfGroupUiMetadataTree);
            }
            for (TitleConf childTitleConf : titleConf.getChildren()) {
                UiMetadataTree childTitleConfUiMetadataTree = this.convertTitleConf(uiMetadataTree, childTitleConf, msoOverridableFields);
                if (childTitleConfUiMetadataTree == null) continue;
                uiMetadataTree.getChildren().add(childTitleConfUiMetadataTree);
            }
            if (parentUiMetadataTree != null && uiMetadataTree.getChildren().size() < 1) {
                uiMetadataTree = null;
            }
        }
        return uiMetadataTree;
    }

    private UiMetadataTree convertVariable(UiMetadataTree parentUiMetadataTree, Variable variable, Set<String> msoOverridableFields) {
        UiMetadataTree uiMetadataTree = null;
        if (variable != null) {
            String variableName = variable.getName();
            String variableDisplayName = variable.getDisplayName();
            String variableXPath = variable.getXPath();
            String nodeFullName = variableName;
            String nodeFullDisplayName = variableDisplayName;
            String nodeFullXPath = variableXPath;
            if (parentUiMetadataTree != null) {
                nodeFullName = String.valueOf(parentUiMetadataTree.getFullName()) + "." + variableName;
                nodeFullDisplayName = String.valueOf(parentUiMetadataTree.getFullDisplayName()) + "." + variableDisplayName;
                nodeFullXPath = String.valueOf(parentUiMetadataTree.getFullXPath()) + variableXPath;
            }
            uiMetadataTree = new UiMetadataTree();
            uiMetadataTree.setName(variableName);
            uiMetadataTree.setDisplayName(variableDisplayName);
            uiMetadataTree.setxPath(variableXPath);
            uiMetadataTree.setFullName(nodeFullName);
            uiMetadataTree.setFullDisplayName(nodeFullDisplayName);
            uiMetadataTree.setFullXPath(nodeFullXPath);
            if (variable instanceof SimpleVariable) {
                if (!msoOverridableFields.contains(nodeFullXPath)) {
                    uiMetadataTree = null;
                }
            } else if (variable instanceof ComplexVariable) {
                uiMetadataTree.setFullXPath(parentUiMetadataTree.getFullXPath());
                ComplexVariable complexVariable = (ComplexVariable)variable;
                for (Variable childVariable : complexVariable.getChildren()) {
                    UiMetadataTree childVariableUiMetadataTree = this.convertVariable(uiMetadataTree, childVariable, msoOverridableFields);
                    if (childVariableUiMetadataTree == null) continue;
                    uiMetadataTree.getChildren().add(childVariableUiMetadataTree);
                }
                if (uiMetadataTree.getChildren().size() < 1) {
                    uiMetadataTree = null;
                }
            }
        }
        return uiMetadataTree;
    }

    private UiMetadataTree convertCustomField(UiMetadataTree parentUiMetadataTree, CustomField customField, Set<String> msoOverridableFields) {
        UiMetadataTree uiMetadataTree = null;
        if (customField != null) {
            String parentXpath = "/Fields/CustomFields/CustomField[@name=" + customField.name + "]";
            String xpath = String.valueOf(parentXpath) + "/@value";
            String nodeName = customField.name;
            String nodeDisplayName = customField.displayName;
            String nodeXPath = xpath;
            String nodeFullName = nodeName;
            String nodeFullDisplayName = nodeDisplayName;
            String nodeFullXPath = nodeXPath;
            if (parentUiMetadataTree != null) {
                nodeFullName = String.valueOf(parentUiMetadataTree.getFullName()) + "." + nodeFullName;
                nodeFullDisplayName = String.valueOf(parentUiMetadataTree.getFullDisplayName()) + "." + nodeFullDisplayName;
                nodeFullXPath = String.valueOf(parentUiMetadataTree.getFullXPath()) + nodeFullXPath;
            }
            if (msoOverridableFields.contains(nodeFullXPath)) {
                uiMetadataTree = new UiMetadataTree();
                uiMetadataTree.setName(nodeName);
                uiMetadataTree.setDisplayName(nodeDisplayName);
                uiMetadataTree.setxPath(nodeXPath);
                uiMetadataTree.setFullName(nodeFullName);
                uiMetadataTree.setFullDisplayName(nodeFullDisplayName);
                uiMetadataTree.setFullXPath(nodeFullXPath);
            }
        }
        return uiMetadataTree;
    }
}

